/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class HTMLPrinter {
    private HTMLPrinter() {
    }

    private static String replace(String string, char c, String string2) {
        int n = 0;
        int n2 = string.indexOf(c, n);
        if (n2 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string2);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String convertToHTMLContent(String string) {
        string = HTMLPrinter.replace(string, '<', "&lt;");
        return HTMLPrinter.replace(string, '>', "&gt;");
    }

    public static String read(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        try {
            int n = reader.read(cArray);
            while (n > 0) {
                stringBuffer.append(cArray, 0, n);
                n = reader.read(cArray);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n, RGB rGB) {
        if (rGB == null) {
            HTMLPrinter.insertPageProlog(stringBuffer, n);
        } else {
            StringBuffer stringBuffer2 = new StringBuffer(60);
            stringBuffer2.append("<html><body text=\"#000000\" bgcolor=\"");
            HTMLPrinter.appendColor(stringBuffer2, rGB);
            stringBuffer2.append("\"><font size=-1>");
            stringBuffer.insert(n, stringBuffer2.toString());
        }
    }

    private static void appendColor(StringBuffer stringBuffer, RGB rGB) {
        stringBuffer.append('#');
        stringBuffer.append(Integer.toHexString(rGB.red));
        stringBuffer.append(Integer.toHexString(rGB.green));
        stringBuffer.append(Integer.toHexString(rGB.blue));
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n) {
        Display display;
        RGB rGB = null;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (display = iWorkbenchWindow.getShell().getDisplay()) != null && !display.isDisposed()) {
            rGB = display.getSystemColor(29).getRGB();
        }
        if (rGB == null) {
            rGB = new RGB(255, 255, 225);
        }
        HTMLPrinter.insertPageProlog(stringBuffer, n, rGB);
    }

    public static void addPageProlog(StringBuffer stringBuffer) {
        HTMLPrinter.insertPageProlog(stringBuffer, stringBuffer.length());
    }

    public static void addPageEpilog(StringBuffer stringBuffer) {
        stringBuffer.append("</font></body></html>");
    }

    public static void startBulletList(StringBuffer stringBuffer) {
        stringBuffer.append("<ul>");
    }

    public static void endBulletList(StringBuffer stringBuffer) {
        stringBuffer.append("</ul>");
    }

    public static void addBullet(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<li>");
            stringBuffer.append(string);
            stringBuffer.append("</li>");
        }
    }

    public static void addSmallHeader(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<h5>");
            stringBuffer.append(string);
            stringBuffer.append("</h5>");
        }
    }

    public static void addParagraph(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<p>");
            stringBuffer.append(string);
        }
    }

    public static void addParagraph(StringBuffer stringBuffer, Reader reader) {
        if (reader != null) {
            HTMLPrinter.addParagraph(stringBuffer, HTMLPrinter.read(reader));
        }
    }
}

