/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    static final int DEFAULT_WIDTH = 16;
    static final int DEFAULT_HEIGHT = 16;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private Image fBase;
    private ImageDescriptor[] fOverlays;
    private Point fSize;

    public OverlayImageDescriptor(Image image, ImageDescriptor[] imageDescriptorArray) {
        this(image, imageDescriptorArray, new Point(16, 16));
    }

    public OverlayImageDescriptor(Image image, ImageDescriptor[] imageDescriptorArray, Point point) {
        this.setBase(image);
        this.setOverlays(imageDescriptorArray);
        this.setSize(point);
    }

    protected void drawOverlays(ImageDescriptor[] imageDescriptorArray) {
        Point point = this.getSize();
        int n = 0;
        while (n < imageDescriptorArray.length) {
            ImageDescriptor imageDescriptor = imageDescriptorArray[n];
            if (imageDescriptor != null) {
                ImageData imageData = imageDescriptor.getImageData();
                if (imageData == null) {
                    imageData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (n) {
                    case 0: {
                        this.drawImage(imageData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(imageData, point.x - imageData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(imageData, 0, point.y - imageData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(imageData, point.x - imageData.width, point.y - imageData.height);
                    }
                }
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof OverlayImageDescriptor)) {
            return false;
        }
        OverlayImageDescriptor overlayImageDescriptor = (OverlayImageDescriptor)((Object)object);
        return this.getBase().equals((Object)overlayImageDescriptor.getBase()) && Arrays.equals(this.getOverlays(), overlayImageDescriptor.getOverlays());
    }

    public int hashCode() {
        int n = this.getBase().hashCode();
        int n2 = 0;
        while (n2 < this.getOverlays().length) {
            if (this.getOverlays()[n2] != null) {
                n ^= this.getOverlays()[n2].hashCode();
            }
            ++n2;
        }
        return n;
    }

    protected void drawCompositeImage(int n, int n2) {
        this.drawImage(this.getBase().getImageData(), 0, 0);
        this.drawOverlays(this.getOverlays());
    }

    protected Point getSize() {
        return this.fSize;
    }

    private Image getBase() {
        return this.fBase;
    }

    private void setBase(Image image) {
        this.fBase = image;
    }

    private ImageDescriptor[] getOverlays() {
        return this.fOverlays;
    }

    private void setOverlays(ImageDescriptor[] imageDescriptorArray) {
        this.fOverlays = imageDescriptorArray;
    }

    private void setSize(Point point) {
        this.fSize = point;
    }
}

