/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fInfo;
    private IWorkbenchPart fTargetPart;
    private IBreakpoint fBreakpoint;

    protected IBreakpoint determineBreakpoint() {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(CDebugCorePlugin.getUniqueIdentifier());
        int n = 0;
        while (n < iBreakpointArray.length) {
            ICLineBreakpoint iCLineBreakpoint;
            IBreakpoint iBreakpoint = iBreakpointArray[n];
            if (iBreakpoint instanceof ICLineBreakpoint && this.breakpointAtRulerLine(iCLineBreakpoint = (ICLineBreakpoint)iBreakpoint)) {
                return iCLineBreakpoint;
            }
            ++n;
        }
        return null;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo iVerticalRulerInfo) {
        this.fInfo = iVerticalRulerInfo;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected void setTargetPart(IWorkbenchPart iWorkbenchPart) {
        this.fTargetPart = iWorkbenchPart;
    }

    protected IBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IBreakpoint iBreakpoint) {
        this.fBreakpoint = iBreakpoint;
    }

    protected boolean breakpointAtRulerLine(ICLineBreakpoint iCLineBreakpoint) {
        int n = this.getBreakpointLine(iCLineBreakpoint);
        int n2 = this.getInfo().getLineOfLastMouseButtonActivity();
        return n2 == n;
    }

    private int getBreakpointLine(ICLineBreakpoint iCLineBreakpoint) {
        if (this.getTargetPart() instanceof ISaveablePart && ((ISaveablePart)this.getTargetPart()).isDirty()) {
            try {
                return iCLineBreakpoint.getLineNumber();
            }
            catch (CoreException coreException) {
                DebugPlugin.log((Throwable)coreException);
            }
        } else {
            IDocument iDocument;
            Position position = this.getBreakpointPosition(iCLineBreakpoint);
            if (position != null && (iDocument = this.getDocument()) != null) {
                try {
                    return iDocument.getLineOfOffset(position.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    DebugPlugin.log((Throwable)badLocationException);
                }
            }
        }
        return -1;
    }

    private Position getBreakpointPosition(ICLineBreakpoint iCLineBreakpoint) {
        IAnnotationModel iAnnotationModel = this.getAnnotationModel();
        if (iAnnotationModel != null) {
            Iterator iterator = iAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!(annotation instanceof MarkerAnnotation) || !((MarkerAnnotation)annotation).getMarker().equals((Object)iCLineBreakpoint.getMarker())) continue;
                return iAnnotationModel.getPosition(annotation);
            }
        }
        return null;
    }

    private IDocument getDocument() {
        DisassemblyView disassemblyView;
        DisassemblyDocumentProvider disassemblyDocumentProvider;
        IWorkbenchPart iWorkbenchPart = this.getTargetPart();
        if (iWorkbenchPart instanceof ITextEditor) {
            ITextEditor iTextEditor = (ITextEditor)iWorkbenchPart;
            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
            if (iDocumentProvider != null) {
                return iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
            }
        } else if (iWorkbenchPart instanceof DisassemblyView && (disassemblyDocumentProvider = (disassemblyView = (DisassemblyView)iWorkbenchPart).getDocumentProvider()) != null) {
            return disassemblyDocumentProvider.getDocument(disassemblyView.getInput());
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        DisassemblyView disassemblyView;
        DisassemblyDocumentProvider disassemblyDocumentProvider;
        IWorkbenchPart iWorkbenchPart = this.getTargetPart();
        if (iWorkbenchPart instanceof ITextEditor) {
            ITextEditor iTextEditor = (ITextEditor)iWorkbenchPart;
            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
            if (iDocumentProvider != null) {
                return iDocumentProvider.getAnnotationModel((Object)iTextEditor.getEditorInput());
            }
        } else if (iWorkbenchPart instanceof DisassemblyView && (disassemblyDocumentProvider = (disassemblyView = (DisassemblyView)iWorkbenchPart).getDocumentProvider()) != null) {
            return disassemblyDocumentProvider.getAnnotationModel(disassemblyView.getInput());
        }
        return null;
    }
}

