/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractDebugActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
ISelectionListener,
INullSelectionListener {
    private IAction fAction;
    private IViewPart fViewPart;
    private IStructuredSelection fSelection;
    private boolean fInitialized = false;
    protected IWorkbenchWindow fWindow;

    public void dispose() {
        if (this.getWindow() != null) {
            this.getWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.setWindow(iWorkbenchWindow);
        iWorkbenchWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    public void run(IAction iAction) {
        IStructuredSelection iStructuredSelection = this.getSelection();
        final Iterator iterator = iStructuredSelection.iterator();
        String string = DebugUIPlugin.getUniqueIdentifier();
        final MultiStatus multiStatus = new MultiStatus(string, 5012, this.getStatusMessage(), null);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    try {
                        AbstractDebugActionDelegate.this.doAction(e);
                    }
                    catch (DebugException debugException) {
                        multiStatus.merge(debugException.getStatus());
                    }
                }
            }
        });
        if (!multiStatus.isOK()) {
            IWorkbenchWindow iWorkbenchWindow = DebugUIPlugin.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null) {
                DebugUIPlugin.errorDialog((Shell)iWorkbenchWindow.getShell(), (String)this.getErrorDialogTitle(), (String)this.getErrorDialogMessage(), (IStatus)multiStatus);
            } else {
                DebugUIPlugin.log((IStatus)multiStatus);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        boolean bl = this.initialize(iAction, iSelection);
        if (!bl && this.getView() != null) {
            this.update(iAction, iSelection);
        }
    }

    protected void update(IAction iAction, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            iAction.setEnabled(this.getEnableStateForSelection(iStructuredSelection));
            this.setSelection(iStructuredSelection);
        } else {
            iAction.setEnabled(false);
            this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected abstract void doAction(Object var1) throws DebugException;

    protected String getErrorDialogTitle() {
        return null;
    }

    protected String getErrorDialogMessage() {
        return null;
    }

    protected String getStatusMessage() {
        return "";
    }

    public void init(IViewPart iViewPart) {
        this.fViewPart = iViewPart;
    }

    protected IViewPart getView() {
        return this.fViewPart;
    }

    protected boolean initialize(IAction iAction, ISelection iSelection) {
        if (!this.isInitialized()) {
            IWorkbenchPage iWorkbenchPage;
            IWorkbenchWindow iWorkbenchWindow;
            this.setAction(iAction);
            if (this.getView() == null && (iWorkbenchWindow = this.getWindow()) != null && iWorkbenchWindow.getShell() != null && !iWorkbenchWindow.getShell().isDisposed() && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                iSelection = iWorkbenchPage.getSelection("org.eclipse.debug.ui.DebugView");
            }
            this.update(iAction, iSelection);
            this.setInitialized(true);
            return true;
        }
        return false;
    }

    protected IStructuredSelection getSelection() {
        if (this.getView() != null) {
            ISelection iSelection = this.getView().getViewSite().getSelectionProvider().getSelection();
            return iSelection instanceof IStructuredSelection ? (IStructuredSelection)iSelection : StructuredSelection.EMPTY;
        }
        return this.fSelection;
    }

    private void setSelection(IStructuredSelection iStructuredSelection) {
        this.fSelection = iStructuredSelection;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        this.update(this.getAction(), iSelection);
    }

    protected void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setView(IViewPart iViewPart) {
        this.fViewPart = iViewPart;
    }

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected void setInitialized(boolean bl) {
        this.fInitialized = bl;
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    protected boolean getEnableStateForSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 0) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.isEnabledFor(e)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEnabledFor(Object object) {
        return true;
    }
}

