/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractEditorActionDelegate
extends ActionDelegate
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate,
IPartListener,
ISelectionListener,
INullSelectionListener {
    private IAction fAction;
    private IWorkbenchWindow fWorkbenchWindow;
    private IWorkbenchPart fTargetPart;
    private IDebugTarget fDebugTarget = null;

    public void dispose() {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            iWorkbenchWindow.getPartService().removePartListener((IPartListener)this);
            iWorkbenchWindow.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.setWorkbenchWindow(iWorkbenchWindow);
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            this.setTargetPart(iWorkbenchPage.getActivePart());
        }
        iWorkbenchWindow.getPartService().addPartListener((IPartListener)this);
        iWorkbenchWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.initializeDebugTarget();
        this.update();
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.setAction(iAction);
        if (this.getWorkbenchWindow() == null) {
            IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
            this.setWorkbenchWindow(iWorkbenchWindow);
            if (iWorkbenchWindow != null) {
                iWorkbenchWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            }
        }
        this.setTargetPart((IWorkbenchPart)iEditorPart);
        this.initializeDebugTarget();
        this.update();
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        this.setTargetPart(iWorkbenchPart);
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.getTargetPart()) {
            this.setTargetPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public abstract void selectionChanged(IWorkbenchPart var1, ISelection var2);

    public abstract void run(IAction var1);

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.setAction(iAction);
        this.update();
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected void setTargetPart(IWorkbenchPart iWorkbenchPart) {
        this.fTargetPart = iWorkbenchPart;
    }

    protected ISelection getTargetSelection() {
        ISelectionProvider iSelectionProvider;
        IWorkbenchPart iWorkbenchPart = this.getTargetPart();
        if (iWorkbenchPart != null && (iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider()) != null) {
            return iSelectionProvider.getSelection();
        }
        return null;
    }

    protected void setDebugTarget(IDebugTarget iDebugTarget) {
        this.fDebugTarget = iDebugTarget;
    }

    protected IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected void setWorkbenchWindow(IWorkbenchWindow iWorkbenchWindow) {
        this.fWorkbenchWindow = iWorkbenchWindow;
    }

    protected void update() {
        IAction iAction = this.getAction();
        if (iAction != null) {
            iAction.setEnabled(this.getDebugTarget() != null && this.getTargetPart() != null);
        }
    }

    protected abstract void initializeDebugTarget();
}

