/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.ICUpdateManager;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractViewActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractRefreshActionDelegate
extends AbstractViewActionDelegate {
    protected String getErrorDialogTitle() {
        return ActionMessages.getString("AbstractRefreshActionDelegate.Error_1");
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.getString("AbstractRefreshActionDelegate.Error(s)_occurred_refreshing_the_view_1");
    }

    protected void doAction() throws DebugException {
        ICUpdateManager iCUpdateManager;
        if (this.getView() != null && (iCUpdateManager = this.getUpdateManager(this.getView().getViewer().getInput())) != null) {
            iCUpdateManager.update();
        }
    }

    protected void update() {
        IAction iAction = this.getAction();
        if (iAction != null) {
            ICUpdateManager iCUpdateManager;
            boolean bl = false;
            IStructuredSelection iStructuredSelection = this.getSelection();
            if (!iStructuredSelection.isEmpty() && (iCUpdateManager = this.getUpdateManager(iStructuredSelection.getFirstElement())) != null && iCUpdateManager.canUpdate()) {
                bl = true;
            }
            iAction.setEnabled(bl);
        }
    }

    protected void doHandleDebugEvent(DebugEvent debugEvent) {
        switch (debugEvent.getKind()) {
            case 8: {
                this.update();
                break;
            }
            case 1: {
                if (debugEvent.isEvaluation() && (debugEvent.getDetail() & 0x80) != 0) break;
                this.update();
                break;
            }
            case 2: {
                this.update();
            }
        }
    }

    protected abstract ICUpdateManager getUpdateManager(Object var1);
}

