/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractViewActionDelegate
extends ActionDelegate
implements IViewActionDelegate,
ISelectionListener,
INullSelectionListener,
IDebugEventSetListener {
    private IAction fAction;
    private IDebugView fView;
    private IStructuredSelection fSelection = StructuredSelection.EMPTY;

    public void init(IViewPart iViewPart) {
        IAdaptable iAdaptable;
        this.setView(iViewPart);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        IWorkbenchWindow iWorkbenchWindow = this.getWindow();
        if (iWorkbenchWindow != null) {
            iWorkbenchWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        StructuredSelection structuredSelection = (iAdaptable = DebugUITools.getDebugContext()) != null ? new StructuredSelection((Object)iAdaptable) : StructuredSelection.EMPTY;
        this.selectionChanged(null, (ISelection)structuredSelection);
    }

    public void dispose() {
        IWorkbenchWindow iWorkbenchWindow = this.getWindow();
        if (iWorkbenchWindow != null) {
            iWorkbenchWindow.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    public void init(IAction iAction) {
        this.setAction(iAction);
        iAction.setEnabled(false);
        super.init(iAction);
    }

    protected IDebugView getView() {
        return this.fView;
    }

    private void setView(IViewPart iViewPart) {
        this.fView = iViewPart instanceof IDebugView ? (IDebugView)iViewPart : null;
    }

    public void run(IAction iAction) {
        final MultiStatus multiStatus = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, "", null);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    AbstractViewActionDelegate.this.doAction();
                }
                catch (DebugException debugException) {
                    multiStatus.merge(debugException.getStatus());
                }
            }
        });
        if (!multiStatus.isOK()) {
            IWorkbenchWindow iWorkbenchWindow = DebugUIPlugin.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null) {
                DebugUIPlugin.errorDialog((Shell)iWorkbenchWindow.getShell(), (String)this.getErrorDialogTitle(), (String)this.getErrorDialogMessage(), (IStatus)multiStatus.getChildren()[0]);
            } else {
                DebugUIPlugin.log((IStatus)multiStatus);
            }
        }
    }

    protected IAction getAction() {
        return this.fAction;
    }

    private void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    private IWorkbenchWindow getWindow() {
        if (this.getView() != null) {
            return this.getView().getViewSite().getWorkbenchWindow();
        }
        return null;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        this.setSelection(iSelection);
        this.update();
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected void setSelection(ISelection iSelection) {
        this.fSelection = iSelection instanceof IStructuredSelection ? (IStructuredSelection)iSelection : StructuredSelection.EMPTY;
    }

    public void handleDebugEvents(final DebugEvent[] debugEventArray) {
        if (this.getWindow() == null || this.getAction() == null) {
            return;
        }
        Shell shell = this.getWindow().getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                int n = 0;
                while (n < debugEventArray.length) {
                    if (debugEventArray[n].getSource() != null) {
                        AbstractViewActionDelegate.this.doHandleDebugEvent(debugEventArray[n]);
                    }
                    ++n;
                }
            }
        };
        shell.getDisplay().asyncExec(runnable);
    }

    protected abstract String getErrorDialogTitle();

    protected abstract String getErrorDialogMessage();

    protected abstract void doAction() throws DebugException;

    protected abstract void update();

    protected abstract void doHandleDebugEvent(DebugEvent var1);
}

