/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ExpressionDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionDelegate;

public class AddExpressionEditorActionDelegate
extends ActionDelegate
implements IEditorActionDelegate {
    private IEditorPart fEditorPart;

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.setEditorPart(iEditorPart);
    }

    private IEditorPart getEditorPart() {
        return this.fEditorPart;
    }

    private void setEditorPart(IEditorPart iEditorPart) {
        this.fEditorPart = iEditorPart;
    }

    public void run(IAction iAction) {
        String string = this.getSelectedText();
        ExpressionDialog expressionDialog = new ExpressionDialog(this.getShell(), string);
        if (expressionDialog.open() != 0) {
            return;
        }
        this.createExpression(expressionDialog.getExpression());
    }

    private String getSelectedText() {
        ISelection iSelection = this.getTargetSelection();
        if (iSelection != null && iSelection instanceof ITextSelection) {
            return ((ITextSelection)iSelection).getText().trim();
        }
        return "";
    }

    protected ISelection getTargetSelection() {
        ISelectionProvider iSelectionProvider;
        IEditorPart iEditorPart = this.getEditorPart();
        if (iEditorPart != null && (iSelectionProvider = iEditorPart.getSite().getSelectionProvider()) != null) {
            return iSelectionProvider.getSelection();
        }
        return null;
    }

    private void createExpression(String string) {
        IWatchExpression iWatchExpression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(string);
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)iWatchExpression);
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        if (iAdaptable instanceof IDebugElement) {
            iWatchExpression.setExpressionContext((IDebugElement)iAdaptable);
        }
    }

    protected Shell getShell() {
        return this.getEditorPart() != null ? this.getEditorPart().getSite().getShell() : CDebugUIPlugin.getActiveWorkbenchShell();
    }
}

