/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.ICGlobalVariableManager;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class AddGlobalsActionDelegate
extends ActionDelegate
implements IViewActionDelegate,
ISelectionListener,
IPartListener {
    private IGlobalVariableDescriptor[] fGlobals;
    private IViewPart fView = null;
    private IAction fAction;
    private IStructuredSelection fSelection;
    private IStatus fStatus = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(IViewPart iViewPart) {
        this.fView = iViewPart;
        iViewPart.getSite().getPage().addPartListener((IPartListener)this);
        iViewPart.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart != null && iWorkbenchPart.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            if (iSelection instanceof IStructuredSelection) {
                this.setSelection((IStructuredSelection)iSelection);
            } else {
                this.setSelection(null);
            }
            this.update(this.getAction());
        }
    }

    public void run(IAction iAction) {
        final IStructuredSelection iStructuredSelection = this.getSelection();
        if (iStructuredSelection != null && iStructuredSelection.size() != 1) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    AddGlobalsActionDelegate.this.doAction(iStructuredSelection.getFirstElement());
                    AddGlobalsActionDelegate.this.setStatus(null);
                }
                catch (DebugException debugException) {
                    AddGlobalsActionDelegate.this.setStatus(debugException.getStatus());
                }
            }
        });
        IStatus iStatus = this.getStatus();
        if (iStatus != null && !iStatus.isOK()) {
            IWorkbenchWindow iWorkbenchWindow;
            if (iStatus.isMultiStatus()) {
                iStatus = new MultiStatus(iStatus.getPlugin(), iStatus.getCode(), iStatus.getChildren(), ActionMessages.getString("AddGlobalsActionDelegate.Error(s)_occured_adding_globals_1"), iStatus.getException());
            }
            if ((iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow()) != null) {
                CDebugUIPlugin.errorDialog(this.getErrorDialogMessage(), iStatus);
            } else {
                CDebugUIPlugin.log(iStatus);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.setAction(iAction);
        if (this.getView() != null) {
            this.update(iAction);
        }
    }

    protected void update(IAction iAction) {
        if (iAction != null) {
            iAction.setEnabled(this.getEnableStateForSelection(this.getSelection()));
        }
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart.equals(this.getView())) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart iViewPart) {
        this.fView = iViewPart;
    }

    protected void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    private void setSelection(IStructuredSelection iStructuredSelection) {
        this.fSelection = iStructuredSelection;
    }

    private IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public void dispose() {
        if (this.getView() != null) {
            this.getView().getViewSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            this.getView().getViewSite().getPage().removePartListener((IPartListener)this);
        }
    }

    protected boolean getEnableStateForSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null || iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object != null && object instanceof IDebugElement) {
            IDebugTarget iDebugTarget = ((IDebugElement)object).getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iDebugTarget.getAdapter((Class)clazz) != null) {
                return true;
            }
        }
        return false;
    }

    private ListSelectionDialog createDialog() {
        return new ListSelectionDialog(this.getView().getSite().getShell(), (Object)this.fGlobals, new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return AddGlobalsActionDelegate.this.getGlobals();
            }
        }, (ILabelProvider)new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof IGlobalVariableDescriptor) {
                    int n;
                    String string = "";
                    if (((IGlobalVariableDescriptor)object).getPath() != null && (n = (string = ((IGlobalVariableDescriptor)object).getPath().toString()).lastIndexOf(47)) != -1) {
                        string = string.substring(n + 1);
                    }
                    return String.valueOf(string.length() > 0 ? String.valueOf('\'') + string + "'::" : "") + ((IGlobalVariableDescriptor)object).getName();
                }
                return null;
            }
        }, ActionMessages.getString("AddGlobalsActionDelegate.0"));
    }

    protected IGlobalVariableDescriptor[] getGlobals() {
        return this.fGlobals;
    }

    protected void doAction(Object object) throws DebugException {
        if (this.getView() == null) {
            return;
        }
        if (object != null && object instanceof IDebugElement) {
            IDebugTarget iDebugTarget = ((IDebugElement)object).getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IExecFileInfo iExecFileInfo = (IExecFileInfo)iDebugTarget.getAdapter((Class)clazz);
            IDebugTarget iDebugTarget2 = ((IDebugElement)object).getDebugTarget();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.core.ICGlobalVariableManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ICGlobalVariableManager iCGlobalVariableManager = (ICGlobalVariableManager)iDebugTarget2.getAdapter((Class)clazz2);
            if (iExecFileInfo != null && iCGlobalVariableManager != null) {
                this.fGlobals = iExecFileInfo.getGlobals();
                ListSelectionDialog listSelectionDialog = this.createDialog();
                if (listSelectionDialog.open() == 0) {
                    List<Object> list = Arrays.asList(listSelectionDialog.getResult());
                    IGlobalVariableDescriptor[] iGlobalVariableDescriptorArray = list.toArray(new IGlobalVariableDescriptor[list.size()]);
                    iCGlobalVariableManager.addGlobals(iGlobalVariableDescriptorArray);
                }
            }
        }
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.getString("AddGlobalsActionDelegate.1");
    }

    protected void setStatus(IStatus iStatus) {
        this.fStatus = iStatus;
    }

    protected IStatus getStatus() {
        return this.fStatus;
    }

    public void init(IAction iAction) {
        super.init(iAction);
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        this.setSelection((IStructuredSelection)(iAdaptable != null ? new StructuredSelection((Object)iAdaptable) : new StructuredSelection()));
        this.update(iAction);
    }
}

