/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointDialog;
import org.eclipse.cdt.debug.internal.ui.actions.WatchpointExpressionVerifier;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class AddWatchpointActionDelegate
extends ActionDelegate
implements IWorkbenchWindowActionDelegate,
IPartListener {
    private boolean fInitialized = false;
    private IAction fAction = null;
    private ITextEditor fTextEditor = null;
    private IWorkbenchWindow fWorkbenchWindow = null;
    private IResource fResource = null;
    private String fSourceHandle = "";

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.setWorkbenchWindow(iWorkbenchWindow);
        iWorkbenchWindow.getPartService().addPartListener((IPartListener)this);
    }

    public void run(IAction iAction) {
        String string = this.getSelectedExpression();
        AddWatchpointDialog addWatchpointDialog = new AddWatchpointDialog(CDebugUIPlugin.getActiveWorkbenchShell(), true, false, string);
        if (addWatchpointDialog.open() != 0) {
            return;
        }
        if (this.getTextEditor() != null) {
            this.update();
            this.addWatchpoint(this.getTextEditor().getEditorInput(), addWatchpointDialog.getWriteAccess(), addWatchpointDialog.getReadAccess(), addWatchpointDialog.getExpression());
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (!this.fInitialized) {
            IEditorPart iEditorPart;
            IWorkbenchPage iWorkbenchPage;
            this.setAction(iAction);
            if (this.getWorkbenchWindow() != null && (iWorkbenchPage = this.getWorkbenchWindow().getActivePage()) != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) instanceof ITextEditor) {
                this.setTextEditor((ITextEditor)iEditorPart);
            }
            this.fInitialized = true;
        }
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected void setWorkbenchWindow(IWorkbenchWindow iWorkbenchWindow) {
        this.fWorkbenchWindow = iWorkbenchWindow;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor iTextEditor) {
        this.fTextEditor = iTextEditor;
        if (this.fTextEditor != null) {
            IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
            this.setSourceHandle(iEditorInput);
            this.setResource(iEditorInput);
        }
        this.setEnabledState(iTextEditor);
    }

    protected String getSelectedExpression() {
        ISelection iSelection;
        ISelectionProvider iSelectionProvider;
        if (this.getTextEditor() != null && (iSelectionProvider = this.getTextEditor().getSelectionProvider()) != null && (iSelection = iSelectionProvider.getSelection()) instanceof ITextSelection) {
            return ((ITextSelection)iSelection).getText().trim();
        }
        return "";
    }

    protected void update(ISelection iSelection) {
        this.setEnabledState(this.getTextEditor());
    }

    protected void update() {
        IAction iAction = this.getAction();
        if (iAction != null) {
            iAction.setEnabled(this.getTextEditor() != null);
        }
    }

    protected void setEnabledState(ITextEditor iTextEditor) {
        if (this.getAction() != null) {
            this.getAction().setEnabled(iTextEditor != null);
        }
    }

    protected IResource getResource() {
        return this.fResource;
    }

    protected void setResource(IEditorInput iEditorInput) {
        this.fResource = iEditorInput instanceof IFileEditorInput ? ((IFileEditorInput)iEditorInput).getFile().getProject() : ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void addWatchpoint(IEditorInput iEditorInput, boolean bl, boolean bl2, String string) {
        if (this.getResource() == null) {
            return;
        }
        WatchpointExpressionVerifier watchpointExpressionVerifier = new WatchpointExpressionVerifier();
        IDocument iDocument = this.getTextEditor().getDocumentProvider().getDocument((Object)iEditorInput);
        if (watchpointExpressionVerifier.isValidExpression(iDocument, string)) {
            try {
                CDIDebugModel.createWatchpoint((String)this.getSourceHandle(), (IResource)this.getResource(), (boolean)bl, (boolean)bl2, (String)string, (boolean)true, (int)0, (String)"", (boolean)true);
            }
            catch (CoreException coreException) {
                CDebugUIPlugin.errorDialog(ActionMessages.getString("AddWatchpointActionDelegate.0"), coreException);
            }
        }
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ITextEditor) {
            this.setTextEditor((ITextEditor)iWorkbenchPart);
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.getTextEditor()) {
            this.setTextEditor(null);
            if (this.getAction() != null) {
                this.getAction().setEnabled(false);
            }
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ITextEditor && this.getTextEditor() == null) {
            this.setTextEditor((ITextEditor)iWorkbenchPart);
        }
    }

    private String getSourceHandle() {
        return this.fSourceHandle;
    }

    private void setSourceHandle(IEditorInput iEditorInput) {
        this.fSourceHandle = "";
        if (iEditorInput instanceof IFileEditorInput) {
            this.fSourceHandle = ((IFileEditorInput)iEditorInput).getFile().getFullPath().toOSString();
        } else if (iEditorInput instanceof IStorageEditorInput) {
            try {
                IPath iPath = ((IStorageEditorInput)iEditorInput).getStorage().getFullPath();
                if (iPath != null) {
                    this.fSourceHandle = iPath.toOSString();
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

