/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CBreakpointPreferencePage
extends FieldEditorPreferencePage {
    private BreakpointStringFieldEditor fCondition;
    private Text fIgnoreCountTextControl;
    private BreakpointIntegerFieldEditor fIgnoreCount;
    private ICBreakpoint fBreakpoint;

    public CBreakpointPreferencePage(ICBreakpoint iCBreakpoint) {
        super(1);
        this.setBreakpoint(iCBreakpoint);
        this.noDefaultAndApplyButton();
    }

    protected void createFieldEditors() {
        ICBreakpoint iCBreakpoint = this.getBreakpoint();
        this.createTypeSpecificLabelFieldEditors(iCBreakpoint);
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        try {
            String string = iCBreakpoint.getCondition();
            if (string == null) {
                string = "";
            }
            iPreferenceStore.setValue("CONDITION", string);
            this.createConditionEditor(this.getFieldEditorParent());
            iPreferenceStore.setValue("ENABLED", iCBreakpoint.isEnabled());
            int n = iCBreakpoint.getIgnoreCount();
            iPreferenceStore.setValue("IGNORE_COUNT", n >= 0 ? n : 0);
            this.createIgnoreCountEditor(this.getFieldEditorParent());
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log(coreException);
        }
    }

    private void createTypeSpecificLabelFieldEditors(ICBreakpoint iCBreakpoint) {
        if (iCBreakpoint instanceof ICFunctionBreakpoint) {
            ICFunctionBreakpoint iCFunctionBreakpoint = (ICFunctionBreakpoint)iCBreakpoint;
            String string = ActionMessages.getString("CBreakpointPreferencePage.1");
            try {
                string = iCFunctionBreakpoint.getFunction();
            }
            catch (CoreException coreException) {
            }
            catch (NumberFormatException numberFormatException) {}
            if (string != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), ActionMessages.getString("CBreakpointPreferencePage.2"), string));
            }
            this.setTitle(ActionMessages.getString("CBreakpointPreferencePage.3"));
        } else if (iCBreakpoint instanceof ICAddressBreakpoint) {
            ICAddressBreakpoint iCAddressBreakpoint = (ICAddressBreakpoint)iCBreakpoint;
            String string = ActionMessages.getString("CBreakpointPreferencePage.4");
            try {
                string = CDebugUtils.toHexAddressString((long)Long.parseLong(iCAddressBreakpoint.getAddress()));
            }
            catch (CoreException coreException) {
            }
            catch (NumberFormatException numberFormatException) {}
            if (string != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), ActionMessages.getString("CBreakpointPreferencePage.5"), string));
            }
            this.setTitle(ActionMessages.getString("CBreakpointPreferencePage.6"));
        } else if (iCBreakpoint instanceof ILineBreakpoint) {
            String string = iCBreakpoint.getMarker().getResource().getLocation().toOSString();
            if (string != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), ActionMessages.getString("CBreakpointPreferencePage.7"), string));
            }
            this.setTitle(ActionMessages.getString("CBreakpointPreferencePage.8"));
            ILineBreakpoint iLineBreakpoint = (ILineBreakpoint)iCBreakpoint;
            StringBuffer stringBuffer = new StringBuffer(4);
            try {
                int n = iLineBreakpoint.getLineNumber();
                if (n > 0) {
                    stringBuffer.append(n);
                }
            }
            catch (CoreException coreException) {
                CDebugUIPlugin.log(coreException);
            }
            if (stringBuffer.length() > 0) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), ActionMessages.getString("CBreakpointPreferencePage.9"), stringBuffer.toString()));
            }
        } else if (iCBreakpoint instanceof ICWatchpoint) {
            String string = iCBreakpoint.getMarker().getResource().getLocation().toOSString();
            if (string != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), ActionMessages.getString("CBreakpointPreferencePage.10"), string));
            }
            ICWatchpoint iCWatchpoint = (ICWatchpoint)iCBreakpoint;
            String string2 = "";
            String string3 = "";
            try {
                string2 = iCWatchpoint.isReadType() && !iCWatchpoint.isWriteType() ? ActionMessages.getString("CBreakpointPreferencePage.11") : (!iCWatchpoint.isReadType() && iCWatchpoint.isWriteType() ? ActionMessages.getString("CBreakpointPreferencePage.12") : ActionMessages.getString("CBreakpointPreferencePage.13"));
                string3 = iCWatchpoint.getExpression();
            }
            catch (CoreException coreException) {
                CDebugUIPlugin.log(coreException);
            }
            this.setTitle(string2);
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), ActionMessages.getString("CBreakpointPreferencePage.14"), string3));
        }
    }

    protected void createConditionEditor(Composite composite) {
        this.fCondition = new BreakpointStringFieldEditor("CONDITION", ActionMessages.getString("CBreakpointPreferencePage.15"), composite);
        this.fCondition.setEmptyStringAllowed(true);
        this.fCondition.setErrorMessage(ActionMessages.getString("CBreakpointPreferencePage.16"));
        this.addField((FieldEditor)this.fCondition);
    }

    protected void createIgnoreCountEditor(Composite composite) {
        this.fIgnoreCount = new BreakpointIntegerFieldEditor("IGNORE_COUNT", ActionMessages.getString("CBreakpointPreferencePage.17"), composite);
        this.fIgnoreCount.setValidRange(0, Integer.MAX_VALUE);
        this.fIgnoreCountTextControl = this.fIgnoreCount.getTextControl(composite);
        try {
            this.fIgnoreCountTextControl.setEnabled(this.getBreakpoint().getIgnoreCount() >= 0);
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log(coreException);
        }
        this.addField((FieldEditor)this.fIgnoreCount);
    }

    protected FieldEditor createLabelEditor(Composite composite, String string, String string2) {
        return new LabelFieldEditor(composite, string, string2);
    }

    protected ICBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(ICBreakpoint iCBreakpoint) {
        this.fBreakpoint = iCBreakpoint;
    }

    class BreakpointIntegerFieldEditor
    extends IntegerFieldEditor {
        public BreakpointIntegerFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
            this.setErrorMessage(ActionMessages.getString("CBreakpointPreferencePage.0"));
        }

        protected boolean checkState() {
            Text text = this.getTextControl();
            if (!text.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String string = this.getPreferencePage().getErrorMessage();
                if (string != null) {
                    if (this.getErrorMessage().equals(string)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class BreakpointStringFieldEditor
    extends StringFieldEditor {
        public BreakpointStringFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
        }

        protected boolean checkState() {
            Text text = this.getTextControl();
            if (!text.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String string = this.getPreferencePage().getErrorMessage();
                if (string != null) {
                    if (this.getErrorMessage().equals(string)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class LabelFieldEditor
    extends FieldEditor {
        private Label fTitleLabel;
        private Label fValueLabel;
        private Composite fBasicComposite;
        private String fValue;
        private String fTitle;

        public LabelFieldEditor(Composite composite, String string, String string2) {
            this.fValue = string2;
            this.fTitle = string;
            this.createControl(composite);
        }

        protected void adjustForNumColumns(int n) {
            ((GridData)this.fBasicComposite.getLayoutData()).horizontalSpan = n;
        }

        protected void doFillIntoGrid(Composite composite, int n) {
            this.fBasicComposite = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.numColumns = 2;
            this.fBasicComposite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.horizontalAlignment = 4;
            this.fBasicComposite.setLayoutData((Object)gridData);
            this.fTitleLabel = new Label(this.fBasicComposite, 0);
            this.fTitleLabel.setText(this.fTitle);
            GridData gridData2 = new GridData();
            gridData2.verticalAlignment = 128;
            this.fTitleLabel.setLayoutData((Object)gridData2);
            this.fValueLabel = new Label(this.fBasicComposite, 64);
            this.fValueLabel.setText(this.fValue);
            gridData2 = new GridData();
            this.fValueLabel.setLayoutData((Object)gridData2);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

