/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class EnableVariablesActionDelegate
implements IViewActionDelegate {
    private IViewPart fView;
    private IAction fAction;

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart iViewPart) {
        this.fView = iViewPart;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    protected boolean isEnableAction() {
        return true;
    }

    public void init(IViewPart iViewPart) {
        this.setView(iViewPart);
    }

    public void run(IAction iAction) {
        IStructuredSelection iStructuredSelection = this.getSelection();
        final int n = iStructuredSelection.size();
        if (n == 0) {
            return;
        }
        final Iterator iterator = iStructuredSelection.iterator();
        final MultiStatus multiStatus = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("EnableVariablesActionDelegate.0"), null);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    ICVariable iCVariable = (ICVariable)iterator.next();
                    try {
                        if (n > 1) {
                            if (EnableVariablesActionDelegate.this.isEnableAction()) {
                                iCVariable.setEnabled(true);
                                continue;
                            }
                            iCVariable.setEnabled(false);
                            continue;
                        }
                        iCVariable.setEnabled(!iCVariable.isEnabled());
                    }
                    catch (DebugException debugException) {
                        multiStatus.merge(debugException.getStatus());
                    }
                }
                EnableVariablesActionDelegate.this.update();
            }
        });
        if (!multiStatus.isOK()) {
            CDebugUIPlugin.errorDialog(ActionMessages.getString("EnableVariablesActionDelegate.1"), (IStatus)multiStatus);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.setAction(iAction);
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof ICVariable)) {
            return;
        }
        Iterator iterator = iStructuredSelection.iterator();
        boolean bl = true;
        boolean bl2 = true;
        while (iterator.hasNext()) {
            ICVariable iCVariable = (ICVariable)iterator.next();
            if (!iCVariable.canEnableDisable()) continue;
            if (iCVariable.isEnabled()) {
                bl2 = false;
                continue;
            }
            bl = false;
        }
        if (this.isEnableAction()) {
            iAction.setEnabled(!bl);
        } else {
            iAction.setEnabled(!bl2);
        }
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getView().getViewSite().getSelectionProvider().getSelection();
    }

    protected void update() {
        this.getView().getViewSite().getSelectionProvider().setSelection(this.getView().getViewSite().getSelectionProvider().getSelection());
    }
}

