/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.IJumpToAddress;
import org.eclipse.cdt.debug.core.model.IJumpToLine;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ResumeAtLineActionDelegate
implements IWorkbenchWindowActionDelegate,
IPartListener,
IUpdate {
    protected IWorkbenchWindow fWindow = null;
    private IWorkbenchPart fActivePart = null;
    private IAction fAction = null;
    private IDebugElement fTargetElement = null;
    private static final ISelection EMPTY_SELECTION = new EmptySelection();
    private ISelectionListener fSelectionListener = new DebugSelectionListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private ISelection getTargetSelection() {
        ISelectionProvider iSelectionProvider;
        if (this.fActivePart != null && (iSelectionProvider = this.fActivePart.getSite().getSelectionProvider()) != null) {
            return iSelectionProvider.getSelection();
        }
        return EMPTY_SELECTION;
    }

    public void dispose() {
        this.fWindow.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", this.fSelectionListener);
        this.fWindow.getPartService().removePartListener((IPartListener)this);
        this.fActivePart = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
        IPartService iPartService = iWorkbenchWindow.getPartService();
        iPartService.addPartListener((IPartListener)this);
        this.fWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", this.fSelectionListener);
        IWorkbenchPart iWorkbenchPart = iPartService.getActivePart();
        if (iWorkbenchPart != null) {
            this.partActivated(iWorkbenchPart);
        }
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        this.fActivePart = iWorkbenchPart;
        this.update();
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        this.clearPart(iWorkbenchPart);
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        this.clearPart(iWorkbenchPart);
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public void update() {
        if (this.fAction == null) {
            return;
        }
        this.fAction.setEnabled(this.canPerformAction(this.getTargetSelection()));
    }

    public void run(IAction iAction) {
        if (this.fTargetElement != null) {
            try {
                this.performAction(this.getTargetSelection());
            }
            catch (CoreException coreException) {
                DebugUIPlugin.errorDialog((Shell)this.fWindow.getShell(), (String)ActionMessages.getString("ResumeAtLineActionDelegate.Error_1"), (String)ActionMessages.getString("ResumeAtLineActionDelegate.Operation_failed_1"), (IStatus)coreException.getStatus());
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fAction = iAction;
        this.update();
    }

    protected void clearPart(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart.equals(this.fActivePart)) {
            this.fActivePart = null;
        }
    }

    protected IDebugElement getTargetElement() {
        return this.fTargetElement;
    }

    protected void setTargetElement(IDebugElement iDebugElement) {
        this.fTargetElement = iDebugElement;
    }

    private boolean canPerformAction(ISelection iSelection) {
        if (this.fTargetElement == null || !this.fTargetElement.getModelIdentifier().equals(CDIDebugModel.getPluginIdentifier())) {
            return false;
        }
        IDebugTarget iDebugTarget = this.fTargetElement.getDebugTarget();
        if (this.fActivePart instanceof IEditorPart) {
            String string;
            IJumpToLine iJumpToLine;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJumpToLine = (IJumpToLine)iDebugTarget.getAdapter((Class)clazz)) == null) {
                return false;
            }
            IEditorPart iEditorPart = (IEditorPart)this.fActivePart;
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput == null) {
                return false;
            }
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iEditorInput);
            if (iDocument == null) {
                return false;
            }
            try {
                string = this.getFileName(iEditorInput);
            }
            catch (CoreException coreException) {
                return false;
            }
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            int n = iTextSelection.getStartLine() + 1;
            return iJumpToLine.canJumpToLine(string, n);
        }
        if (this.fActivePart instanceof DisassemblyView) {
            IJumpToAddress iJumpToAddress;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToAddress");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJumpToAddress = (IJumpToAddress)iDebugTarget.getAdapter((Class)clazz)) == null) {
                return false;
            }
            IEditorInput iEditorInput = ((DisassemblyView)this.fActivePart).getInput();
            if (!(iEditorInput instanceof DisassemblyEditorInput)) {
                return false;
            }
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            int n = iTextSelection.getStartLine() + 1;
            long l = ((DisassemblyEditorInput)iEditorInput).getAddress(n);
            return iJumpToAddress.canJumpToAddress(l);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performAction(ISelection iSelection) throws CoreException {
        IDebugTarget iDebugTarget = this.fTargetElement.getDebugTarget();
        String string = null;
        if (this.fActivePart instanceof IEditorPart) {
            IJumpToLine iJumpToLine;
            IEditorPart iEditorPart = (IEditorPart)this.fActivePart;
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput == null) {
                string = ActionMessages.getString("ResumeAtLineActionDelegate.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
            }
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iEditorInput);
            if (iDocument == null) {
                string = ActionMessages.getString("ResumeAtLineActionDelegate.Missing_document");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
            }
            String string2 = this.getFileName(iEditorInput);
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            int n = iTextSelection.getStartLine() + 1;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJumpToLine = (IJumpToLine)iDebugTarget.getAdapter((Class)clazz)) == null) return;
            iJumpToLine.jumpToLine(string2, n);
            return;
        }
        if (this.fActivePart instanceof DisassemblyView) {
            IJumpToAddress iJumpToAddress;
            IEditorInput iEditorInput = ((DisassemblyView)this.fActivePart).getInput();
            if (!(iEditorInput instanceof DisassemblyEditorInput)) {
                string = ActionMessages.getString("ResumeAtLineActionDelegate.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
            }
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            int n = iTextSelection.getStartLine() + 1;
            long l = ((DisassemblyEditorInput)iEditorInput).getAddress(n);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToAddress");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJumpToAddress = (IJumpToAddress)iDebugTarget.getAdapter((Class)clazz)) == null) return;
            iJumpToAddress.jumpToAddress(l);
            return;
        }
        string = ActionMessages.getString("ResumeAtLineActionDelegate.Operation_is_not_supported_1");
        throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
    }

    private String getFileName(IEditorInput iEditorInput) throws CoreException {
        if (iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile().getName();
        }
        if (iEditorInput instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)iEditorInput).getStorage().getName();
        }
        return null;
    }

    static class EmptySelection
    implements ISelection {
        EmptySelection() {
        }

        public boolean isEmpty() {
            return true;
        }
    }

    class DebugSelectionListener
    implements ISelectionListener {
        DebugSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
            Object object;
            IStructuredSelection iStructuredSelection;
            ResumeAtLineActionDelegate.this.setTargetElement(null);
            if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IDebugElement) {
                ResumeAtLineActionDelegate.this.setTargetElement((IDebugElement)object);
            }
            ResumeAtLineActionDelegate.this.update();
        }
    }
}

