/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractEditorActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.RunToLineAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineActionDelegate
extends AbstractEditorActionDelegate {
    IRunToLineTarget fRunToLineTarget;

    public void run(IAction iAction) {
        if (this.getTargetPart() instanceof ITextEditor) {
            ITextSelection iTextSelection = (ITextSelection)((ITextEditor)this.getTargetPart()).getSelectionProvider().getSelection();
            if (this.getRunToLineTarget() != null) {
                try {
                    this.getRunToLineTarget().runToLine(this.getTargetPart(), (ISelection)iTextSelection, (ISuspendResume)this.getDebugTarget());
                }
                catch (CoreException coreException) {
                    DebugUIPlugin.errorDialog((Shell)this.getTargetPart().getSite().getShell(), (String)ActionMessages.getString("RunToLineActionDelegate.Error_1"), (String)ActionMessages.getString("RunToLineActionDelegate.Operation_failed_1"), (IStatus)coreException.getStatus());
                }
            }
        }
    }

    protected void initializeDebugTarget() {
        IDebugTarget iDebugTarget;
        this.setDebugTarget(null);
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        if (iAdaptable != null && iAdaptable instanceof IDebugElement && (iDebugTarget = ((IDebugElement)iAdaptable).getDebugTarget()) != null && (iDebugTarget instanceof IRunToLine || iDebugTarget instanceof IRunToAddress)) {
            this.setDebugTarget(iDebugTarget);
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IDebugTarget iDebugTarget = null;
        if (iWorkbenchPart != null && iWorkbenchPart.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            IDebugTarget iDebugTarget2;
            Object object;
            if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) != null && object instanceof IDebugElement && (iDebugTarget2 = ((IDebugElement)object).getDebugTarget()) != null && (iDebugTarget2 instanceof IRunToLine || iDebugTarget2 instanceof IRunToAddress)) {
                iDebugTarget = iDebugTarget2;
            }
            this.setDebugTarget(iDebugTarget);
            this.update();
        }
    }

    private IRunToLineTarget getRunToLineTarget() {
        if (this.fRunToLineTarget == null) {
            this.fRunToLineTarget = new RunToLineAdapter();
        }
        return this.fRunToLineTarget;
    }
}

