/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class SignalActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICSignal fSignal = null;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        if (this.getSignal() != null) {
            final MultiStatus multiStatus = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("SignalActionDelegate.0"), null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        SignalActionDelegate.this.doAction(SignalActionDelegate.this.getSignal());
                    }
                    catch (DebugException debugException) {
                        multiStatus.merge(debugException.getStatus());
                    }
                }
            });
            if (!multiStatus.isOK()) {
                IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    CDebugUIPlugin.errorDialog(ActionMessages.getString("SignalActionDelegate.1"), (IStatus)multiStatus);
                } else {
                    CDebugUIPlugin.log((IStatus)multiStatus);
                }
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof ICSignal) {
            boolean bl = this.enablesFor((ICSignal)object);
            iAction.setEnabled(bl);
            if (bl) {
                this.setSignal((ICSignal)object);
                return;
            }
        }
        iAction.setEnabled(false);
        this.setSignal(null);
    }

    protected void doAction(ICSignal iCSignal) throws DebugException {
        iCSignal.signal();
    }

    private boolean enablesFor(ICSignal iCSignal) {
        return iCSignal != null && iCSignal.getDebugTarget().isSuspended();
    }

    private void setSignal(ICSignal iCSignal) {
        this.fSignal = iCSignal;
    }

    protected ICSignal getSignal() {
        return this.fSignal;
    }
}

