/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.SignalPropertiesDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class SignalPropertiesActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICSignal fSignal;
    private SignalPropertiesDialog fDialog;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof ICSignal) {
            iAction.setEnabled(true);
            this.setSignal((ICSignal)object);
            return;
        }
        iAction.setEnabled(false);
        this.setSignal(null);
    }

    protected ICSignal getSignal() {
        return this.fSignal;
    }

    private void setSignal(ICSignal iCSignal) {
        this.fSignal = iCSignal;
    }

    public void run(IAction iAction) {
        if (this.getSignal() != null) {
            final MultiStatus multiStatus = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("SignalPropertiesActionDelegate.Unable_to_change_signal_properties_1"), null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        SignalPropertiesActionDelegate.this.doAction(SignalPropertiesActionDelegate.this.getSignal());
                    }
                    catch (DebugException debugException) {
                        multiStatus.merge(debugException.getStatus());
                    }
                }
            });
            if (!multiStatus.isOK()) {
                IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    CDebugUIPlugin.errorDialog(ActionMessages.getString("SignalPropertiesActionDelegate.Operation_failed_1"), (IStatus)multiStatus);
                } else {
                    CDebugUIPlugin.log((IStatus)multiStatus);
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doAction(ICSignal iCSignal) throws DebugException {
        IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        Shell shell = iWorkbenchWindow.getShell();
        if (this.fDialog != null) {
            return;
        }
        String string = iCSignal.getName();
        String string2 = iCSignal.getDescription();
        boolean bl = iCSignal.isPassEnabled();
        boolean bl2 = iCSignal.isStopEnabled();
        boolean bl3 = iCSignal.canModify();
        this.fDialog = new SignalPropertiesDialog(shell, string, string2, bl, bl2, bl3);
        try {
            if (this.fDialog.open() == 0) {
                this.setProperties(iCSignal, this.fDialog.isPassEnabled(), this.fDialog.isStopEnabled());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.fDialog = null;
            throw throwable;
        }
        {
            Object var10_12 = null;
            this.fDialog = null;
            return;
        }
    }

    private void setProperties(ICSignal iCSignal, boolean bl, boolean bl2) throws DebugException {
        iCSignal.setPassEnabled(bl);
        iCSignal.setStopEnabled(bl2);
    }
}

