/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointDialog;
import org.eclipse.cdt.debug.internal.ui.actions.BreakpointLocationVerifier;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    static /* synthetic */ Class class$0;

    /*
     * Enabled aggressive block sorting
     */
    public void toggleLineBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
        String string = null;
        if (iWorkbenchPart instanceof IEditorPart) {
            IEditorPart iEditorPart = (IEditorPart)iWorkbenchPart;
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput == null) {
                string = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
            }
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iEditorInput);
            if (iDocument == null) {
                string = ActionMessages.getString("ToggleBreakpointAdapter.Missing_document_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
            }
            IResource iResource = ToggleBreakpointAdapter.getResource((IWorkbenchPart)iTextEditor);
            if (iResource == null) {
                string = ActionMessages.getString("ToggleBreakpointAdapter.Missing_resource_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
            }
            BreakpointLocationVerifier breakpointLocationVerifier = new BreakpointLocationVerifier();
            int n = breakpointLocationVerifier.getValidLineBreakpointLocation(iDocument, ((ITextSelection)iSelection).getStartLine());
            if (n == -1) {
                string = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
            }
            String string2 = this.getSourceHandle(iEditorInput);
            ICLineBreakpoint iCLineBreakpoint = CDIDebugModel.lineBreakpointExists((String)string2, (IResource)iResource, (int)n);
            if (iCLineBreakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)iCLineBreakpoint, true);
                return;
            }
            CDIDebugModel.createLineBreakpoint((String)string2, (IResource)iResource, (int)n, (boolean)true, (int)0, (String)"", (boolean)true);
            return;
        }
        if (!(iWorkbenchPart instanceof DisassemblyView)) {
            string = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
        }
        IEditorInput iEditorInput = ((DisassemblyView)iWorkbenchPart).getInput();
        if (!(iEditorInput instanceof DisassemblyEditorInput)) {
            string = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
        }
        BreakpointLocationVerifier breakpointLocationVerifier = new BreakpointLocationVerifier();
        int n = breakpointLocationVerifier.getValidAddressBreakpointLocation(null, ((ITextSelection)iSelection).getStartLine());
        if (n == -1) {
            string = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String string3 = this.getSourceHandle(iEditorInput);
        long l = ((DisassemblyEditorInput)iEditorInput).getAddress(n);
        if (l == 0L) {
            string = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
        }
        ICAddressBreakpoint iCAddressBreakpoint = CDIDebugModel.addressBreakpointExists((String)string3, (IResource)iWorkspaceRoot, (long)l);
        if (iCAddressBreakpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)iCAddressBreakpoint, true);
            return;
        }
        CDIDebugModel.createAddressBreakpoint((String)string3, (IResource)iWorkspaceRoot, (long)l, (boolean)true, (int)0, (String)"", (boolean)true);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IEditorInput iEditorInput;
        if (iWorkbenchPart instanceof DisassemblyView && (!((iEditorInput = ((DisassemblyView)iWorkbenchPart).getInput()) instanceof DisassemblyEditorInput) || ((DisassemblyEditorInput)iEditorInput).equals(DisassemblyEditorInput.EMPTY_EDITOR_INPUT))) {
            return false;
        }
        return iSelection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
        IStructuredSelection iStructuredSelection;
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof IFunction) {
            String string;
            IResource iResource;
            IFunction iFunction = (IFunction)iStructuredSelection.getFirstElement();
            String string2 = this.getSourceHandle((IDeclaration)iFunction);
            ICFunctionBreakpoint iCFunctionBreakpoint = CDIDebugModel.functionBreakpointExists((String)string2, (IResource)(iResource = this.getElementResource((IDeclaration)iFunction)), (String)(string = this.getFunctionName(iFunction)));
            if (iCFunctionBreakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)iCFunctionBreakpoint, true);
            } else {
                int n = -1;
                int n2 = -1;
                int n3 = -1;
                try {
                    ISourceRange iSourceRange = iFunction.getSourceRange();
                    if (iSourceRange != null && (n3 = (n2 = iSourceRange.getStartPos()) + iSourceRange.getLength()) == 0) {
                        n = iSourceRange.getStartLine();
                    }
                }
                catch (CModelException cModelException) {
                    DebugPlugin.log((Throwable)cModelException);
                }
                CDIDebugModel.createFunctionBreakpoint((String)string2, (IResource)iResource, (String)string, (int)n2, (int)n3, (int)n, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
            return iStructuredSelection.getFirstElement() instanceof IFunction;
        }
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
        IStructuredSelection iStructuredSelection;
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof IVariable) {
            this.toggleVariableWatchpoint(iWorkbenchPart, (IVariable)iStructuredSelection.getFirstElement());
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
            return iStructuredSelection.getFirstElement() instanceof IVariable;
        }
        return false;
    }

    protected void report(String string, IWorkbenchPart iWorkbenchPart) {
        IEditorStatusLine iEditorStatusLine;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iEditorStatusLine = (IEditorStatusLine)iWorkbenchPart.getAdapter((Class)clazz)) != null) {
            if (string != null) {
                iEditorStatusLine.setMessage(true, string, null);
            } else {
                iEditorStatusLine.setMessage(true, null, null);
            }
        }
        if (string != null && CDebugUIPlugin.getActiveWorkbenchShell() != null) {
            CDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    protected static IResource getResource(IWorkbenchPart iWorkbenchPart) {
        IEditorInput iEditorInput;
        if (iWorkbenchPart instanceof IEditorPart && (iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private String getSourceHandle(IEditorInput iEditorInput) throws CoreException {
        if (iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile().getLocation().toOSString();
        }
        if (iEditorInput instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)iEditorInput).getStorage().getName();
        }
        if (iEditorInput instanceof DisassemblyEditorInput) {
            return ((DisassemblyEditorInput)iEditorInput).getModuleFile();
        }
        return "";
    }

    private void toggleVariableWatchpoint(IWorkbenchPart iWorkbenchPart, IVariable iVariable) throws CoreException {
        String string;
        IResource iResource;
        String string2 = this.getSourceHandle((IDeclaration)iVariable);
        ICWatchpoint iCWatchpoint = CDIDebugModel.watchpointExists((String)string2, (IResource)(iResource = this.getElementResource((IDeclaration)iVariable)), (String)(string = this.getVariableName(iVariable)));
        if (iCWatchpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)iCWatchpoint, true);
        } else {
            AddWatchpointDialog addWatchpointDialog = new AddWatchpointDialog(iWorkbenchPart.getSite().getShell(), true, false, string);
            if (addWatchpointDialog.open() != 0) {
                return;
            }
            string = addWatchpointDialog.getExpression();
            CDIDebugModel.createWatchpoint((String)string2, (IResource)iResource, (boolean)addWatchpointDialog.getWriteAccess(), (boolean)addWatchpointDialog.getReadAccess(), (String)string, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    private String getSourceHandle(IDeclaration iDeclaration) {
        IPath iPath;
        ITranslationUnit iTranslationUnit = iDeclaration.getTranslationUnit();
        if (iTranslationUnit != null && (iPath = iTranslationUnit.getPath()) != null) {
            return iPath.toOSString();
        }
        return "";
    }

    private IResource getElementResource(IDeclaration iDeclaration) {
        return iDeclaration.getUnderlyingResource();
    }

    private String getFunctionName(IFunction iFunction) {
        String string = iFunction.getElementName();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.indexOf("::") != -1 && string.indexOf(40) == -1) {
            String[] stringArray = iFunction.getParameterTypes();
            stringBuffer.append('(');
            if (stringArray.length == 0) {
                stringBuffer.append("void");
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n]);
                    if (n != stringArray.length - 1) {
                        stringBuffer.append(',');
                    }
                    ++n;
                }
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private String getVariableName(IVariable iVariable) {
        return iVariable.getElementName();
    }
}

