/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo fRuler;
    private IWorkbenchPart fTargetPart;
    private ToggleBreakpointAdapter fBreakpointAdapter;
    private static final ISelection EMPTY_SELECTION = new EmptySelection();

    public ToggleBreakpointRulerAction(IWorkbenchPart iWorkbenchPart, IVerticalRulerInfo iVerticalRulerInfo) {
        super(ActionMessages.getString("ToggleBreakpointRulerAction.Toggle_Breakpoint_1"));
        this.fRuler = iVerticalRulerInfo;
        this.setTargetPart(iWorkbenchPart);
        this.fBreakpointAdapter = new ToggleBreakpointAdapter();
        WorkbenchHelp.setHelp((IAction)this, (String)ICDebugHelpContextIds.TOGGLE_BREAKPOINT_ACTION);
        this.setId(IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT);
    }

    public void dispose() {
        this.setTargetPart(null);
        this.fRuler = null;
    }

    public void run() {
        try {
            this.fBreakpointAdapter.toggleLineBreakpoints(this.getTargetPart(), this.getTargetSelection());
        }
        catch (CoreException coreException) {
            DebugUIPlugin.errorDialog((Shell)this.getTargetPart().getSite().getShell(), (String)ActionMessages.getString("ToggleBreakpointRulerAction.Error_1"), (String)ActionMessages.getString("ToggleBreakpointRulerAction.Operation_failed_1"), (IStatus)coreException.getStatus());
        }
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    private IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    private void setTargetPart(IWorkbenchPart iWorkbenchPart) {
        this.fTargetPart = iWorkbenchPart;
    }

    private ISelection getTargetSelection() {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            int n = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
            try {
                IRegion iRegion = iDocument.getLineInformation(n);
                return new TextSelection(iDocument, iRegion.getOffset(), iRegion.getLength());
            }
            catch (BadLocationException badLocationException) {
                DebugPlugin.log((Throwable)badLocationException);
            }
        }
        return EMPTY_SELECTION;
    }

    private IDocument getDocument() {
        DisassemblyView disassemblyView;
        DisassemblyDocumentProvider disassemblyDocumentProvider;
        IWorkbenchPart iWorkbenchPart = this.getTargetPart();
        if (iWorkbenchPart instanceof ITextEditor) {
            ITextEditor iTextEditor = (ITextEditor)iWorkbenchPart;
            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
            if (iDocumentProvider != null) {
                return iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
            }
        } else if (iWorkbenchPart instanceof DisassemblyView && (disassemblyDocumentProvider = (disassemblyView = (DisassemblyView)iWorkbenchPart).getDocumentProvider()) != null) {
            return disassemblyDocumentProvider.getDocument(disassemblyView.getInput());
        }
        return null;
    }

    static class EmptySelection
    implements ISelection {
        EmptySelection() {
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

