/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ToggleInstructionStepModeActionDelegate
extends ActionDelegate
implements IViewActionDelegate,
Preferences.IPropertyChangeListener {
    private ICDebugTarget fTarget = null;
    private IAction fAction = null;

    public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        IAction iAction = this.getAction();
        if (iAction != null && propertyChangeEvent.getNewValue() instanceof Boolean && (bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) != iAction.isChecked()) {
            iAction.setChecked(bl);
        }
    }

    public void init(IViewPart iViewPart) {
    }

    public void dispose() {
        ICDebugTarget iCDebugTarget = this.getTarget();
        if (iCDebugTarget != null) {
            iCDebugTarget.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
        this.setTarget(null);
        this.setAction(null);
    }

    public void init(IAction iAction) {
        this.setAction(iAction);
        iAction.setChecked(false);
        iAction.setEnabled(false);
    }

    public void run(IAction iAction) {
        ICDebugTarget iCDebugTarget = this.getTarget();
        if (iCDebugTarget != null) {
            iCDebugTarget.enableInstructionStepping(this.getAction().isChecked());
        }
    }

    public void runWithEvent(IAction iAction, Event event) {
        this.run(iAction);
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        ICDebugTarget iCDebugTarget;
        ICDebugTarget iCDebugTarget2 = null;
        if (iSelection instanceof IStructuredSelection) {
            iCDebugTarget2 = this.getTargetFromSelection(((IStructuredSelection)iSelection).getFirstElement());
        }
        if ((iCDebugTarget = this.getTarget()) != null && !iCDebugTarget.equals(iCDebugTarget2)) {
            iCDebugTarget.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            this.setTarget(null);
            iAction.setChecked(false);
        }
        if (iCDebugTarget2 != null && !iCDebugTarget2.isTerminated() && !iCDebugTarget2.isDisconnected()) {
            this.setTarget(iCDebugTarget2);
            iCDebugTarget2.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
            iAction.setChecked(iCDebugTarget2.isInstructionSteppingEnabled());
        }
        iAction.setEnabled(iCDebugTarget2 != null && iCDebugTarget2.supportsInstructionStepping() && !iCDebugTarget2.isTerminated() && !iCDebugTarget2.isDisconnected());
    }

    private ICDebugTarget getTarget() {
        return this.fTarget;
    }

    private void setTarget(ICDebugTarget iCDebugTarget) {
        this.fTarget = iCDebugTarget;
    }

    private IAction getAction() {
        return this.fAction;
    }

    private void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    private ICDebugTarget getTargetFromSelection(Object object) {
        if (object instanceof IDebugElement) {
            IDebugTarget iDebugTarget = ((IDebugElement)object).getDebugTarget();
            return iDebugTarget instanceof ICDebugTarget ? (ICDebugTarget)iDebugTarget : null;
        }
        return null;
    }
}

