/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.internal.ui.preferences.PreferenceMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;

public class CDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fPathsButton;
    private Button fRefreshRegistersButton;
    private Button fRefreshSolibsButton;
    private Combo fVariableFormatCombo;
    private Combo fExpressionFormatCombo;
    private Combo fRegisterFormatCombo;
    private IntegerFieldEditor fMaxNumberOfInstructionsText;
    private ColorFieldEditor fDisassemblySourceColor;
    private static final int NUMBER_OF_DIGITS = 3;
    private static int[] fFormatIds;
    private static String[] fFormatLabels;
    private PropertyChangeListener fPropertyChangeListener;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[3];
        nArray[1] = 4;
        nArray[2] = 1;
        fFormatIds = nArray;
        fFormatLabels = new String[]{PreferenceMessages.getString("CDebugPreferencePage.0"), PreferenceMessages.getString("CDebugPreferencePage.1"), PreferenceMessages.getString("CDebugPreferencePage.2")};
    }

    public CDebugPreferencePage() {
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
        this.setDescription(PreferenceMessages.getString("CDebugPreferencePage.3"));
    }

    protected Control createContents(Composite composite) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)ICDebugHelpContextIds.C_DEBUG_PREFERENCE_PAGE);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        this.createSpacer(composite2, 1);
        this.createViewSettingPreferences(composite2);
        this.createSpacer(composite2, 1);
        this.createDisassemblySettingPreferences(composite2);
        this.setValues();
        return composite2;
    }

    private Composite createGroupComposite(Composite composite, int n, String string) {
        return ControlFactory.createGroup((Composite)composite, (String)string, (int)n);
    }

    private void setValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fPathsButton.setSelection(iPreferenceStore.getBoolean(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS));
        this.fRefreshRegistersButton.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH));
        this.fRefreshSolibsButton.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SHARED_LIBRARIES_AUTO_REFRESH));
        this.getMaxNumberOfInstructionsText().setStringValue(new Integer(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS)).toString());
        this.getDisassemblySourceColor().load();
        this.fVariableFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT)));
        this.fExpressionFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fRegisterFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new PropertyChangeListener();
        }
        return this.fPropertyChangeListener;
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES, false);
        iPreferenceStore.setDefault(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS, true);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)IInternalCDebugUIConstants.DISASSEMBLY_SOURCE_LINE_COLOR, (RGB)IInternalCDebugUIConstants.DEFAULT_DISASSEMBLY_SOURCE_LINE_RGB);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS, 100);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT, 0);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT, 0);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT, 0);
    }

    public void dispose() {
        super.dispose();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
    }

    private void createViewSettingPreferences(Composite composite) {
        Composite composite2 = this.createGroupComposite(composite, 1, PreferenceMessages.getString("CDebugPreferencePage.4"));
        this.fPathsButton = this.createCheckButton(composite2, PreferenceMessages.getString("CDebugPreferencePage.5"));
        this.fRefreshRegistersButton = this.createCheckButton(composite2, PreferenceMessages.getString("CDebugPreferencePage.6"));
        this.fRefreshSolibsButton = this.createCheckButton(composite2, PreferenceMessages.getString("CDebugPreferencePage.7"));
        Composite composite3 = ControlFactory.createCompositeEx((Composite)composite2, (int)2, (int)0);
        ((GridLayout)composite3.getLayout()).makeColumnsEqualWidth = true;
        this.fVariableFormatCombo = this.createComboBox(composite3, PreferenceMessages.getString("CDebugPreferencePage.8"), fFormatLabels, fFormatLabels[0]);
        this.fExpressionFormatCombo = this.createComboBox(composite3, PreferenceMessages.getString("CDebugPreferencePage.9"), fFormatLabels, fFormatLabels[0]);
        this.fRegisterFormatCombo = this.createComboBox(composite3, PreferenceMessages.getString("CDebugPreferencePage.10"), fFormatLabels, fFormatLabels[0]);
    }

    private void createDisassemblySettingPreferences(Composite composite) {
        Composite composite2 = this.createGroupComposite(composite, 1, PreferenceMessages.getString("CDebugPreferencePage.11"));
        Composite composite3 = ControlFactory.createComposite((Composite)composite2, (int)2);
        this.createMaxNumberOfInstructionsField(composite3);
        this.createDisassemblyColorsField(composite3);
    }

    private void createMaxNumberOfInstructionsField(Composite composite) {
        this.fMaxNumberOfInstructionsText = new IntegerFieldEditor(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS, PreferenceMessages.getString("CDebugPreferencePage.12"), composite, 3);
        GridData gridData = (GridData)this.fMaxNumberOfInstructionsText.getTextControl(composite).getLayoutData();
        gridData.horizontalAlignment = 1;
        gridData.widthHint = this.convertWidthInCharsToPixels(4);
        this.fMaxNumberOfInstructionsText.setPreferencePage((PreferencePage)this);
        this.fMaxNumberOfInstructionsText.setValidateStrategy(0);
        this.fMaxNumberOfInstructionsText.setValidRange(1, 999);
        String string = Integer.toString(1);
        String string2 = Integer.toString(999);
        this.fMaxNumberOfInstructionsText.setErrorMessage(MessageFormat.format(PreferenceMessages.getString("CDebugPreferencePage.13"), string, string2));
        this.fMaxNumberOfInstructionsText.load();
        this.fMaxNumberOfInstructionsText.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
                    CDebugPreferencePage.this.setValid(CDebugPreferencePage.this.getMaxNumberOfInstructionsText().isValid());
                }
            }
        });
    }

    private void createDisassemblyColorsField(Composite composite) {
        this.fDisassemblySourceColor = new ColorFieldEditor(IInternalCDebugUIConstants.DISASSEMBLY_SOURCE_LINE_COLOR, PreferenceMessages.getString("CDebugPreferencePage.Color_of_disassembly_source_lines_1"), composite);
        this.fDisassemblySourceColor.setPreferencePage((PreferencePage)this);
        this.fDisassemblySourceColor.setPreferenceStore(this.getPreferenceStore());
        this.fDisassemblySourceColor.load();
    }

    private Button createCheckButton(Composite composite, String string) {
        Button button = new Button(composite, 16416);
        button.setText(string);
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Combo createComboBox(Composite composite, String string, String[] stringArray, String string2) {
        ControlFactory.createLabel((Composite)composite, (String)string);
        Combo combo = ControlFactory.createSelectCombo((Composite)composite, (String[])stringArray, (String)string2);
        combo.setLayoutData((Object)new GridData());
        return combo;
    }

    protected void createSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    public boolean performOk() {
        this.storeValues();
        if (this.getPropertyChangeListener().hasStateChanged()) {
            this.refreshViews();
        }
        CDebugUIPlugin.getDefault().savePluginPreferences();
        CDebugCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void refreshViews() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray = CDebugUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                IWorkbenchPage iWorkbenchPage = null;
                int n = 0;
                while (n < iWorkbenchWindowArray.length) {
                    iWorkbenchPage = iWorkbenchWindowArray[n].getActivePage();
                    if (iWorkbenchPage != null) {
                        CDebugPreferencePage.this.refreshViews(iWorkbenchPage, "org.eclipse.debug.ui.ExpressionView");
                        CDebugPreferencePage.this.refreshViews(iWorkbenchPage, "org.eclipse.debug.ui.VariableView");
                        CDebugPreferencePage.this.refreshViews(iWorkbenchPage, "org.eclipse.cdt.debug.ui.RegitersView");
                    }
                    ++n;
                }
            }
        });
    }

    protected void refreshViews(IWorkbenchPage iWorkbenchPage, String string) {
        IViewPart iViewPart = iWorkbenchPage.findView(string);
        if (iViewPart != null) {
            Viewer viewer;
            IDebugView iDebugView;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iDebugView = (IDebugView)iViewPart.getAdapter((Class)clazz)) != null && (viewer = iDebugView.getViewer()) instanceof StructuredViewer) {
                ((StructuredViewer)viewer).refresh();
            }
        }
    }

    private void storeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS, this.fPathsButton.getSelection());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH, this.fRefreshRegistersButton.getSelection());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_SHARED_LIBRARIES_AUTO_REFRESH, this.fRefreshSolibsButton.getSelection());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS, this.getMaxNumberOfInstructionsText().getIntValue());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT, CDebugPreferencePage.getFormatId(this.fVariableFormatCombo.getSelectionIndex()));
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT, CDebugPreferencePage.getFormatId(this.fExpressionFormatCombo.getSelectionIndex()));
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT, CDebugPreferencePage.getFormatId(this.fRegisterFormatCombo.getSelectionIndex()));
        this.getDisassemblySourceColor().store();
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fPathsButton.setSelection(iPreferenceStore.getDefaultBoolean(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS));
        this.fRefreshRegistersButton.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH));
        this.fRefreshSolibsButton.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean(ICDebugConstants.PREF_SHARED_LIBRARIES_AUTO_REFRESH));
        this.getMaxNumberOfInstructionsText().setStringValue(new Integer(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS)).toString());
        this.getDisassemblySourceColor().loadDefault();
        this.fVariableFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT)));
        this.fExpressionFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fRegisterFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
    }

    private static int getFormatId(int n) {
        return n >= 0 && n < fFormatIds.length ? fFormatIds[n] : fFormatIds[0];
    }

    private static int getFormatIndex(int n) {
        int n2 = 0;
        while (n2 < fFormatIds.length) {
            if (fFormatIds[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected IntegerFieldEditor getMaxNumberOfInstructionsText() {
        return this.fMaxNumberOfInstructionsText;
    }

    private ColorFieldEditor getDisassemblySourceColor() {
        return this.fDisassemblySourceColor;
    }

    protected class PropertyChangeListener
    implements IPropertyChangeListener {
        private boolean fHasStateChanged = false;

        protected PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES)) {
                this.fHasStateChanged = true;
            } else if (propertyChangeEvent.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_CHAR_VALUES)) {
                this.fHasStateChanged = true;
            }
        }

        protected boolean hasStateChanged() {
            return this.fHasStateChanged;
        }
    }
}

