/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.internal.ui.preferences.PreferenceMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class MemoryViewPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public MemoryViewPreferencePage() {
        super(1);
        this.setDescription(PreferenceMessages.getString("MemoryViewPreferencePage.0"));
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        WorkbenchHelp.setHelp((Control)composite, (String)ICDebugHelpContextIds.MEMORY_PREFERENCE_PAGE);
    }

    protected void createFieldEditors() {
        ColorFieldEditor colorFieldEditor = new ColorFieldEditor("Memory.Foreground.RGB", PreferenceMessages.getString("MemoryViewPreferencePage.1"), this.getFieldEditorParent());
        ColorFieldEditor colorFieldEditor2 = new ColorFieldEditor("Memory.background.RGB", PreferenceMessages.getString("MemoryViewPreferencePage.2"), this.getFieldEditorParent());
        ColorFieldEditor colorFieldEditor3 = new ColorFieldEditor("Memory.Address.RGB", PreferenceMessages.getString("MemoryViewPreferencePage.3"), this.getFieldEditorParent());
        ColorFieldEditor colorFieldEditor4 = new ColorFieldEditor("Memory.Changed.RGB", PreferenceMessages.getString("MemoryViewPreferencePage.4"), this.getFieldEditorParent());
        FontFieldEditor fontFieldEditor = new FontFieldEditor("Memory.font", PreferenceMessages.getString("MemoryViewPreferencePage.5"), this.getFieldEditorParent());
        this.addField((FieldEditor)colorFieldEditor);
        this.addField((FieldEditor)colorFieldEditor2);
        this.addField((FieldEditor)colorFieldEditor3);
        this.addField((FieldEditor)colorFieldEditor4);
        this.addField((FieldEditor)fontFieldEditor);
        StringFieldEditor stringFieldEditor = this.createPaddingCharacterField();
        stringFieldEditor.setTextLimit(1);
        this.addField((FieldEditor)stringFieldEditor);
        this.createSpacer(this.getFieldEditorParent(), 1);
        this.createDefaultSettingsFields();
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void createSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault("Memory.PaddingChar", ".");
        iPreferenceStore.setDefault(ICDebugPreferenceConstants.PREF_MEMORY_AUTO_REFRESH, true);
        iPreferenceStore.setDefault(ICDebugPreferenceConstants.PREF_MEMORY_SHOW_ASCII, true);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Memory.font", (FontData)ICDebugPreferenceConstants.DEFAULT_MEMORY_FONT);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Memory.Foreground.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_FOREGROUND_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Memory.background.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_BACKGROUND_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Memory.Address.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_ADDRESS_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Memory.Changed.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_CHANGED_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Memory.Dirty.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_DIRTY_RGB);
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        CDebugUIPlugin.getDefault().savePluginPreferences();
        return bl;
    }

    private StringFieldEditor createPaddingCharacterField() {
        return new StringFieldEditor("Memory.PaddingChar", PreferenceMessages.getString("MemoryViewPreferencePage.6"), 1, this.getFieldEditorParent()){

            protected boolean doCheckState() {
                return this.getTextControl().getText().length() == 1;
            }
        };
    }

    private void createDefaultSettingsFields() {
        this.addField((FieldEditor)new BooleanFieldEditor(ICDebugPreferenceConstants.PREF_MEMORY_AUTO_REFRESH, PreferenceMessages.getString("MemoryViewPreferencePage.7"), 0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(ICDebugPreferenceConstants.PREF_MEMORY_SHOW_ASCII, PreferenceMessages.getString("MemoryViewPreferencePage.8"), 0, this.getFieldEditorParent()));
    }
}

