/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDebugEventHandler
implements IDebugEventSetListener {
    private AbstractDebugView fView;

    public AbstractDebugEventHandler(AbstractDebugView abstractDebugView) {
        this.setView(abstractDebugView);
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
    }

    protected IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getActivePage();
    }

    public void handleDebugEvents(final DebugEvent[] debugEventArray) {
        if (!this.isAvailable()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (AbstractDebugEventHandler.this.isAvailable()) {
                    if (AbstractDebugEventHandler.this.isViewVisible()) {
                        AbstractDebugEventHandler.this.doHandleDebugEvents(debugEventArray);
                    }
                    AbstractDebugEventHandler.this.updateForDebugEvents(debugEventArray);
                }
            }
        };
        this.getView().asyncExec(runnable);
    }

    protected void updateForDebugEvents(DebugEvent[] debugEventArray) {
    }

    protected abstract void doHandleDebugEvents(DebugEvent[] var1);

    protected void insert(Object object) {
        Object object2;
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.isAvailable() && treeViewer != null && (object2 = ((ITreeContentProvider)treeViewer.getContentProvider()).getParent(object)) != null) {
            this.getView().showViewer();
            treeViewer.add(object2, object);
        }
    }

    protected void remove(Object object) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.isAvailable() && treeViewer != null) {
            this.getView().showViewer();
            treeViewer.remove(object);
        }
    }

    protected void labelChanged(Object object) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getStructuredViewer().update(object, new String[]{"org.eclipse.jface.text"});
        }
    }

    protected void refresh(Object object) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getStructuredViewer().refresh(object);
        }
    }

    public void refresh() {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getStructuredViewer().refresh();
        }
    }

    protected void selectAndReveal(Object object) {
        if (this.isAvailable()) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(object), true);
        }
    }

    public void dispose() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
    }

    protected AbstractDebugView getView() {
        return this.fView;
    }

    private void setView(AbstractDebugView abstractDebugView) {
        this.fView = abstractDebugView;
    }

    protected Viewer getViewer() {
        return this.getView().getViewer();
    }

    protected TreeViewer getTreeViewer() {
        if (this.getViewer() instanceof TreeViewer) {
            return (TreeViewer)this.getViewer();
        }
        return null;
    }

    protected TableTreeViewer getTableTreeViewer() {
        if (this.getViewer() instanceof TableTreeViewer) {
            return (TableTreeViewer)this.getViewer();
        }
        return null;
    }

    protected StructuredViewer getStructuredViewer() {
        if (this.getViewer() instanceof StructuredViewer) {
            return (StructuredViewer)this.getViewer();
        }
        return null;
    }

    protected boolean isAvailable() {
        return this.getView().isAvailable();
    }

    protected boolean isViewVisible() {
        return this.getView().isVisible();
    }

    protected void viewBecomesVisible() {
        this.refresh();
    }

    protected void viewBecomesHidden() {
    }
}

