/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class DisassemblyAnnotationModel
extends AnnotationModel {
    private DisassemblyEditorInput fInput;

    protected void breakpointsAdded(final IBreakpoint[] iBreakpointArray, final IDocument iDocument) {
        DisassemblyEditorInput disassemblyEditorInput = this.getInput();
        if (DisassemblyEditorInput.EMPTY_EDITOR_INPUT.equals(disassemblyEditorInput) || DisassemblyEditorInput.PENDING_EDITOR_INPUT.equals(disassemblyEditorInput)) {
            return;
        }
        this.asyncExec(new Runnable(){

            public void run() {
                DisassemblyAnnotationModel.this.breakpointsAdded0(iBreakpointArray, iDocument);
            }
        });
    }

    protected void breakpointsRemoved(final IBreakpoint[] iBreakpointArray, final IDocument iDocument) {
        DisassemblyEditorInput disassemblyEditorInput = this.getInput();
        if (DisassemblyEditorInput.EMPTY_EDITOR_INPUT.equals(disassemblyEditorInput) || DisassemblyEditorInput.PENDING_EDITOR_INPUT.equals(disassemblyEditorInput)) {
            return;
        }
        this.asyncExec(new Runnable(){

            public void run() {
                DisassemblyAnnotationModel.this.breakpointsRemoved0(iBreakpointArray, iDocument);
            }
        });
    }

    protected void breakpointsChanged(final IBreakpoint[] iBreakpointArray, final IDocument iDocument) {
        DisassemblyEditorInput disassemblyEditorInput = this.getInput();
        if (DisassemblyEditorInput.EMPTY_EDITOR_INPUT.equals(disassemblyEditorInput) || DisassemblyEditorInput.PENDING_EDITOR_INPUT.equals(disassemblyEditorInput)) {
            return;
        }
        this.asyncExec(new Runnable(){

            public void run() {
                DisassemblyAnnotationModel.this.breakpointsChanged0(iBreakpointArray, iDocument);
            }
        });
    }

    protected void breakpointsAdded0(IBreakpoint[] iBreakpointArray, IDocument iDocument) {
        int n = 0;
        while (n < iBreakpointArray.length) {
            if (iBreakpointArray[n] instanceof ICLineBreakpoint && this.isApplicable(iBreakpointArray[n])) {
                this.addBreakpointAnnotation((ICLineBreakpoint)iBreakpointArray[n], iDocument);
            }
            ++n;
        }
        this.fireModelChanged();
    }

    protected void breakpointsRemoved0(IBreakpoint[] iBreakpointArray, IDocument iDocument) {
        this.removeAnnotations(this.findAnnotationsforBreakpoints(iBreakpointArray), true, false);
    }

    protected void breakpointsChanged0(IBreakpoint[] iBreakpointArray, IDocument iDocument) {
        List list = this.findAnnotationsforBreakpoints(iBreakpointArray);
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)iterator.next();
            arrayList.add(markerAnnotation.getMarker());
            this.modifyAnnotationPosition((Annotation)markerAnnotation, this.getPosition((Annotation)markerAnnotation), false);
        }
        int n = 0;
        while (n < iBreakpointArray.length) {
            if (iBreakpointArray[n] instanceof ICLineBreakpoint && !arrayList.contains(iBreakpointArray[n].getMarker())) {
                this.addBreakpointAnnotation((ICLineBreakpoint)iBreakpointArray[n], iDocument);
            }
            ++n;
        }
        this.fireModelChanged();
    }

    protected DisassemblyEditorInput getInput() {
        return this.fInput;
    }

    protected void setInput(DisassemblyEditorInput disassemblyEditorInput, IDocument iDocument) {
        DisassemblyEditorInput disassemblyEditorInput2 = this.fInput;
        this.fInput = disassemblyEditorInput;
        if (this.fInput != null && !this.fInput.equals(disassemblyEditorInput2)) {
            this.updateAnnotations(iDocument);
        }
    }

    private boolean isApplicable(IBreakpoint iBreakpoint) {
        return true;
    }

    private void addBreakpointAnnotation(ICLineBreakpoint iCLineBreakpoint, IDocument iDocument) {
        Position position = this.createBreakpointPosition(iCLineBreakpoint, iDocument);
        if (position != null) {
            try {
                this.addAnnotation((Annotation)this.createMarkerAnnotation((IBreakpoint)iCLineBreakpoint), position, false);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private Position createBreakpointPosition(ICLineBreakpoint iCLineBreakpoint, IDocument iDocument) {
        Position position = null;
        DisassemblyEditorInput disassemblyEditorInput = this.getInput();
        if (disassemblyEditorInput != null) {
            int n;
            int n2 = -1;
            if (iDocument != null && (n = disassemblyEditorInput.getInstructionLine(iCLineBreakpoint)) > 0) {
                try {
                    n2 = this.fDocument.getLineOffset(n - 1);
                    if (n2 > -1) {
                        return new Position(n2, iDocument.getLineLength(n - 1));
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return position;
    }

    private MarkerAnnotation createMarkerAnnotation(IBreakpoint iBreakpoint) {
        return new MarkerAnnotation(iBreakpoint.getMarker());
    }

    protected void dispose() {
    }

    private List findAnnotationsforBreakpoints(IBreakpoint[] iBreakpointArray) {
        LinkedList<Annotation> linkedList = new LinkedList<Annotation>();
        Iterator iterator = this.getAnnotationIterator();
        while (iterator.hasNext()) {
            IMarker iMarker;
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof MarkerAnnotation) || (iMarker = ((MarkerAnnotation)annotation).getMarker()) == null) continue;
            int n = 0;
            while (n < iBreakpointArray.length) {
                if (iMarker.equals((Object)iBreakpointArray[n].getMarker())) {
                    linkedList.add(annotation);
                }
                ++n;
            }
        }
        return linkedList;
    }

    private void asyncExec(Runnable runnable) {
        Display display = DebugUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    private void updateAnnotations(final IDocument iDocument) {
        this.asyncExec(new Runnable(){

            public void run() {
                DisassemblyAnnotationModel.this.doUpdateAnnotations(iDocument);
            }
        });
    }

    protected void doUpdateAnnotations(IDocument iDocument) {
        this.breakpointsAdded0(DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(), iDocument);
    }
}

