/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import java.util.Arrays;
import org.eclipse.cdt.debug.core.model.IAsmInstruction;
import org.eclipse.cdt.debug.core.model.IAsmSourceLine;
import org.eclipse.cdt.debug.core.model.IBreakpointTarget;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class DisassemblyEditorInput
implements IEditorInput {
    public static final IEditorInput EMPTY_EDITOR_INPUT = new DisassemblyEditorInput();
    public static final IEditorInput PENDING_EDITOR_INPUT = new DisassemblyEditorInput(){

        public String getContents() {
            return DisassemblyMessages.getString("DisassemblyDocumentProvider.Pending_1");
        }
    };
    private IDisassemblyBlock fBlock;
    private String fContents = "";
    private IRegion[] fSourceRegions = new IRegion[0];
    static /* synthetic */ Class class$0;

    protected DisassemblyEditorInput() {
    }

    private DisassemblyEditorInput(IDisassemblyBlock iDisassemblyBlock) {
        this.fBlock = iDisassemblyBlock;
        this.createContents();
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public boolean contains(ICStackFrame iCStackFrame) {
        if (this.fBlock != null) {
            return this.fBlock.contains(iCStackFrame);
        }
        return false;
    }

    public String getContents() {
        return this.fContents;
    }

    public int getInstructionLine(long l) {
        if (this.fBlock != null) {
            IAsmSourceLine[] iAsmSourceLineArray = this.fBlock.getSourceLines();
            int n = 0;
            int n2 = 0;
            while (n2 < iAsmSourceLineArray.length) {
                IAsmInstruction[] iAsmInstructionArray = iAsmSourceLineArray[n2].getInstructions();
                ++n;
                int n3 = 0;
                while (n3 < iAsmInstructionArray.length) {
                    ++n;
                    if (iAsmInstructionArray[n3].getAdress() == l) {
                        return n;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return 0;
    }

    public int getInstructionLine(ICLineBreakpoint iCLineBreakpoint) {
        IDisassembly iDisassembly;
        if (this.fBlock != null && (iDisassembly = this.fBlock.getDisassembly()) != null) {
            IBreakpointTarget iBreakpointTarget;
            IDebugTarget iDebugTarget = iDisassembly.getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IBreakpointTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iBreakpointTarget = (IBreakpointTarget)iDebugTarget.getAdapter((Class)clazz)) != null) {
                try {
                    long l = iBreakpointTarget.getBreakpointAddress(iCLineBreakpoint);
                    if (l != 0L) {
                        return this.getInstructionLine(l);
                    }
                }
                catch (DebugException debugException) {}
            }
        }
        return 0;
    }

    public long getAddress(int n) {
        if (this.fBlock != null) {
            IAsmSourceLine[] iAsmSourceLineArray = this.fBlock.getSourceLines();
            int n2 = 0;
            int n3 = 0;
            while (n3 < iAsmSourceLineArray.length) {
                IAsmInstruction[] iAsmInstructionArray = iAsmSourceLineArray[n3].getInstructions();
                if (n == ++n2) {
                    return iAsmInstructionArray[0].getAdress();
                }
                if (n > n2 && n <= n2 + iAsmInstructionArray.length) {
                    return iAsmInstructionArray[n - n2 - 1].getAdress();
                }
                n2 += iAsmInstructionArray.length;
                ++n3;
            }
        }
        return 0L;
    }

    public String getModuleFile() {
        return this.fBlock != null ? this.fBlock.getModuleFile() : null;
    }

    public static DisassemblyEditorInput create(ICStackFrame iCStackFrame) throws DebugException {
        DisassemblyEditorInput disassemblyEditorInput = null;
        IDisassembly iDisassembly = ((ICDebugTarget)iCStackFrame.getDebugTarget()).getDisassembly();
        if (iDisassembly != null) {
            IDisassemblyBlock iDisassemblyBlock = iDisassembly.getDisassemblyBlock(iCStackFrame);
            disassemblyEditorInput = new DisassemblyEditorInput(iDisassemblyBlock);
        }
        return disassemblyEditorInput;
    }

    private void createContents() {
        this.fSourceRegions = new IRegion[0];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        if (this.fBlock != null) {
            Object object;
            int n3;
            IAsmSourceLine[] iAsmSourceLineArray = this.fBlock.getSourceLines();
            int n4 = 0;
            while (n4 < iAsmSourceLineArray.length) {
                IAsmInstruction[] iAsmInstructionArray = iAsmSourceLineArray[n4].getInstructions();
                n3 = 0;
                while (n3 < iAsmInstructionArray.length) {
                    String string;
                    object = iAsmInstructionArray[n3].getFunctionName();
                    if (((String)object).length() > n) {
                        n = ((String)object).length();
                    }
                    if ((string = iAsmInstructionArray[n3].getOpcode()).length() > n2) {
                        n2 = string.length();
                    }
                    if (iAsmInstructionArray[n3].getOffset() > l) {
                        l = iAsmInstructionArray[n3].getOffset();
                    }
                    ++n3;
                }
                ++n4;
            }
            n4 = this.calculateInstructionPosition(n, l);
            int n5 = n4 + n2 + 1;
            if (this.fBlock.isMixedMode()) {
                this.fSourceRegions = new IRegion[iAsmSourceLineArray.length];
            }
            n3 = 0;
            while (n3 < iAsmSourceLineArray.length) {
                if (this.fBlock.isMixedMode()) {
                    object = this.getSourceLineString(iAsmSourceLineArray[n3]);
                    this.fSourceRegions[n3] = new Region(stringBuffer.length(), ((String)object).length());
                    stringBuffer.append((String)object);
                }
                object = iAsmSourceLineArray[n3].getInstructions();
                int n6 = 0;
                while (n6 < ((IAsmInstruction[])object).length) {
                    stringBuffer.append(this.getInstructionString((IAsmInstruction)object[n6], n4, n5));
                    ++n6;
                }
                ++n3;
            }
        }
        this.fContents = stringBuffer.toString();
    }

    private String getInstructionString(IAsmInstruction iAsmInstruction, int n, int n2) {
        int n3 = Math.max(n, n2);
        char[] cArray = new char[n3];
        Arrays.fill(cArray, ' ');
        StringBuffer stringBuffer = new StringBuffer();
        if (iAsmInstruction != null) {
            stringBuffer.append(CDebugUIUtils.toHexAddressString(iAsmInstruction.getAdress()));
            stringBuffer.append(' ');
            String string = iAsmInstruction.getFunctionName();
            if (string != null && string.length() > 0) {
                stringBuffer.append('<');
                stringBuffer.append(string);
                if (iAsmInstruction.getOffset() != 0L) {
                    stringBuffer.append('+');
                    stringBuffer.append(iAsmInstruction.getOffset());
                }
                stringBuffer.append(">:");
                stringBuffer.append(cArray, 0, n - stringBuffer.length());
            }
            stringBuffer.append(iAsmInstruction.getOpcode());
            stringBuffer.append(cArray, 0, n2 - stringBuffer.length());
            stringBuffer.append(iAsmInstruction.getArguments());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private int calculateInstructionPosition(int n, long l) {
        return 16 + n + Long.toString(l).length();
    }

    private String getSourceLineString(IAsmSourceLine iAsmSourceLine) {
        String string = iAsmSourceLine.toString();
        if (string == null) {
            string = String.valueOf(DisassemblyMessages.getString("DisassemblyEditorInput.source_line_is_not_available_1")) + '\n';
        }
        return string;
    }

    public IRegion[] getSourceRegions() {
        return this.fSourceRegions;
    }

    protected IDisassembly getDisassembly() {
        return this.fBlock != null ? this.fBlock.getDisassembly() : null;
    }
}

