/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.text.source.Annotation;

public class DisassemblyInstructionPointerAnnotation
extends Annotation {
    private int fHashCode = 0;

    public DisassemblyInstructionPointerAnnotation(ICStackFrame iCStackFrame, boolean bl) {
        super(bl ? IInternalCDebugUIConstants.ANN_DISASM_INSTR_POINTER_CURRENT : IInternalCDebugUIConstants.ANN_DISASM_INSTR_POINTER_SECONDARY, false, bl ? DisassemblyMessages.getString("DisassemblyInstructionPointerAnnotation.Current_Pointer_1") : DisassemblyMessages.getString("DisassemblyInstructionPointerAnnotation.Secondary_Pointer_1"));
        this.fHashCode = this.getHashCode(iCStackFrame);
    }

    private IDisassembly getDisassembly(ICStackFrame iCStackFrame) {
        if (iCStackFrame != null) {
            ICDebugTarget iCDebugTarget = (ICDebugTarget)iCStackFrame.getDebugTarget();
            try {
                return iCDebugTarget.getDisassembly();
            }
            catch (DebugException debugException) {}
        }
        return null;
    }

    public int hashCode() {
        return this.fHashCode;
    }

    private int getHashCode(ICStackFrame iCStackFrame) {
        int n = 17;
        IDisassembly iDisassembly = this.getDisassembly(iCStackFrame);
        n = 37 * n + (iDisassembly != null ? iDisassembly.hashCode() : 0);
        if (iCStackFrame != null) {
            long l = iCStackFrame.getAddress();
            n = 37 * n + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public boolean equals(Object object) {
        return object != null ? object.hashCode() == this.hashCode() : false;
    }
}

