/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.actions.CBreakpointPropertiesRulerAction;
import org.eclipse.cdt.debug.internal.ui.actions.EnableDisableBreakpointRulerAction;
import org.eclipse.cdt.debug.internal.ui.actions.ToggleBreakpointRulerAction;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyInstructionPointerAnnotation;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyViewer;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyViewerConfiguration;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.IDisassemblyListener;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class DisassemblyView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
INullSelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler,
IDisassemblyListener {
    private static final int VERTICAL_RULER_WIDTH = 12;
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private String fViewContextMenuId;
    private String fRulerContextMenuId;
    private IVerticalRuler fVerticalRuler;
    private IOverviewRuler fOverviewRuler;
    protected ICStackFrame fLastStackFrame = null;
    private SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    private IAnnotationAccess fAnnotationAccess;
    private MarkerAnnotationPreferences fAnnotationPreferences;
    private DisassemblyDocumentProvider fDocumentProvider;
    private DisassemblyInstructionPointerAnnotation fInstrPointerAnnotation;
    private IMenuListener fMenuListener;
    private MouseListener fMouseListener;
    private Menu fRulerContextMenu;
    private Menu fTextContextMenu;
    private Map fActions = new HashMap(10);

    protected final IMenuListener getContextMenuListener() {
        if (this.fMenuListener == null) {
            this.fMenuListener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager iMenuManager) {
                    String string = iMenuManager.getId();
                    if (DisassemblyView.this.getRulerContextMenuId().equals(string)) {
                        DisassemblyView.this.setFocus();
                        DisassemblyView.this.rulerContextMenuAboutToShow(iMenuManager);
                    } else if (DisassemblyView.this.getViewContextMenuId().equals(string)) {
                        DisassemblyView.this.setFocus();
                        DisassemblyView.this.viewContextMenuAboutToShow(iMenuManager);
                    }
                }
            };
        }
        return this.fMenuListener;
    }

    protected final MouseListener getRulerMouseListener() {
        if (this.fMouseListener == null) {
            this.fMouseListener = new MouseListener(){
                private boolean fDoubleClicked = false;

                private void triggerAction(String string) {
                    IAction iAction = DisassemblyView.this.getAction(string);
                    if (iAction != null) {
                        if (iAction instanceof IUpdate) {
                            ((IUpdate)iAction).update();
                        }
                        if (iAction.isEnabled()) {
                            iAction.run();
                        }
                    }
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    DisassemblyView.this.setFocus();
                    if (1 == mouseEvent.button && !this.fDoubleClicked) {
                        this.triggerAction("RulerClick");
                    }
                    this.fDoubleClicked = false;
                }

                public void mouseDoubleClick(MouseEvent mouseEvent) {
                    if (1 == mouseEvent.button) {
                        this.fDoubleClicked = true;
                        this.triggerAction(IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT);
                    }
                }

                public void mouseDown(MouseEvent mouseEvent) {
                    StyledText styledText = DisassemblyView.this.getSourceViewer().getTextWidget();
                    if (styledText != null && !styledText.isDisposed()) {
                        Display display = styledText.getDisplay();
                        Point point = display.getCursorLocation();
                        DisassemblyView.this.getRulerContextMenu().setLocation(point.x, point.y);
                    }
                }
            };
        }
        return this.fMouseListener;
    }

    public DisassemblyView() {
        this.setViewContextMenuId("#DisassemblyViewContext");
        this.setRulerContextMenuId("#DisassemblyEditorRulerContext");
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
    }

    protected Viewer createViewer(Composite composite) {
        this.fVerticalRuler = this.createVerticalRuler();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SourceViewer sourceViewer = this.createSourceViewer(composite, this.fVerticalRuler, this.getOverviewRuler());
        sourceViewer.configure((SourceViewerConfiguration)new DisassemblyViewerConfiguration());
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        EditorsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.getSite().setSelectionProvider(sourceViewer.getSelectionProvider());
        this.setEventHandler(this.createEventHandler());
        sourceViewer.setDocument(this.getDocumentProvider().getDocument(DisassemblyEditorInput.EMPTY_EDITOR_INPUT), this.getDocumentProvider().getAnnotationModel(null));
        this.resetViewerInput();
        return sourceViewer;
    }

    protected void createActions() {
        IVerticalRuler iVerticalRuler = this.getVerticalRuler();
        Action action = new ToggleBreakpointRulerAction((IWorkbenchPart)this, (IVerticalRulerInfo)iVerticalRuler);
        this.setAction(IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT, (IAction)action);
        action = new EnableDisableBreakpointRulerAction((IWorkbenchPart)this, (IVerticalRulerInfo)iVerticalRuler);
        this.setAction(IInternalCDebugUIConstants.ACTION_ENABLE_DISABLE_BREAKPOINT, (IAction)action);
        action = new CBreakpointPropertiesRulerAction((IWorkbenchPart)this, (IVerticalRulerInfo)iVerticalRuler);
        this.setAction(IInternalCDebugUIConstants.ACTION_BREAKPOINT_PROPERTIES, (IAction)action);
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.DISASSEMBLY_VIEW;
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (iSelection == null) {
            this.resetViewerInput();
        } else if (iSelection instanceof IStructuredSelection) {
            this.computeInput((IStructuredSelection)iSelection);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (IInternalCDebugUIConstants.DISASSEMBLY_SOURCE_LINE_COLOR.equals(string)) {
            IEditorInput iEditorInput = this.getInput();
            if (iEditorInput instanceof DisassemblyEditorInput) {
                this.getSourceViewer().changeTextPresentation(this.createTextPresentation(((DisassemblyEditorInput)iEditorInput).getSourceRegions()), true);
            }
        } else if (IInternalCDebugUIConstants.DISASSEMBLY_FONT.equals(string)) {
            this.getSourceViewer().getTextWidget().setFont(JFaceResources.getFont((String)IInternalCDebugUIConstants.DISASSEMBLY_FONT));
        }
    }

    public void handleException(DebugException debugException) {
        this.showMessage(debugException.getMessage());
    }

    private IVerticalRuler createVerticalRuler() {
        VerticalRuler verticalRuler = new VerticalRuler(12, this.getAnnotationAccess());
        return verticalRuler;
    }

    private IOverviewRuler createOverviewRuler(ISharedTextColors iSharedTextColors) {
        OverviewRuler overviewRuler = new OverviewRuler(this.getAnnotationAccess(), 12, iSharedTextColors);
        Iterator iterator = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (iterator.hasNext()) {
            AnnotationPreference annotationPreference = (AnnotationPreference)iterator.next();
            if (!annotationPreference.contributesToHeader()) continue;
            overviewRuler.addHeaderAnnotationType(annotationPreference.getAnnotationType());
        }
        return overviewRuler;
    }

    private SourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler) {
        DisassemblyViewer disassemblyViewer = new DisassemblyViewer(composite, iVerticalRuler, iOverviewRuler);
        disassemblyViewer.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        return disassemblyViewer;
    }

    protected SourceViewer getSourceViewer() {
        return (SourceViewer)this.getViewer();
    }

    protected AbstractDebugEventHandler createEventHandler() {
        return new DisassemblyViewEventHandler(this);
    }

    protected void computeInput(IStructuredSelection iStructuredSelection) {
        Object object;
        SourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        this.fLastStackFrame = null;
        if (iStructuredSelection != null && iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof ICStackFrame) {
            this.fLastStackFrame = (ICStackFrame)object;
            IEditorInput iEditorInput = this.getInput();
            if (iEditorInput instanceof DisassemblyEditorInput && !((DisassemblyEditorInput)iEditorInput).contains((ICStackFrame)object)) {
                this.setViewerInput(DisassemblyEditorInput.PENDING_EDITOR_INPUT);
            }
            this.computeInput(iEditorInput, (ICStackFrame)object, this);
            return;
        }
        this.resetViewerInput();
    }

    protected void setViewerInput(IEditorInput iEditorInput) {
        IEditorInput iEditorInput2;
        SourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        if (iEditorInput == null) {
            iEditorInput = DisassemblyEditorInput.EMPTY_EDITOR_INPUT;
        }
        if ((iEditorInput2 = this.getInput()) != null && iEditorInput2.equals(iEditorInput)) {
            this.updateObjects();
            return;
        }
        this.setInput(iEditorInput);
        this.showViewer();
        try {
            this.getDocumentProvider().connect(iEditorInput);
        }
        catch (CoreException coreException) {}
        this.getSourceViewer().setDocument(this.getDocumentProvider().getDocument(iEditorInput), this.getDocumentProvider().getAnnotationModel(iEditorInput));
        if (iEditorInput instanceof DisassemblyEditorInput) {
            this.getSourceViewer().changeTextPresentation(this.createTextPresentation(((DisassemblyEditorInput)iEditorInput).getSourceRegions()), true);
        }
        this.updateObjects();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        EditorsPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.dispose();
            this.fDocumentProvider = null;
        }
        if (this.fActions != null) {
            this.fActions.clear();
            this.fActions = null;
        }
        super.dispose();
    }

    public void inputComputed(final ICStackFrame iCStackFrame, final IStatus iStatus, final IEditorInput iEditorInput) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (DisassemblyView.this.isAvailable()) {
                    if (DisassemblyView.this.fLastStackFrame != null && DisassemblyView.this.fLastStackFrame.equals(iCStackFrame)) {
                        DisassemblyView.this.fLastStackFrame = null;
                        if (!iStatus.isOK()) {
                            DisassemblyView.this.setInput(null);
                            DisassemblyView.this.getViewer().setInput(null);
                            DisassemblyView.this.showMessage(iStatus.getMessage());
                            return;
                        }
                    }
                    if (iEditorInput != null) {
                        DisassemblyView.this.setViewerInput(iEditorInput);
                        DisassemblyView.this.selectAndReveal(iCStackFrame, iEditorInput);
                    } else {
                        DisassemblyView.this.resetViewerInput();
                    }
                }
            }
        };
        this.asyncExec(runnable);
    }

    public void computeInput(final Object object, final ICStackFrame iCStackFrame, final IDisassemblyListener iDisassemblyListener) {
        Runnable runnable = new Runnable(){

            public void run() {
                IStatus iStatus = Status.OK_STATUS;
                DisassemblyEditorInput disassemblyEditorInput = null;
                if (object instanceof DisassemblyEditorInput && ((DisassemblyEditorInput)object).contains(iCStackFrame)) {
                    disassemblyEditorInput = (IEditorInput)object;
                } else {
                    try {
                        disassemblyEditorInput = DisassemblyEditorInput.create(iCStackFrame);
                    }
                    catch (DebugException debugException) {
                        iStatus = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 0, debugException.getMessage(), null);
                    }
                }
                iDisassemblyListener.inputComputed(iCStackFrame, iStatus, disassemblyEditorInput);
            }
        };
        DebugPlugin.getDefault().asyncExec(runnable);
    }

    protected void selectAndReveal(ICStackFrame iCStackFrame, IEditorInput iEditorInput) {
        IRegion iRegion = this.getLineInformation(iCStackFrame, iEditorInput);
        if (iRegion != null) {
            int n = iRegion.getOffset();
            int n2 = iRegion.getLength();
            StyledText styledText = this.getSourceViewer().getTextWidget();
            styledText.setRedraw(false);
            this.getSourceViewer().revealRange(n, n2);
            this.getSourceViewer().setSelectedRange(n, 0);
            styledText.setRedraw(true);
            this.setInstructionPointer(iCStackFrame, n, n2, this.getDocumentProvider().getAnnotationModel(iEditorInput));
        }
    }

    private IRegion getLineInformation(ICStackFrame iCStackFrame, IEditorInput iEditorInput) {
        int n;
        if (iEditorInput instanceof DisassemblyEditorInput && (n = ((DisassemblyEditorInput)iEditorInput).getInstructionLine(iCStackFrame.getAddress())) > 0) {
            try {
                return this.getSourceViewer().getDocument().getLineInformation(--n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    public IEditorInput getInput() {
        Object object;
        if (this.getSourceViewer() != null && (object = this.getSourceViewer().getInput()) instanceof IEditorInput) {
            return (IEditorInput)object;
        }
        return null;
    }

    protected void setInput(IEditorInput iEditorInput) {
        this.getSourceViewer().setInput((Object)iEditorInput);
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        this.createViewContextMenu();
        this.createRulerContextMenu();
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getEditorPreferenceStore());
        }
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer iSourceViewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(iSourceViewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    private IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    private void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport sourceViewerDecorationSupport) {
        Iterator iterator = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (iterator.hasNext()) {
            sourceViewerDecorationSupport.setAnnotationPreference((AnnotationPreference)iterator.next());
        }
        sourceViewerDecorationSupport.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
    }

    private IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    private ISharedTextColors getSharedColors() {
        ISharedTextColors iSharedTextColors = EditorsPlugin.getDefault().getSharedTextColors();
        return iSharedTextColors;
    }

    private IPreferenceStore getEditorPreferenceStore() {
        return EditorsPlugin.getDefault().getPreferenceStore();
    }

    public DisassemblyDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new DisassemblyDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    protected void setInstructionPointer(ICStackFrame iCStackFrame, int n, int n2, IAnnotationModel iAnnotationModel) {
        Assert.isNotNull((Object)iAnnotationModel);
        boolean bl = this.isTopStackFrame(iCStackFrame);
        DisassemblyInstructionPointerAnnotation disassemblyInstructionPointerAnnotation = new DisassemblyInstructionPointerAnnotation(iCStackFrame, bl);
        Position position = new Position(n, n2);
        DisassemblyInstructionPointerAnnotation disassemblyInstructionPointerAnnotation2 = this.getCurrentInstructionPointer();
        if (disassemblyInstructionPointerAnnotation2 != null) {
            iAnnotationModel.removeAnnotation((Annotation)disassemblyInstructionPointerAnnotation2);
        }
        iAnnotationModel.addAnnotation((Annotation)disassemblyInstructionPointerAnnotation, position);
        this.setCurrentInstructionPointer(disassemblyInstructionPointerAnnotation);
    }

    private boolean isTopStackFrame(ICStackFrame iCStackFrame) {
        IThread iThread = iCStackFrame.getThread();
        boolean bl = false;
        try {
            bl = iCStackFrame.equals(iThread.getTopStackFrame());
        }
        catch (DebugException debugException) {}
        return bl;
    }

    private DisassemblyInstructionPointerAnnotation getCurrentInstructionPointer() {
        return this.fInstrPointerAnnotation;
    }

    private void setCurrentInstructionPointer(DisassemblyInstructionPointerAnnotation disassemblyInstructionPointerAnnotation) {
        this.fInstrPointerAnnotation = disassemblyInstructionPointerAnnotation;
    }

    protected void removeCurrentInstructionPointer(IAnnotationModel iAnnotationModel) {
        Assert.isNotNull((Object)iAnnotationModel);
        DisassemblyInstructionPointerAnnotation disassemblyInstructionPointerAnnotation = this.getCurrentInstructionPointer();
        if (disassemblyInstructionPointerAnnotation != null) {
            iAnnotationModel.removeAnnotation((Annotation)disassemblyInstructionPointerAnnotation);
            this.setCurrentInstructionPointer(null);
        }
    }

    protected void resetViewerInput() {
        SourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IEditorInput iEditorInput = DisassemblyEditorInput.EMPTY_EDITOR_INPUT;
        this.setInput(iEditorInput);
        this.showViewer();
        try {
            this.getDocumentProvider().connect(iEditorInput);
        }
        catch (CoreException coreException) {}
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel(iEditorInput);
        this.getSourceViewer().setDocument(this.getDocumentProvider().getDocument(iEditorInput), iAnnotationModel);
        this.removeCurrentInstructionPointer(iAnnotationModel);
        this.updateObjects();
    }

    protected void becomesHidden() {
        this.selectionChanged(null, (ISelection)new StructuredSelection());
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IViewPart iViewPart = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView");
        if (iViewPart != null) {
            ISelection iSelection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged((IWorkbenchPart)iViewPart, iSelection);
        }
    }

    private IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected String getRulerContextMenuId() {
        return this.fRulerContextMenuId;
    }

    private void setRulerContextMenuId(String string) {
        Assert.isNotNull((Object)string);
        this.fRulerContextMenuId = string;
    }

    protected String getViewContextMenuId() {
        return this.fViewContextMenuId;
    }

    private void setViewContextMenuId(String string) {
        Assert.isNotNull((Object)string);
        this.fViewContextMenuId = string;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("group.rest"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        this.addAction(iMenuManager, IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT);
        this.addAction(iMenuManager, IInternalCDebugUIConstants.ACTION_ENABLE_DISABLE_BREAKPOINT);
        this.addAction(iMenuManager, IInternalCDebugUIConstants.ACTION_BREAKPOINT_PROPERTIES);
    }

    protected void viewContextMenuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("group.rest"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    protected final void addAction(IMenuManager iMenuManager, String string, String string2) {
        IAction iAction = this.getAction(string2);
        if (iAction != null) {
            IMenuManager iMenuManager2;
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
            if ((iMenuManager2 = iMenuManager.findMenuUsingPath(string)) != null) {
                iMenuManager2.add(iAction);
            } else {
                iMenuManager.appendToGroup(string, iAction);
            }
        }
    }

    protected final void addAction(IMenuManager iMenuManager, String string) {
        IAction iAction = this.getAction(string);
        if (iAction != null) {
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
            iMenuManager.add(iAction);
        }
    }

    protected Menu getRulerContextMenu() {
        return this.fRulerContextMenu;
    }

    private void setRulerContextMenu(Menu menu) {
        this.fRulerContextMenu = menu;
    }

    private void createViewContextMenu() {
        String string = this.getViewContextMenuId();
        MenuManager menuManager = new MenuManager(string, string);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.getContextMenuListener());
        StyledText styledText = this.getSourceViewer().getTextWidget();
        this.setTextContextMenu(menuManager.createContextMenu((Control)styledText));
        styledText.setMenu(this.getTextContextMenu());
    }

    private void createRulerContextMenu() {
        String string = this.getRulerContextMenuId();
        MenuManager menuManager = new MenuManager(string, string);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.getContextMenuListener());
        Control control = this.fVerticalRuler.getControl();
        this.setRulerContextMenu(menuManager.createContextMenu(control));
        control.setMenu(this.getRulerContextMenu());
        control.addMouseListener(this.getRulerMouseListener());
    }

    private Menu getTextContextMenu() {
        return this.fTextContextMenu;
    }

    private void setTextContextMenu(Menu menu) {
        this.fTextContextMenu = menu;
    }

    public void setAction(String string, IAction iAction) {
        Assert.isNotNull((Object)string);
        if (iAction == null) {
            iAction = (IAction)this.fActions.remove(string);
        } else {
            this.fActions.put(string, iAction);
        }
    }

    public IAction getAction(String string) {
        Assert.isNotNull((Object)string);
        return (IAction)this.fActions.get(string);
    }

    private IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    private TextPresentation createTextPresentation(IRegion[] iRegionArray) {
        TextPresentation textPresentation = new TextPresentation();
        int n = 0;
        while (n < iRegionArray.length) {
            textPresentation.addStyleRange(new StyleRange(iRegionArray[n].getOffset(), iRegionArray[n].getLength(), CDebugUIPlugin.getPreferenceColor(IInternalCDebugUIConstants.DISASSEMBLY_SOURCE_LINE_COLOR), null));
            ++n;
        }
        return textPresentation;
    }

    protected void refresh(IDisassembly iDisassembly) {
        if (!(this.getInput() instanceof DisassemblyEditorInput) || !iDisassembly.equals(((DisassemblyEditorInput)this.getInput()).getDisassembly())) {
            return;
        }
        this.resetViewerInput();
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        if (iAdaptable instanceof ICStackFrame) {
            this.fLastStackFrame = (ICStackFrame)iAdaptable;
            IEditorInput iEditorInput = this.getInput();
            if (iEditorInput instanceof DisassemblyEditorInput) {
                this.setViewerInput(DisassemblyEditorInput.PENDING_EDITOR_INPUT);
            }
            this.computeInput(iEditorInput, (ICStackFrame)iAdaptable, this);
        }
    }
}

