/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICMemoryManager;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryPresentation;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryText;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MemoryControlArea
extends Composite
implements ITextOperationTarget {
    private MemoryView fMemoryView;
    private MemoryPresentation fPresentation;
    private int fIndex = 0;
    private ICMemoryManager fMemoryManager = null;
    private Text fAddressText;
    private Button fEvaluateButton;
    private MemoryText fMemoryText;
    private int fFormat = 0;
    private int fWordSize = 1;
    private int fNumberOfRows = 40;
    private int fNumberOfColumns = 16;
    private char fPaddingChar = (char)46;
    static /* synthetic */ Class class$0;

    public MemoryControlArea(Composite composite, int n, int n2, MemoryView memoryView) {
        super(composite, n);
        this.fMemoryView = memoryView;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData gridData = new GridData(1808);
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(gridData);
        this.setIndex(n2);
        this.fPresentation = this.createPresentation();
        this.fAddressText = this.createAddressText(this);
        this.fMemoryText = this.createMemoryText(this, n, this.fPresentation);
        this.setDefaultPreferences();
        this.updateToolTipText();
    }

    private void setDefaultPreferences() {
        char[] cArray = CDebugUIPlugin.getDefault().getPreferenceStore().getString("Memory.PaddingChar").toCharArray();
        this.setPaddingChar(cArray.length > 0 ? cArray[0] : (char)'.');
        this.fPresentation.setDisplayAscii(CDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(ICDebugPreferenceConstants.PREF_MEMORY_SHOW_ASCII));
    }

    private MemoryPresentation createPresentation() {
        return new MemoryPresentation();
    }

    public MemoryPresentation getPresentation() {
        return this.fPresentation;
    }

    private Text createAddressText(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 131072);
        label.setText(MemoryViewMessages.getString("MemoryControlArea.0"));
        label.pack();
        Text text = new Text(composite2, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4 && traverseEvent.stateMask == 0) {
                    traverseEvent.doit = false;
                    MemoryControlArea.this.handleAddressEnter();
                }
            }
        });
        text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }

            public void focusLost(FocusEvent focusEvent) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                MemoryControlArea.this.handleAddressModification();
            }
        });
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }

            public void keyReleased(KeyEvent keyEvent) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }
        });
        text.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }

            public void mouseDown(MouseEvent mouseEvent) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }

            public void mouseUp(MouseEvent mouseEvent) {
                MemoryControlArea.this.getMemoryView().updateObjects();
            }
        });
        this.fEvaluateButton = new Button(composite2, 8);
        this.fEvaluateButton.setText(MemoryViewMessages.getString("MemoryControlArea.1"));
        this.fEvaluateButton.setToolTipText(MemoryViewMessages.getString("MemoryControlArea.2"));
        this.fEvaluateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MemoryControlArea.this.evaluateAddressExpression();
            }
        });
        return text;
    }

    private MemoryText createMemoryText(Composite composite, int n, MemoryPresentation memoryPresentation) {
        return new MemoryText(composite, 35584, memoryPresentation);
    }

    protected void handleAddressEnter() {
        if (this.getMemoryManager() != null) {
            String string = this.fAddressText.getText().trim();
            try {
                this.removeBlock();
                if (string.length() > 0) {
                    this.createBlock(string);
                }
            }
            catch (DebugException debugException) {
                CDebugUIPlugin.errorDialog(MemoryViewMessages.getString("MemoryControlArea.3"), debugException.getStatus());
            }
            this.refresh();
            this.getMemoryView().updateObjects();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("Memory.background.RGB")) {
            this.fMemoryText.setBackgroundColor();
        } else if (propertyChangeEvent.getProperty().equals("Memory.Foreground.RGB")) {
            this.fMemoryText.setForegroundColor();
        } else if (propertyChangeEvent.getProperty().equals("Memory.font")) {
            this.fMemoryText.changeFont();
        } else if (propertyChangeEvent.getProperty().equals("Memory.Address.RGB")) {
            this.fMemoryText.setAddressColor();
        } else if (propertyChangeEvent.getProperty().equals("Memory.Changed.RGB")) {
            this.fMemoryText.setChangedColor();
        } else if (propertyChangeEvent.getProperty().equals("Memory.Dirty.RGB")) {
            this.fMemoryText.setDirtyColor();
        } else if (propertyChangeEvent.getProperty().equals("Memory.PaddingChar")) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.setPaddingChar(string.length() > 0 ? string.charAt(0) : (char)'.');
            this.refresh();
        }
    }

    public void setInput(Object object) {
        this.setMemoryManager(object instanceof ICMemoryManager ? (ICMemoryManager)object : null);
        this.getPresentation().setMemoryBlock(this.getMemoryBlock());
        this.setState();
        this.refresh();
    }

    protected void refresh() {
        this.fAddressText.setText(this.getPresentation() != null ? this.getPresentation().getAddressExpression() : "");
        this.fMemoryText.refresh();
        this.getMemoryView().updateObjects();
        this.updateToolTipText();
    }

    protected void setMemoryManager(ICMemoryManager iCMemoryManager) {
        this.fMemoryManager = iCMemoryManager;
    }

    protected ICMemoryManager getMemoryManager() {
        return this.fMemoryManager;
    }

    protected IFormattedMemoryBlock getMemoryBlock() {
        return this.getMemoryManager() != null ? this.getMemoryManager().getBlock(this.getIndex()) : null;
    }

    protected int getIndex() {
        return this.fIndex;
    }

    protected void setIndex(int n) {
        this.fIndex = n;
    }

    private void createBlock(String string) throws DebugException {
        if (this.getMemoryManager() != null) {
            ICMemoryManager iCMemoryManager = this.getMemoryManager();
            int n = this.getIndex();
            ICMemoryManager iCMemoryManager2 = this.getMemoryManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCMemoryManager.setBlockAt(n, CDebugModel.createFormattedMemoryBlock((IDebugTarget)((IDebugTarget)iCMemoryManager2.getAdapter((Class)clazz)), (String)string, (int)this.getFormat(), (int)this.getWordSize(), (int)this.getNumberOfRows(), (int)this.getNumberOfColumns(), (char)this.getPaddingChar()));
            this.getMemoryBlock().setFrozen(!CDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(ICDebugPreferenceConstants.PREF_MEMORY_AUTO_REFRESH));
            this.getPresentation().setMemoryBlock(this.getMemoryBlock());
        }
        this.setMemoryTextState();
        this.updateToolTipText();
    }

    private void removeBlock() throws DebugException {
        if (this.getMemoryManager() != null) {
            this.getMemoryManager().removeBlock(this.getIndex());
            this.getPresentation().setMemoryBlock(null);
        }
        this.setMemoryTextState();
        this.updateToolTipText();
    }

    public int getFormat() {
        return this.fFormat;
    }

    public int getNumberOfColumns() {
        return this.fNumberOfColumns;
    }

    public int getNumberOfRows() {
        return this.fNumberOfRows;
    }

    public char getPaddingChar() {
        return this.fPaddingChar;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public void setFormat(int n) {
        this.fFormat = n;
    }

    public void setNumberOfColumns(int n) {
        this.fNumberOfColumns = n;
    }

    public void setNumberOfRows(int n) {
        this.fNumberOfRows = n;
    }

    public void setPaddingChar(char c) {
        this.fPaddingChar = c;
        if (this.getMemoryBlock() != null) {
            try {
                this.getMemoryBlock().reformat(this.getMemoryBlock().getFormat(), this.getMemoryBlock().getWordSize(), this.getMemoryBlock().getNumberOfRows(), this.getMemoryBlock().getNumberOfColumns(), this.fPaddingChar);
            }
            catch (DebugException debugException) {}
        }
    }

    public void setWordSize(int n) {
        this.fWordSize = n;
    }

    private void enableAddressText(boolean bl) {
        this.fAddressText.setEnabled(bl);
    }

    protected void setState() {
        this.enableAddressText(this.getMemoryManager() != null);
        this.setMemoryTextState();
    }

    private void setMemoryTextState() {
        this.fMemoryText.setEditable(this.getMemoryManager() != null && this.getMemoryBlock() != null);
    }

    protected MemoryText getMemoryText() {
        return this.fMemoryText;
    }

    protected void clear() {
        this.fAddressText.setText("");
        this.handleAddressEnter();
        this.updateToolTipText();
    }

    public void dispose() {
        if (this.getPresentation() != null) {
            this.getPresentation().dispose();
        }
        super.dispose();
    }

    protected String getTitle() {
        if (this.getParent() instanceof CTabFolder) {
            CTabItem[] cTabItemArray = ((CTabFolder)this.getParent()).getItems();
            return cTabItemArray[this.fIndex].getText();
        }
        return "";
    }

    protected void setTitle(String string) {
        if (this.getParent() instanceof CTabFolder) {
            CTabItem[] cTabItemArray = ((CTabFolder)this.getParent()).getItems();
            cTabItemArray[this.fIndex].setText(string);
        }
    }

    protected void setTabItemToolTipText(String string) {
        String string2 = this.replaceMnemonicCharacters(string);
        if (this.getParent() instanceof CTabFolder) {
            CTabItem[] cTabItemArray = ((CTabFolder)this.getParent()).getItems();
            cTabItemArray[this.fIndex].setToolTipText(String.valueOf(MemoryViewMessages.getString("MemoryControlArea.4")) + (this.fIndex + 1) + (string2.length() > 0 ? ": " + string2 : ""));
        }
    }

    protected void refreshMemoryBlock() {
        if (this.getMemoryBlock() != null) {
            try {
                this.getMemoryBlock().refresh();
            }
            catch (DebugException debugException) {
                CDebugUIPlugin.errorDialog(MemoryViewMessages.getString("MemoryControlArea.7"), debugException.getStatus());
            }
        }
    }

    private void updateToolTipText() {
        this.setTabItemToolTipText(this.fAddressText.getText().trim());
    }

    private String replaceMnemonicCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuffer.append(c);
            if (c == '&') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected void handleAddressModification() {
        this.fEvaluateButton.setEnabled(this.fAddressText.getText().trim().length() > 0);
    }

    protected void evaluateAddressExpression() {
        if (this.getMemoryManager() != null) {
            if (this.getMemoryBlock() == null) {
                String string = this.fAddressText.getText().trim();
                try {
                    this.removeBlock();
                    if (string.length() > 0) {
                        this.createBlock(string);
                    }
                }
                catch (DebugException debugException) {
                    CDebugUIPlugin.errorDialog(MemoryViewMessages.getString("MemoryControlArea.8"), debugException.getStatus());
                }
            }
            if (this.getMemoryBlock() != null) {
                this.fAddressText.setText(CDebugUIUtils.toHexAddressString(this.getMemoryBlock().getStartAddress()));
                this.handleAddressEnter();
            }
        }
    }

    public boolean canDoOperation(int n) {
        switch (n) {
            case 3: 
            case 4: {
                return this.fAddressText != null && this.fAddressText.isFocusControl() && this.fAddressText.isEnabled() && this.fAddressText.getSelectionCount() > 0;
            }
            case 5: 
            case 7: {
                return this.fAddressText != null && this.fAddressText.isFocusControl() && this.fAddressText.isEnabled();
            }
        }
        return false;
    }

    public void doOperation(int n) {
        switch (n) {
            case 3: {
                this.fAddressText.cut();
                break;
            }
            case 4: {
                this.fAddressText.copy();
                break;
            }
            case 5: {
                this.fAddressText.paste();
                break;
            }
            case 7: {
                this.fAddressText.selectAll();
            }
        }
    }

    protected MemoryView getMemoryView() {
        return this.fMemoryView;
    }
}

