/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlockRow;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.debug.core.DebugException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class MemoryPresentation {
    private static final int INTERVAL_BETWEEN_ADDRESS_AND_DATA = 2;
    private static final int INTERVAL_BETWEEN_DATA_ITEMS = 1;
    private static final int INTERVAL_BETWEEN_DATA_AND_ASCII = 1;
    private IFormattedMemoryBlock fBlock;
    private List fAddressZones = new LinkedList();
    private List fChangedZones = new LinkedList();
    private boolean fDisplayAscii = true;

    public IFormattedMemoryBlock getMemoryBlock() {
        return this.fBlock;
    }

    public void setMemoryBlock(IFormattedMemoryBlock iFormattedMemoryBlock) {
        this.fBlock = iFormattedMemoryBlock;
    }

    public String getText() {
        this.fAddressZones.clear();
        IFormattedMemoryBlockRow[] iFormattedMemoryBlockRowArray = this.getMemoryBlock() != null ? this.getMemoryBlock().getRows() : new IFormattedMemoryBlockRow[]{};
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < iFormattedMemoryBlockRowArray.length) {
            int n2 = stringBuffer.length();
            stringBuffer.append(this.getRowText(iFormattedMemoryBlockRowArray[n]));
            this.fAddressZones.add(new Point(n2, n2 + this.getAddressLength()));
            ++n;
        }
        return stringBuffer.toString();
    }

    public String[] getText(Point[] pointArray) {
        return new String[0];
    }

    public boolean isAcceptable(char c, int n) {
        if (this.isInAsciiArea(n)) {
            return true;
        }
        if (this.isInDataArea(n)) {
            return this.isValidValue(c);
        }
        return false;
    }

    public Point[] getAddressZones() {
        return this.fAddressZones.toArray(new Point[this.fAddressZones.size()]);
    }

    public Point[] getChangedZones() {
        this.fChangedZones.clear();
        Long[] longArray = this.getChangedAddresses();
        int n = 0;
        while (n < longArray.length) {
            int n2;
            int n3 = this.getDataItemOffsetByAddress(longArray[n]);
            if (n3 != -1) {
                this.fChangedZones.add(new Point(n3, n3 + this.getDataItemLength() - 1));
            }
            if (this.displayASCII() && (n2 = this.getAsciiOffsetByAddress(longArray[n])) != -1) {
                this.fChangedZones.add(new Point(n2, n2));
            }
            ++n;
        }
        return this.fChangedZones.toArray(new Point[this.fChangedZones.size()]);
    }

    public String getStartAddress() {
        return this.fBlock != null ? this.getAddressString(this.fBlock.getStartAddress()) : "";
    }

    public String getAddressExpression() {
        return this.fBlock != null ? this.fBlock.getAddressExpression() : "";
    }

    private String getInterval(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private String getAddressString(long l) {
        return CDebugUIUtils.toHexAddressString(l);
    }

    private String getRowText(IFormattedMemoryBlockRow iFormattedMemoryBlockRow) {
        StringBuffer stringBuffer = new StringBuffer(this.getRowLength());
        stringBuffer.append(this.getAddressString(iFormattedMemoryBlockRow.getAddress()));
        stringBuffer.append(this.getInterval(2));
        String[] stringArray = iFormattedMemoryBlockRow.getData();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(this.getDataItemPresentation(stringArray[n]));
            stringBuffer.append(this.getInterval(1));
            ++n;
        }
        if (this.displayASCII()) {
            stringBuffer.append(this.getInterval(1));
            stringBuffer.append(iFormattedMemoryBlockRow.getASCII());
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private int getRowLength() {
        return this.getAddressLength() + 2 + (this.getDataItemLength() + 1) * this.getNumberOfDataItemsInRow() + (this.displayASCII() ? 1 + this.getDataBytesPerRow() : 0) + 1;
    }

    private int getAddressLength() {
        return 10;
    }

    private boolean isInAsciiArea(int n) {
        if (this.displayASCII() && this.getRowLength() != 0) {
            int n2;
            int n3 = n % this.getRowLength();
            return n3 >= (n2 = this.getAddressLength() + 2 + (this.getDataItemLength() + 1) * this.getNumberOfDataItemsInRow() + 1) && n3 < this.getRowLength() - 1;
        }
        return false;
    }

    private boolean isInDataArea(int n) {
        if (this.getRowLength() != 0) {
            int n2 = n % this.getRowLength();
            int n3 = this.getAddressLength() + 2;
            int n4 = n3 + (this.getDataItemLength() + 1) * this.getNumberOfDataItemsInRow();
            if (n2 >= n3 && n2 < n4) {
                return this.isInDataItem(n2 - n3);
            }
        }
        return false;
    }

    private boolean isInDataItem(int n) {
        int n2 = 0;
        while (n2 < this.getNumberOfDataItemsInRow()) {
            if (n < n2 * (this.getDataItemLength() + 1)) {
                return false;
            }
            if (n >= n2 * (this.getDataItemLength() + 1) && n < n2 * (this.getDataItemLength() + 1) + this.getDataItemLength()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int getDataItemLength() {
        if (this.getMemoryBlock() != null) {
            switch (this.getDataFormat()) {
                case 0: {
                    return this.getMemoryBlock().getWordSize() * 2;
                }
                case 3: {
                    return this.getDecimalDataItemLength(this.getMemoryBlock().getWordSize(), true);
                }
                case 4: {
                    return this.getDecimalDataItemLength(this.getMemoryBlock().getWordSize(), false);
                }
            }
        }
        return 0;
    }

    private int getNumberOfDataItemsInRow() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().getNumberOfColumns();
        }
        return 0;
    }

    protected boolean displayASCII() {
        if (this.canDisplayAscii()) {
            return this.fDisplayAscii;
        }
        return false;
    }

    protected void setDisplayAscii(boolean bl) {
        this.fDisplayAscii = bl;
    }

    private int getDataBytesPerRow() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().getNumberOfColumns() * this.getMemoryBlock().getWordSize();
        }
        return 0;
    }

    private boolean isValidValue(char c) {
        switch (this.getDataFormat()) {
            case 0: {
                return this.isHexadecimal(c);
            }
        }
        return false;
    }

    private boolean isHexadecimal(char c) {
        return Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private int getDataFormat() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().getFormat();
        }
        return 0;
    }

    private Long[] getChangedAddresses() {
        return this.getMemoryBlock() != null ? this.getMemoryBlock().getChangedAddresses() : new Long[]{};
    }

    private int getDataItemOffsetByAddress(Long l) {
        if (this.getMemoryBlock() != null) {
            IFormattedMemoryBlockRow[] iFormattedMemoryBlockRowArray = this.getMemoryBlock().getRows();
            int n = 0;
            while (n < iFormattedMemoryBlockRowArray.length) {
                int n2 = this.getMemoryBlock().getWordSize();
                int n3 = this.getMemoryBlock().getNumberOfColumns();
                if (l >= iFormattedMemoryBlockRowArray[n].getAddress() && l < iFormattedMemoryBlockRowArray[n].getAddress() + (long)(n2 * n3)) {
                    int n4 = 1;
                    while (n4 <= n3) {
                        if (l >= iFormattedMemoryBlockRowArray[n].getAddress() + (long)((n4 - 1) * n2) && l < iFormattedMemoryBlockRowArray[n].getAddress() + (long)(n4 * n2)) {
                            return n * this.getRowLength() + (n4 - 1) * (this.getDataItemLength() + 1) + this.getAddressLength() + 2;
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        return -1;
    }

    private int getAsciiOffsetByAddress(Long l) {
        IFormattedMemoryBlockRow[] iFormattedMemoryBlockRowArray;
        if (this.getMemoryBlock() != null && (iFormattedMemoryBlockRowArray = this.getMemoryBlock().getRows()).length > 0) {
            IFormattedMemoryBlockRow iFormattedMemoryBlockRow = iFormattedMemoryBlockRowArray[0];
            IFormattedMemoryBlockRow iFormattedMemoryBlockRow2 = iFormattedMemoryBlockRowArray[iFormattedMemoryBlockRowArray.length - 1];
            if (l >= iFormattedMemoryBlockRow.getAddress() && l <= iFormattedMemoryBlockRow2.getAddress()) {
                int n = (int)(l - iFormattedMemoryBlockRow.getAddress());
                int n2 = this.getMemoryBlock().getWordSize() * this.getMemoryBlock().getNumberOfColumns();
                int n3 = n / n2;
                int n4 = n % n2;
                return n3 * this.getRowLength() + this.getAddressLength() + 2 + (this.getDataItemLength() + 1) * this.getMemoryBlock().getNumberOfColumns() + 1 + n4;
            }
        }
        return -1;
    }

    protected boolean canDisplayAscii() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().displayASCII();
        }
        return false;
    }

    protected int getDataItemIndex(int n) {
        int n2 = n / this.getRowLength();
        int n3 = n % this.getRowLength() - this.getAddressLength() - 2;
        int n4 = 0;
        while (n4 < this.getNumberOfDataItemsInRow()) {
            if (n3 < n4 * (this.getDataItemLength() + 1)) {
                return -1;
            }
            if (n3 >= n4 * (this.getDataItemLength() + 1) && n3 < n4 * (this.getDataItemLength() + 1) + this.getDataItemLength()) {
                return n4 + n2 * this.getNumberOfDataItemsInRow();
            }
            ++n4;
        }
        if (this.displayASCII() && n3 >= this.getNumberOfDataItemsInRow() * (this.getDataItemLength() + 1) + 1) {
            return (n3 - (this.getNumberOfDataItemsInRow() * (this.getDataItemLength() + 1) + 1)) * 2 / this.getDataItemLength() + n2 * this.getNumberOfDataItemsInRow();
        }
        return -1;
    }

    private int getDataItemOffset(int n) {
        int n2 = n / this.getNumberOfDataItemsInRow();
        int n3 = n % this.getNumberOfDataItemsInRow();
        return n2 * this.getRowLength() + this.getAddressLength() + 2 + n3 * (this.getDataItemLength() + 1);
    }

    private char[] getDataItemChars(int n) {
        if (this.getMemoryBlock() != null) {
            String[] stringArray;
            int n2 = n / this.getMemoryBlock().getNumberOfColumns();
            int n3 = n % this.getMemoryBlock().getNumberOfColumns();
            IFormattedMemoryBlockRow[] iFormattedMemoryBlockRowArray = this.getMemoryBlock().getRows();
            if (n2 < iFormattedMemoryBlockRowArray.length && n3 < (stringArray = iFormattedMemoryBlockRowArray[n2].getData()).length) {
                return stringArray[n3].toCharArray();
            }
        }
        return new char[0];
    }

    private int getOffsetInDataItem(int n, int n2) {
        if (this.isInDataArea(n)) {
            return n - this.getDataItemOffset(n2);
        }
        return -1;
    }

    public void dispose() {
        if (this.fAddressZones != null) {
            this.fAddressZones.clear();
        }
        if (this.fChangedZones != null) {
            this.fChangedZones.clear();
        }
    }

    private String getDataItemPresentation(String string) {
        switch (this.getDataFormat()) {
            case 0: {
                return this.convertToHex(this.getWordSize(), string);
            }
            case 3: {
                return this.convertToDecimal(this.getWordSize(), string, true);
            }
            case 4: {
                return this.convertToDecimal(this.getWordSize(), string, false);
            }
        }
        return "";
    }

    private int getDecimalDataItemLength(int n, boolean bl) {
        switch (n) {
            case 1: {
                return bl ? 4 : 3;
            }
            case 2: {
                return bl ? 6 : 5;
            }
            case 4: {
                return bl ? 11 : 10;
            }
        }
        return 0;
    }

    private int getWordSize() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().getWordSize();
        }
        return 0;
    }

    private String convertToHex(int n, String string) {
        if (!this.getMemoryBlock().isLittleEndian() || n == 1) {
            return string;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n2 - 2;
        while (n3 >= 0) {
            stringBuffer.append(string.substring(n3, n3 + 2));
            n3 -= 2;
        }
        return stringBuffer.toString();
    }

    private String convertToDecimal(int n, String string, boolean bl) {
        String string2 = "";
        boolean bl2 = this.getMemoryBlock().isLittleEndian();
        switch (n) {
            case 1: {
                string2 = Long.toString(bl ? CDebugUtils.toByte((char[])string.toCharArray(), (boolean)bl2) : CDebugUtils.toUnsignedByte((char[])string.toCharArray(), (boolean)bl2));
                break;
            }
            case 2: {
                string2 = Long.toString(bl ? CDebugUtils.toShort((char[])string.toCharArray(), (boolean)bl2) : CDebugUtils.toUnsignedShort((char[])string.toCharArray(), (boolean)bl2));
                break;
            }
            case 4: {
                string2 = Long.toString(bl ? (long)CDebugUtils.toInt((char[])string.toCharArray(), (boolean)bl2) : CDebugUtils.toUnsignedInt((char[])string.toCharArray(), (boolean)bl2));
            }
        }
        return CDebugUtils.prependString((String)string2, (int)this.getDataItemLength(), (char)' ');
    }

    protected boolean isStartAddressChanged() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().isStartAddressChanged();
        }
        return false;
    }

    protected String getNewItemValue(int n, char c) {
        int n2;
        if (this.getMemoryBlock() != null && (n2 = this.getDataItemIndex(n)) != -1) {
            char[] cArray = this.getDataItemChars(n2);
            if (this.isInDataArea(n)) {
                int n3 = this.getOffsetInDataItem(n, n2);
                cArray[n3] = c;
            }
            if (this.isInAsciiArea(n)) {
                cArray = CDebugUtils.getByteText((byte)((byte)c));
            }
            return new String(cArray);
        }
        return null;
    }

    protected void setItemValue(int n, char c) {
        String string;
        int n2;
        if (this.getMemoryBlock() != null && (n2 = this.getDataItemIndex(n)) != -1 && (string = this.getNewItemValue(n, c)) != null) {
            try {
                this.getMemoryBlock().setItemValue(n2, string);
                return;
            }
            catch (DebugException debugException) {
                Display.getDefault().beep();
            }
        }
        Display.getDefault().beep();
    }
}

