/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.sharedlibs;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.ui.CDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesMessages;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesViewEventHandler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class SharedLibrariesView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
INullSelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    protected Viewer createViewer(Composite composite) {
        TableTreeViewer tableTreeViewer = new TableTreeViewer(composite, 66306);
        Table table = tableTreeViewer.getTableTree().getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] tableColumnArray = table.getColumns();
        tableColumnArray[1].setResizable(true);
        tableColumnArray[2].setResizable(true);
        tableColumnArray[3].setResizable(true);
        tableColumnArray[4].setResizable(true);
        tableColumnArray[0].setText("");
        tableColumnArray[1].setText(SharedLibrariesMessages.getString("SharedLibrariesView.Name_1"));
        tableColumnArray[2].setText(SharedLibrariesMessages.getString("SharedLibrariesView.Symbols_1"));
        tableColumnArray[3].setText(SharedLibrariesMessages.getString("SharedLibrariesView.Start_Address_1"));
        tableColumnArray[4].setText(SharedLibrariesMessages.getString("SharedLibrariesView.End_Address_1"));
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        tableColumnArray[0].setWidth(pixelConverter.convertWidthInCharsToPixels(3));
        tableColumnArray[1].setWidth(pixelConverter.convertWidthInCharsToPixels(50));
        tableColumnArray[2].setWidth(pixelConverter.convertWidthInCharsToPixels(20));
        tableColumnArray[3].setWidth(pixelConverter.convertWidthInCharsToPixels(20));
        tableColumnArray[4].setWidth(pixelConverter.convertWidthInCharsToPixels(20));
        tableTreeViewer.setContentProvider(this.createContentProvider());
        tableTreeViewer.setLabelProvider((IBaseLabelProvider)new SharedLibrariesLabelProvider());
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)tableTreeViewer));
        return tableTreeViewer;
    }

    protected void createActions() {
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.SHARED_LIBRARIES_VIEW;
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("emptySharedLibrariesGroup"));
        iMenuManager.add((IContributionItem)new Separator("sharedLibrariesGroup"));
        iMenuManager.add((IContributionItem)new Separator("emptyRefreshGroup"));
        iMenuManager.add((IContributionItem)new Separator("refreshGroup"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator("sharedLibrariesGroup"));
        iToolBarManager.add((IContributionItem)new Separator("refreshGroup"));
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (iSelection == null) {
            this.setViewerInput((IStructuredSelection)new StructuredSelection());
        } else if (iSelection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)iSelection);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void handleException(DebugException debugException) {
        this.showMessage(debugException.getMessage());
    }

    protected void setViewerInput(IStructuredSelection iStructuredSelection) {
        Object object;
        ICDebugTarget iCDebugTarget = null;
        if (iStructuredSelection != null && iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IDebugElement && ((IDebugElement)object).getDebugTarget() instanceof ICDebugTarget) {
            iCDebugTarget = (ICDebugTarget)((IDebugElement)object).getDebugTarget();
        }
        if (this.getViewer() == null) {
            return;
        }
        object = this.getViewer().getInput();
        if (object != null && object.equals(iCDebugTarget)) {
            this.updateObjects();
            return;
        }
        this.showViewer();
        this.getViewer().setInput(iCDebugTarget);
        this.updateObjects();
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new SharedLibrariesViewEventHandler(this);
    }

    protected IContentProvider createContentProvider() {
        SharedLibrariesViewContentProvider sharedLibrariesViewContentProvider = new SharedLibrariesViewContentProvider();
        sharedLibrariesViewContentProvider.setExceptionHandler(this);
        return sharedLibrariesViewContentProvider;
    }

    protected void becomesHidden() {
        this.setViewerInput((IStructuredSelection)new StructuredSelection());
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IViewPart iViewPart = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView");
        if (iViewPart != null) {
            ISelection iSelection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged((IWorkbenchPart)iViewPart, iSelection);
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public IDebugModelPresentation getPresentation(String string) {
        StructuredViewer structuredViewer = this.getStructuredViewer();
        if (structuredViewer != null) {
            IBaseLabelProvider iBaseLabelProvider = structuredViewer.getLabelProvider();
            return iBaseLabelProvider instanceof SharedLibrariesLabelProvider ? (SharedLibrariesLabelProvider)iBaseLabelProvider : null;
        }
        return null;
    }

    public class SharedLibrariesLabelProvider
    extends CDebugModelPresentation
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            if (object instanceof ICSharedLibrary && n == 1) {
                return this.getImage(object);
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ICSharedLibrary) {
                ICSharedLibrary iCSharedLibrary = (ICSharedLibrary)object;
                switch (n) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return this.getText(object);
                    }
                    case 2: {
                        return iCSharedLibrary.areSymbolsLoaded() ? SharedLibrariesMessages.getString("SharedLibrariesView.Loaded_1") : SharedLibrariesMessages.getString("SharedLibrariesView.Not_loaded_1");
                    }
                    case 3: {
                        return iCSharedLibrary.getStartAddress() > 0L ? CDebugUIUtils.toHexAddressString(iCSharedLibrary.getStartAddress()) : "";
                    }
                    case 4: {
                        return iCSharedLibrary.getEndAddress() > 0L ? CDebugUIUtils.toHexAddressString(iCSharedLibrary.getEndAddress()) : "";
                    }
                }
            }
            return null;
        }
    }
}

