/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.sharedlibs;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SharedLibrariesViewContentProvider
implements ITreeContentProvider {
    private HashMap fParentCache;
    private IDebugExceptionHandler fExceptionHandler;

    public SharedLibrariesViewContentProvider() {
        this.setParentCache(new HashMap(10));
    }

    public Object[] getChildren(Object object) {
        if (object instanceof ICDebugTarget) {
            Object[] objectArray = null;
            ICDebugTarget iCDebugTarget = (ICDebugTarget)object;
            try {
                if (iCDebugTarget != null) {
                    objectArray = iCDebugTarget.getSharedLibraries();
                }
                if (objectArray != null) {
                    this.cache(object, objectArray);
                    return objectArray;
                }
            }
            catch (DebugException debugException) {
                if (this.getExceptionHandler() != null) {
                    this.getExceptionHandler().handleException(debugException);
                }
                CDebugUIPlugin.log(debugException);
            }
        }
        return new Object[0];
    }

    protected void cache(Object object, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.getParentCache().put(objectArray[n], object);
            ++n;
        }
    }

    public Object getParent(Object object) {
        return this.getParentCache().get(object);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof ICDebugTarget) {
            try {
                ICDebugTarget iCDebugTarget = (ICDebugTarget)object;
                return iCDebugTarget.hasSharedLibraries();
            }
            catch (DebugException debugException) {
                CDebugUIPlugin.log(debugException);
            }
        }
        return false;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
        this.setParentCache(null);
        this.setExceptionHandler(null);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.clearCache();
    }

    protected void clearCache() {
        if (this.getParentCache() != null) {
            this.getParentCache().clear();
        }
    }

    public void removeCache(Object[] objectArray) {
        if (this.getParentCache() != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.getParentCache().remove(objectArray[n]);
                ++n;
            }
        }
    }

    protected void setExceptionHandler(IDebugExceptionHandler iDebugExceptionHandler) {
        this.fExceptionHandler = iDebugExceptionHandler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    private HashMap getParentCache() {
        return this.fParentCache;
    }

    private void setParentCache(HashMap hashMap) {
        this.fParentCache = hashMap;
    }
}

