/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICBreakpointListener;
import org.eclipse.cdt.debug.core.model.ISwitchToFrame;
import org.eclipse.cdt.debug.core.model.ISwitchToThread;
import org.eclipse.cdt.debug.internal.ui.CBreakpointUpdater;
import org.eclipse.cdt.debug.internal.ui.CDTDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.ColorManager;
import org.eclipse.cdt.debug.ui.UIMessages;
import org.eclipse.cdt.debug.ui.sourcelookup.DefaultSourceLocator;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CDebugUIPlugin
extends AbstractUIPlugin
implements ISelectionListener {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.ui";
    private static CDebugUIPlugin plugin;
    protected Map fDebuggerPageMap;
    private CDebugImageDescriptorRegistry fImageDescriptorRegistry;

    public CDebugUIPlugin() {
        plugin = this;
    }

    public static CDebugUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        if (CDebugUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return CDebugUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static Color getPreferenceColor(String string) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)CDebugUIPlugin.getDefault().getPreferenceStore(), (String)string));
    }

    public static CDTDebugModelPresentation getDebugModelPresentation() {
        return CDTDebugModelPresentation.getDefault();
    }

    public static void log(IStatus iStatus) {
        CDebugUIPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, "Internal Error", throwable));
    }

    public static void logErrorMessage(String string) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
    }

    public ILaunchConfigurationTab getDebuggerPage(String string) {
        if (this.fDebuggerPageMap == null) {
            this.initializeDebuggerPageMap();
        }
        IConfigurationElement iConfigurationElement = (IConfigurationElement)this.fDebuggerPageMap.get(string);
        ILaunchConfigurationTab iLaunchConfigurationTab = null;
        if (iConfigurationElement != null) {
            try {
                iLaunchConfigurationTab = (ILaunchConfigurationTab)iConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 100, "An error occurred retrieving a C Debugger page", (Throwable)coreException));
            }
        }
        return iLaunchConfigurationTab;
    }

    protected void initializeDebuggerPageMap() {
        this.fDebuggerPageMap = new HashMap(10);
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "CDebuggerPage");
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute("debuggerID");
            this.fDebuggerPageMap.put(string, iConfigurationElementArray[n]);
            ++n;
        }
    }

    public static void errorDialog(String string, IStatus iStatus) {
        CDebugUIPlugin.log(iStatus);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)UIMessages.getString("CDebugUIPlugin.0"), (String)string, (IStatus)iStatus);
        }
    }

    public static void errorDialog(String string, Throwable throwable) {
        CDebugUIPlugin.log(throwable);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, throwable.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)UIMessages.getString("CDebugUIPlugin.0"), (String)string, (IStatus)status);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static CDebugImageDescriptorRegistry getImageDescriptorRegistry() {
        if (CDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            CDebugUIPlugin.getDefault().fImageDescriptorRegistry = new CDebugImageDescriptorRegistry();
        }
        return CDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection != null && iSelection instanceof IStructuredSelection && ((IStructuredSelection)iSelection).size() == 1) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object != null && object instanceof IThread) {
                if (((IThread)object).getDebugTarget() instanceof ISwitchToThread) {
                    try {
                        if (!this.sameThread((IDebugElement)object)) {
                            ((ISwitchToThread)((IThread)object).getDebugTarget()).setCurrentThread((IThread)object);
                        }
                    }
                    catch (DebugException debugException) {
                        CDebugUIPlugin.errorDialog(debugException.getMessage(), debugException);
                    }
                }
            } else if (object != null && object instanceof IStackFrame && ((IStackFrame)object).getThread() instanceof ISwitchToFrame) {
                try {
                    if (!this.sameThread((IDebugElement)object)) {
                        ((ISwitchToThread)((IStackFrame)object).getDebugTarget()).setCurrentThread(((IStackFrame)object).getThread());
                    }
                    ((ISwitchToFrame)((IStackFrame)object).getThread()).switchToFrame((IStackFrame)object);
                }
                catch (DebugException debugException) {}
            }
        }
    }

    private boolean sameThread(IDebugElement iDebugElement) throws DebugException {
        if (iDebugElement.getDebugTarget() instanceof ISwitchToThread) {
            if (iDebugElement instanceof IThread) {
                return ((IThread)iDebugElement).equals(((ISwitchToThread)iDebugElement.getDebugTarget()).getCurrentThread());
            }
            if (iDebugElement instanceof IStackFrame) {
                return ((IStackFrame)iDebugElement).getThread().equals(((ISwitchToThread)iDebugElement.getDebugTarget()).getCurrentThread());
            }
        }
        return false;
    }

    public static IPersistableSourceLocator createDefaultSourceLocator() {
        return new DefaultSourceLocator();
    }

    public static String getDefaultSourceLocatorID() {
        return DefaultSourceLocator.ID_DEFAULT_SOURCE_LOCATOR;
    }

    public static String getDefaultSourceLocatorOldID() {
        return "org.eclipse.cdt.launch.DefaultSourceLocator";
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.listenSelection(true, this);
        CDebugCorePlugin.getDefault().addCBreakpointListener((ICBreakpointListener)CBreakpointUpdater.getInstance());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        CDebugCorePlugin.getDefault().removeCBreakpointListener((ICBreakpointListener)CBreakpointUpdater.getInstance());
        try {
            this.listenSelection(false, this);
        }
        catch (SWTException sWTException) {}
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        super.stop(bundleContext);
    }

    void listenSelection(final boolean bl, final ISelectionListener iSelectionListener) {
        Display display = this.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    if (bl) {
                        iWorkbenchWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", iSelectionListener);
                    } else {
                        iWorkbenchWindow.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", iSelectionListener);
                    }
                }
            }
        };
        display.asyncExec(runnable);
    }
}

