/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.editors.NoSymbolOrSourceElement;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultSourceLocator
implements IPersistableSourceLocator,
IAdaptable {
    public static final String ID_DEFAULT_SOURCE_LOCATOR = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".DefaultSourceLocator";
    public static final String ID_OLD_DEFAULT_SOURCE_LOCATOR = "org.eclipse.cdt.launch.DefaultSourceLocator";
    private static final String ELEMENT_NAME = "PromptingSourceLocator";
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_MEMENTO = "memento";
    private ICSourceLocator fSourceLocator;
    private HashMap fFramesToSource = null;
    private HashMap fNamesToSource = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String getMemento() throws CoreException {
        if (this.getCSourceLocator() != null) {
            Document document = null;
            Exception exception = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement(ELEMENT_NAME);
                document.appendChild(element);
                element.setAttribute(ATTR_PROJECT, this.getCSourceLocator().getProject().getName());
                IPersistableSourceLocator iPersistableSourceLocator = this.getPersistableSourceLocator();
                if (iPersistableSourceLocator != null) {
                    element.setAttribute(ATTR_MEMENTO, iPersistableSourceLocator.getMemento());
                }
                return CDebugUtils.serializeDocument((Document)document);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                exception = parserConfigurationException;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (TransformerException transformerException) {
                exception = transformerException;
            }
            this.abort(SourceLookupMessages.getString("DefaultSourceLocator.1"), exception);
        }
        return null;
    }

    public void initializeFromMemento(String string) throws CoreException {
        Exception exception = null;
        try {
            IPersistableSourceLocator iPersistableSourceLocator;
            Element element = null;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            element = documentBuilder.parse(inputSource).getDocumentElement();
            if (!element.getNodeName().equalsIgnoreCase(ELEMENT_NAME)) {
                this.abort(SourceLookupMessages.getString("DefaultSourceLocator.2"), null);
            }
            String string2 = element.getAttribute(ATTR_PROJECT);
            String string3 = element.getAttribute(ATTR_MEMENTO);
            if (this.isEmpty(string2)) {
                this.abort(SourceLookupMessages.getString("DefaultSourceLocator.3"), null);
            }
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
            if (this.getCSourceLocator() == null) {
                this.setCSourceLocator(SourceLookupFactory.createSourceLocator((IProject)iProject));
            }
            if (this.getCSourceLocator().getProject() != null && !this.getCSourceLocator().getProject().equals((Object)iProject)) {
                return;
            }
            if (iProject == null || !iProject.exists() || !iProject.isOpen()) {
                this.abort(MessageFormat.format(SourceLookupMessages.getString("DefaultSourceLocator.4"), string2), null);
            }
            if ((iPersistableSourceLocator = this.getPersistableSourceLocator()) != null) {
                iPersistableSourceLocator.initializeFromMemento(string3);
            } else {
                this.abort(SourceLookupMessages.getString("DefaultSourceLocator.5"), null);
            }
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
        }
        catch (SAXException sAXException) {
            exception = sAXException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        this.abort(SourceLookupMessages.getString("DefaultSourceLocator.6"), exception);
    }

    public void initializeDefaults(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        this.setCSourceLocator(SourceLookupFactory.createSourceLocator((IProject)this.getProject(iLaunchConfiguration)));
        String string = iLaunchConfiguration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
        if (!this.isEmpty(string)) {
            this.initializeFromMemento(string);
        }
    }

    public Object getAdapter(Class clazz) {
        if (this.getCSourceLocator() instanceof IAdaptable) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                return ((IAdaptable)this.getCSourceLocator()).getAdapter(clazz);
            }
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz3)) {
                return ((IAdaptable)this.getCSourceLocator()).getAdapter(clazz);
            }
        }
        return null;
    }

    public Object getSourceElement(IStackFrame iStackFrame) {
        Object object = this.cacheLookup(iStackFrame);
        if (object == null && (object = this.getCSourceLocator().getSourceElement(iStackFrame)) instanceof List) {
            List list = (List)object;
            if (list.size() != 0) {
                SourceSelectionDialog sourceSelectionDialog = this.createSourceSelectionDialog(list);
                sourceSelectionDialog.open();
                Object[] objectArray = sourceSelectionDialog.getResult();
                Object object2 = object = objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
                if (object != null) {
                    this.cacheSourceElement(iStackFrame, object, sourceSelectionDialog.alwaysMapToSelection());
                }
            } else {
                object = null;
            }
        }
        if (object == null) {
            object = iStackFrame instanceof ICStackFrame && !this.isEmpty(((ICStackFrame)iStackFrame).getFile()) ? new FileNotFoundElement(iStackFrame) : new NoSymbolOrSourceElement(iStackFrame);
        }
        return object;
    }

    protected void saveChanges(ILaunchConfiguration iLaunchConfiguration, IPersistableSourceLocator iPersistableSourceLocator) {
        try {
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.copy(iLaunchConfiguration.getName());
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, iPersistableSourceLocator.getMemento());
            iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.errorDialog(coreException.getMessage(), null);
        }
    }

    private SourceSelectionDialog createSourceSelectionDialog(List list) {
        SourceSelectionDialog sourceSelectionDialog = new SourceSelectionDialog(CDebugUIPlugin.getActiveWorkbenchShell());
        sourceSelectionDialog.setInput(list.toArray());
        sourceSelectionDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        sourceSelectionDialog.setLabelProvider((ILabelProvider)new SourceElementLabelProvider());
        sourceSelectionDialog.setTitle(SourceLookupMessages.getString("DefaultSourceLocator.7"));
        sourceSelectionDialog.setMessage(SourceLookupMessages.getString("DefaultSourceLocator.8"));
        sourceSelectionDialog.setInitialSelections(new Object[]{list.get(0)});
        return sourceSelectionDialog;
    }

    private void cacheSourceElement(IStackFrame iStackFrame, Object object, boolean bl) {
        if (bl) {
            String string = this.getFileName(iStackFrame);
            if (string != null) {
                if (this.fNamesToSource == null) {
                    this.fNamesToSource = new HashMap();
                }
                this.fNamesToSource.put(string, object);
            }
        } else {
            if (this.fFramesToSource == null) {
                this.fFramesToSource = new HashMap();
            }
            this.fFramesToSource.put(iStackFrame, object);
        }
    }

    private Object cacheLookup(IStackFrame iStackFrame) {
        Object v;
        String string = this.getFileName(iStackFrame);
        if (string != null && this.fNamesToSource != null && (v = this.fNamesToSource.get(string)) != null) {
            return v;
        }
        return this.fFramesToSource != null ? this.fFramesToSource.get(iStackFrame) : null;
    }

    private String getFileName(IStackFrame iStackFrame) {
        String string;
        if (iStackFrame instanceof ICStackFrame && !this.isEmpty(string = ((ICStackFrame)iStackFrame).getFile())) {
            return string.trim();
        }
        return null;
    }

    private ICSourceLocator getCSourceLocator() {
        return this.fSourceLocator;
    }

    private void setCSourceLocator(ICSourceLocator iCSourceLocator) {
        this.fSourceLocator = iCSourceLocator;
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        ICSourceLocator iCSourceLocator = this.getCSourceLocator();
        return iCSourceLocator instanceof IPersistableSourceLocator ? (IPersistableSourceLocator)iCSourceLocator : null;
    }

    private void abort(String string, Throwable throwable) throws CoreException {
        Status status = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 0, string, throwable);
        throw new CoreException((IStatus)status);
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private IProject getProject(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IProject iProject;
        String string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        if (!this.isEmpty(string) && (iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string)).exists()) {
            return iProject;
        }
        this.abort(MessageFormat.format(SourceLookupMessages.getString("DefaultSourceLocator.9"), string), null);
        return null;
    }

    public class SourceSelectionDialog
    extends ListDialog {
        private SelectionButtonDialogField fAlwaysUseThisFileButton = new SelectionButtonDialogField(32);

        public SourceSelectionDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)1);
            super.createDialogArea(composite2);
            Composite composite3 = ControlFactory.createComposite((Composite)composite2, (int)1);
            this.fAlwaysUseThisFileButton.setLabelText(SourceLookupMessages.getString("DefaultSourceLocator.0"));
            this.fAlwaysUseThisFileButton.doFillIntoGrid(composite3, 1);
            return composite2;
        }

        public boolean alwaysMapToSelection() {
            return this.fAlwaysUseThisFileButton.isSelected();
        }
    }

    public class SourceElementLabelProvider
    extends LabelProvider {
        protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();

        public String getText(Object object) {
            if (object instanceof IFile) {
                return ((IFile)object).getFullPath().toString();
            }
            if (object instanceof FileStorage) {
                return ((FileStorage)object).getFullPath().toOSString();
            }
            return super.getText(object);
        }

        public Image getImage(Object object) {
            if (object instanceof IFile) {
                return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_WORKSPACE_SOURCE_FILE);
            }
            if (object instanceof FileStorage) {
                return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_EXTERNAL_SOURCE_FILE);
            }
            return super.getImage(object);
        }
    }
}

