/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;

public class CLIProcessor {
    MISession session;

    public CLIProcessor(MISession mISession) {
        this.session = mISession;
    }

    void process(CLICommand cLICommand) {
        String string = cLICommand.getOperation().trim();
        int n = string.indexOf(32);
        string = n != -1 ? string.substring(0, n).trim() : string.trim();
        int n2 = this.getSteppingOperationKind(string);
        if (n2 != -1) {
            this.session.getMIInferior().setRunning();
            MIRunningEvent mIRunningEvent = new MIRunningEvent(cLICommand.getToken(), n2);
            this.session.fireEvent(mIRunningEvent);
        } else if (this.isSettingBreakpoint(string) || this.isSettingWatchpoint(string) || this.isChangeBreakpoint(string) || this.isDeletingBreakpoint(string)) {
            this.session.fireEvent(new MIBreakpointChangedEvent(0));
        } else if (this.isSettingSignal(string)) {
            this.session.fireEvent(new MISignalChangedEvent(""));
        } else if (this.isDetach(string)) {
            this.session.getMIInferior().setDisconnected();
            MIDetachedEvent mIDetachedEvent = new MIDetachedEvent(cLICommand.getToken());
            this.session.fireEvent(mIDetachedEvent);
        }
    }

    int getSteppingOperationKind(String string) {
        int n = -1;
        if (string.equals("n") || string.equals("next")) {
            n = 1;
        } else if (string.equals("ni") || string.equals("nexti")) {
            n = 2;
        } else if (string.equals("s") || string.equals("step")) {
            n = 3;
        } else if (string.equals("si") || string.equals("stepi")) {
            n = 4;
        } else if (string.equals("u") || string.startsWith("unt") && "until".indexOf(string) != -1) {
            n = 6;
        } else if (string.startsWith("fin") && "finish".indexOf(string) != -1) {
            n = 5;
        } else if (string.equals("c") || string.equals("fg") || string.startsWith("cont") && "continue".indexOf(string) != -1) {
            n = 0;
        } else if (string.startsWith("sig") && "signal".indexOf(string) != -1) {
            n = 0;
        } else if (string.startsWith("j") && "jump".indexOf(string) != -1) {
            n = 0;
        } else if (string.equals("r") || string.equals("run")) {
            n = 0;
        }
        return n;
    }

    boolean isSettingBreakpoint(String string) {
        boolean bl = false;
        if (string.startsWith("b") && "break".indexOf(string) != -1 || string.startsWith("tb") && "tbreak".indexOf(string) != -1 || string.startsWith("hb") && "hbreak".indexOf(string) != -1 || string.startsWith("thb") && "thbreak".indexOf(string) != -1 || string.startsWith("rb") && "rbreak".indexOf(string) != -1) {
            bl = true;
        }
        return bl;
    }

    boolean isSettingWatchpoint(String string) {
        boolean bl = false;
        if (string.startsWith("wa") && "watch".indexOf(string) != -1 || string.startsWith("rw") && "rwatch".indexOf(string) != -1 || string.startsWith("aw") && "awatch".indexOf(string) != -1) {
            bl = true;
        }
        return bl;
    }

    boolean isDeletingBreakpoint(String string) {
        boolean bl = false;
        if (string.startsWith("cl") && "clear".indexOf(string) != -1 || string.equals("d") || string.startsWith("del") && "delete".indexOf(string) != -1) {
            bl = true;
        }
        return bl;
    }

    boolean isChangeBreakpoint(String string) {
        boolean bl = false;
        if (string.equals("dis") || string.equals("disa") || string.startsWith("disa") && "disable".indexOf(string) != -1 || string.equals("en") || string.startsWith("en") && "enable".indexOf(string) != -1 || string.startsWith("ig") && "ignore".indexOf(string) != -1 || string.startsWith("cond") && "condition".indexOf(string) != -1) {
            bl = true;
        }
        return bl;
    }

    boolean isSettingSignal(String string) {
        boolean bl = false;
        if (string.startsWith("ha") && "handle".indexOf(string) != -1) {
            bl = true;
        }
        return bl;
    }

    boolean isDetach(String string) {
        return string.startsWith("det") && "detach".indexOf(string) != -1;
    }
}

