/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.util.Collections;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.GDBDebugger;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.CygwinCommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CygwinGDBDebugger
extends GDBDebugger {
    static final CygwinCommandFactory commandFactory = new CygwinCommandFactory();

    protected void initializeLibraries(ILaunchConfiguration iLaunchConfiguration, Session session) throws CDIException {
        try {
            Object object;
            ICDISharedLibraryManager iCDISharedLibraryManager = session.getSharedLibraryManager();
            if (iCDISharedLibraryManager instanceof SharedLibraryManager) {
                object = (SharedLibraryManager)iCDISharedLibraryManager;
                boolean bl = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
                try {
                    ((SharedLibraryManager)object).setStopOnSolibEvents(bl);
                    if (!bl) {
                        ((SharedLibraryManager)object).setStopOnSolibEvents(true);
                        ((SharedLibraryManager)object).setDeferredBreakpoint(true);
                    }
                }
                catch (CDIException cDIException) {}
            }
            if ((object = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST)).size() > 0) {
                String[] stringArray = iCDISharedLibraryManager.getSharedLibraryPaths();
                String[] stringArray2 = new String[stringArray.length + object.size()];
                System.arraycopy(object.toArray(new String[object.size()]), 0, stringArray2, 0, object.size());
                System.arraycopy(stringArray, 0, stringArray2, object.size(), stringArray.length);
                iCDISharedLibraryManager.setSharedLibraryPaths(stringArray2);
            }
        }
        catch (CoreException coreException) {
            throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.CygwinGDBDebugger.Error_init_shared_lib_options")) + coreException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createLaunchSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile) throws CDIException {
        Session session2;
        Session session = null;
        boolean bl = false;
        try {
            try {
                session = (Session)super.createLaunchSession(iLaunchConfiguration, iFile);
                session.getMISession().setCommandFactory(commandFactory);
                MISession mISession = session.getMISession();
                try {
                    CommandFactory commandFactory = mISession.getCommandFactory();
                    MIGDBSet mIGDBSet = commandFactory.createMIGDBSet(new String[]{"new-console"});
                    mISession.postCommand(mIGDBSet);
                    MIInfo mIInfo = mIGDBSet.getMIInfo();
                    if (mIInfo == null) {
                        throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                    }
                }
                catch (MIException mIException) {}
                session2 = session;
                Object var9_11 = null;
                if (!bl) return session2;
                if (session == null) return session2;
            }
            catch (CDIException cDIException) {
                bl = true;
                throw cDIException;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!bl) throw throwable;
            if (session == null) throw throwable;
            try {
                session.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session.terminate();
        return session2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createAttachSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile, int n) throws CDIException {
        Session session2;
        Session session = null;
        boolean bl = false;
        try {
            try {
                session = (Session)super.createAttachSession(iLaunchConfiguration, iFile, n);
                session.getMISession().setCommandFactory(commandFactory);
                this.initializeLibraries(iLaunchConfiguration, session);
                session2 = session;
                Object var7_7 = null;
                if (!bl) return session2;
                if (session == null) return session2;
            }
            catch (CDIException cDIException) {
                bl = true;
                throw cDIException;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!bl) throw throwable;
            if (session == null) throw throwable;
            try {
                session.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session.terminate();
        return session2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createCoreSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile, IPath iPath) throws CDIException {
        Session session2;
        Session session = null;
        boolean bl = false;
        try {
            try {
                session = (Session)super.createCoreSession(iLaunchConfiguration, iFile, iPath);
                session.getMISession().setCommandFactory(commandFactory);
                this.initializeLibraries(iLaunchConfiguration, session);
                session2 = session;
                Object var7_7 = null;
                if (!bl) return session2;
                if (session == null) return session2;
            }
            catch (CDIException cDIException) {
                bl = true;
                throw cDIException;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!bl) throw throwable;
            if (session == null) throw throwable;
            try {
                session.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session.terminate();
        return session2;
    }
}

