/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBDebugger
implements ICDebugger {
    protected void initializeLibraries(ILaunchConfiguration iLaunchConfiguration, Session session) throws CDIException {
        try {
            Object object;
            ICDISharedLibraryManager iCDISharedLibraryManager = session.getSharedLibraryManager();
            if (iCDISharedLibraryManager instanceof SharedLibraryManager) {
                object = (SharedLibraryManager)iCDISharedLibraryManager;
                boolean bl = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
                boolean bl2 = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
                try {
                    ((SharedLibraryManager)object).setAutoLoadSymbols(bl);
                    ((SharedLibraryManager)object).setStopOnSolibEvents(bl2);
                    if (bl && !bl2) {
                        ((SharedLibraryManager)object).setDeferredBreakpoint(true);
                        ((SharedLibraryManager)object).setStopOnSolibEvents(true);
                    }
                }
                catch (CDIException cDIException) {}
            }
            if ((object = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST)).size() > 0) {
                String[] stringArray = iCDISharedLibraryManager.getSharedLibraryPaths();
                String[] stringArray2 = new String[stringArray.length + object.size()];
                System.arraycopy(object.toArray(new String[object.size()]), 0, stringArray2, 0, object.size());
                System.arraycopy(stringArray, 0, stringArray2, object.size(), stringArray.length);
                iCDISharedLibraryManager.setSharedLibraryPaths(stringArray2);
            }
        }
        catch (CoreException coreException) {
            throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_initializing_shared_lib_options")) + coreException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createLaunchSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile) throws CDIException {
        Session session;
        Session session2 = null;
        boolean bl = false;
        try {
            try {
                String string = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
                File file = iFile.getProject().getLocation().toFile();
                String string2 = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
                session2 = (Session)MIPlugin.getDefault().createCSession(string, iFile.getLocation().toFile(), file, string2);
                this.initializeLibraries(iLaunchConfiguration, session2);
                session = session2;
                Object var8_12 = null;
                if (!bl) return session;
                if (session2 == null) return session;
            }
            catch (IOException iOException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + iOException.getMessage());
            }
            catch (MIException mIException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + mIException.getMessage());
            }
            catch (CoreException coreException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + coreException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!bl) throw throwable;
            if (session2 == null) throw throwable;
            try {
                session2.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session2.terminate();
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createAttachSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile, int n) throws CDIException {
        Session session;
        Session session2 = null;
        boolean bl = false;
        try {
            try {
                String string = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
                File file = iFile.getProject().getLocation().toFile();
                String string2 = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
                session2 = (Session)MIPlugin.getDefault().createCSession(string, iFile.getLocation().toFile(), n, null, file, string2);
                this.initializeLibraries(iLaunchConfiguration, session2);
                session = session2;
                Object var9_13 = null;
                if (!bl) return session;
                if (session2 == null) return session;
            }
            catch (IOException iOException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + iOException.getMessage());
            }
            catch (MIException mIException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + mIException.getMessage());
            }
            catch (CoreException coreException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + coreException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (!bl) throw throwable;
            if (session2 == null) throw throwable;
            try {
                session2.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session2.terminate();
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createCoreSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile, IPath iPath) throws CDIException {
        Session session;
        Session session2 = null;
        boolean bl = false;
        try {
            try {
                String string = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
                File file = iFile.getProject().getLocation().toFile();
                String string2 = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
                session2 = (Session)MIPlugin.getDefault().createCSession(string, iFile.getLocation().toFile(), iPath.toFile(), file, string2);
                this.initializeLibraries(iLaunchConfiguration, session2);
                session = session2;
                Object var9_13 = null;
                if (!bl) return session;
                if (session2 == null) return session;
            }
            catch (IOException iOException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + iOException.getMessage());
            }
            catch (MIException mIException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + mIException.getMessage());
            }
            catch (CoreException coreException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + coreException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (!bl) throw throwable;
            if (session2 == null) throw throwable;
            try {
                session2.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session2.terminate();
        return session;
    }
}

