/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBServerDebugger
implements ICDebugger {
    void initializeLibraries(ILaunchConfiguration iLaunchConfiguration, Session session) throws CDIException {
        try {
            List list;
            ICDISharedLibraryManager iCDISharedLibraryManager = session.getSharedLibraryManager();
            if (iCDISharedLibraryManager instanceof SharedLibraryManager) {
                boolean bl = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
                try {
                    ((SharedLibraryManager)iCDISharedLibraryManager).setAutoLoadSymbols(bl);
                }
                catch (CDIException cDIException) {}
            }
            if ((list = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, new ArrayList(1))).size() > 0) {
                String[] stringArray = list.toArray(new String[0]);
                iCDISharedLibraryManager.setSharedLibraryPaths(stringArray);
            }
        }
        catch (CoreException coreException) {
            throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBServerDebugger.Error_initializing")) + coreException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createLaunchSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile) throws CDIException {
        Session session;
        Session session2 = null;
        boolean bl = false;
        try {
            try {
                String string = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
                File file = iFile.getProject().getLocation().toFile();
                String string2 = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
                if (iLaunchConfiguration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false)) {
                    String string3 = iLaunchConfiguration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "invalid");
                    string3 = String.valueOf(string3) + ":";
                    string3 = String.valueOf(string3) + iLaunchConfiguration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, "invalid");
                    String[] stringArray = new String[]{"remote", string3};
                    session2 = (Session)MIPlugin.getDefault().createCSession(string, iFile.getLocation().toFile(), 0, stringArray, file, string2);
                } else {
                    MIPlugin mIPlugin = MIPlugin.getDefault();
                    Preferences preferences = mIPlugin.getPluginPreferences();
                    int n = preferences.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
                    String string4 = iLaunchConfiguration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, "invalid");
                    String string5 = iLaunchConfiguration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, "invalid");
                    session2 = (Session)MIPlugin.getDefault().createCSession(string, iFile.getLocation().toFile(), -1, null, file, string2);
                    MISession mISession = session2.getMISession();
                    CommandFactory commandFactory = mISession.getCommandFactory();
                    MIGDBSet mIGDBSet = commandFactory.createMIGDBSet(new String[]{"remotebaud", string5});
                    mISession.postCommand(mIGDBSet, n);
                    MIInfo mIInfo = mIGDBSet.getMIInfo();
                    if (mIInfo == null) {
                        throw new MIException(MIPlugin.getResourceString("src.GDBServerDebugger.Can_not_set_Baud"));
                    }
                    MITargetSelect mITargetSelect = commandFactory.createMITargetSelect(new String[]{"remote", string4});
                    mISession.postCommand(mITargetSelect, n);
                    mITargetSelect.getMIInfo();
                    if (mIInfo == null) {
                        throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                    }
                }
                this.initializeLibraries(iLaunchConfiguration, session2);
                session = session2;
                Object var18_24 = null;
                if (!bl) return session;
                if (session2 == null) return session;
            }
            catch (IOException iOException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBServerDebugger.Error_initializing")) + iOException.getMessage());
            }
            catch (MIException mIException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBServerDebugger.Error_initializing")) + mIException.getMessage());
            }
            catch (CoreException coreException) {
                bl = true;
                throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBServerDebugger.Error_initializing")) + coreException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var18_25 = null;
            if (!bl) throw throwable;
            if (session2 == null) throw throwable;
            try {
                session2.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session2.terminate();
        return session;
    }

    public ICDISession createAttachSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile, int n) throws CDIException {
        throw new CDIException(MIPlugin.getResourceString("src.GDBServerDebugger.GDBServer_attaching_unsupported"));
    }

    public ICDISession createCoreSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile, IPath iPath) throws CDIException {
        throw new CDIException(MIPlugin.getResourceString("src.GDBServerDebugger.GDBServer_corefiles_unsupported"));
    }
}

