/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecAbort;
import org.eclipse.cdt.debug.mi.core.command.MIExecInterrupt;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowExitCode;
import org.eclipse.cdt.debug.mi.core.command.MIInfoProgram;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowExitCodeInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoProgramInfo;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.Spawner;

public class MIInferior
extends Process {
    static final int SUSPENDED = 1;
    static final int RUNNING = 2;
    static final int TERMINATED = 4;
    boolean connected = false;
    int exitCode = 0;
    int state = 0;
    MISession session;
    OutputStream out;
    InputStream in;
    PipedOutputStream inPiped;
    PipedInputStream err;
    PipedOutputStream errPiped;
    PTY pty;
    int inferiorPID;

    MIInferior(MISession mISession, PTY pTY) {
        this.session = mISession;
        this.pty = pTY;
        if (this.pty != null) {
            this.out = this.pty.getOutputStream();
            this.in = this.pty.getInputStream();
        }
    }

    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new OutputStream(){
                StringBuffer buf = new StringBuffer();

                public void write(int n) throws IOException {
                    if (!MIInferior.this.isRunning()) {
                        throw new IOException(MIPlugin.getResourceString("src.MIInferior.target_is_suspended"));
                    }
                    OutputStream outputStream = MIInferior.this.session.getChannelOutputStream();
                    if (outputStream == null) {
                        throw new IOException(MIPlugin.getResourceString("src.MIInferior.No_session"));
                    }
                    outputStream.write(n);
                }
            };
        }
        return this.out;
    }

    public InputStream getInputStream() {
        if (this.in == null) {
            try {
                this.inPiped = new PipedOutputStream();
                this.in = new PipedInputStream(this.inPiped);
            }
            catch (IOException iOException) {}
        }
        return this.in;
    }

    public InputStream getErrorStream() {
        if (this.err == null) {
            try {
                this.errPiped = new PipedOutputStream();
                this.err = new PipedInputStream(this.errPiped);
            }
            catch (IOException iOException) {}
        }
        return this.err;
    }

    public synchronized void waitForSync() throws InterruptedException {
        while (this.state != 4) {
            this.wait();
        }
    }

    public int waitFor() throws InterruptedException {
        this.waitForSync();
        return this.exitValue();
    }

    public int exitValue() {
        if (this.isTerminated()) {
            if (!this.session.isTerminated()) {
                CommandFactory commandFactory = this.session.getCommandFactory();
                MIGDBShowExitCode mIGDBShowExitCode = commandFactory.createMIGDBShowExitCode();
                try {
                    this.session.postCommand(mIGDBShowExitCode);
                    MIGDBShowExitCodeInfo mIGDBShowExitCodeInfo = mIGDBShowExitCode.getMIGDBShowExitCodeInfo();
                    this.exitCode = mIGDBShowExitCodeInfo.getCode();
                }
                catch (MIException mIException) {}
            }
            return this.exitCode;
        }
        throw new IllegalThreadStateException();
    }

    public void destroy() {
        try {
            this.terminate();
        }
        catch (MIException mIException) {}
    }

    public void terminate() throws MIException {
        if (this.session.isAttachSession() && this.isConnected() || this.session.isProgramSession() && !this.isTerminated()) {
            CommandFactory commandFactory = this.session.getCommandFactory();
            MIExecAbort mIExecAbort = commandFactory.createMIExecAbort();
            this.interrupt();
            this.session.postCommand(mIExecAbort);
            mIExecAbort.getMIInfo();
            this.setTerminated(mIExecAbort.getToken(), true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void interrupt() throws MIException {
        Process process = this.session.getGDBProcess();
        CommandFactory commandFactory = this.session.getCommandFactory();
        MIExecInterrupt mIExecInterrupt = commandFactory.createMIExecInterrupt();
        if (mIExecInterrupt != null) {
            try {
                this.session.postCommand(mIExecInterrupt);
                mIExecInterrupt.getMIInfo();
                int n = 0;
                while (this.state == 2 && n < 5) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n;
                }
            }
            catch (MIException mIException) {}
        } else if (process instanceof Spawner) {
            Spawner spawner = (Spawner)process;
            spawner.interrupt();
            int n = 0;
            while (this.state == 2 && n < 5) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
                ++n;
            }
            if (this.state == 2 && this.getInferiorPID() > 0) {
                spawner.raise(this.getInferiorPID(), spawner.INT);
                n = 0;
                while (this.state == 2 && n < 5) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n;
                }
            }
        }
        if (this.state == 2) {
            throw new MIException(MIPlugin.getResourceString("src.MIInferior.Failed_to_interrupt"));
        }
    }

    public boolean isSuspended() {
        return this.state == 1;
    }

    public boolean isRunning() {
        return this.state == 2;
    }

    public boolean isTerminated() {
        return this.state == 4;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void setConnected() {
        this.connected = true;
    }

    public synchronized void setDisconnected() {
        this.connected = false;
    }

    public synchronized void setSuspended() {
        this.state = 1;
        this.notifyAll();
    }

    public synchronized void setRunning() {
        this.state = 2;
        this.notifyAll();
    }

    public synchronized void setTerminated() {
        this.setTerminated(0, false);
    }

    synchronized void setTerminated(int n, boolean bl) {
        this.state = 4;
        try {
            if (this.inPiped != null) {
                this.inPiped.close();
                this.inPiped = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.errPiped != null) {
                this.errPiped.close();
                this.errPiped = null;
            }
        }
        catch (IOException iOException) {}
        if (this.pty != null) {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
                this.in = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                this.out = null;
            }
        }
        if (bl) {
            this.session.fireEvent(new MIInferiorExitEvent(n));
        }
        this.notifyAll();
    }

    public OutputStream getPipedOutputStream() {
        return this.inPiped;
    }

    public OutputStream getPipedErrorStream() {
        return this.errPiped;
    }

    public PTY getPTY() {
        return this.pty;
    }

    public void update() {
        if (this.getInferiorPID() == 0) {
            int n = 0;
            if (!this.isConnected()) {
                CommandFactory commandFactory = this.session.getCommandFactory();
                MIInfoProgram mIInfoProgram = commandFactory.createMIInfoProgram();
                try {
                    this.session.postCommand(mIInfoProgram);
                    MIInfoProgramInfo mIInfoProgramInfo = mIInfoProgram.getMIInfoProgramInfo();
                    n = mIInfoProgramInfo.getPID();
                }
                catch (MIException mIException) {}
            }
            this.setInferiorPID(n == 0 ? -1 : n);
        }
    }

    public void setInferiorPID(int n) {
        this.inferiorPID = n;
    }

    public int getInferiorPID() {
        return this.inferiorPID;
    }
}

