/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.osgi.framework.BundleContext;

public class MIPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.mi.core";
    private static MIPlugin plugin;
    private static final String GDBINIT = ".gdbinit";
    private static final String GDB = "gdb";
    private static ResourceBundle fgResourceBundle;

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.debug.mi.core.MIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public MIPlugin() {
        plugin = this;
    }

    public static MIPlugin getDefault() {
        return plugin;
    }

    public MISession createMISession(Process process, PTY pTY, int n, int n2, int n3) throws MIException {
        return new MISession(process, pTY, n, n2, n3);
    }

    public MISession createMISession(Process process, PTY pTY, int n) throws MIException {
        MIPlugin mIPlugin = MIPlugin.getDefault();
        Preferences preferences = mIPlugin.getPluginPreferences();
        int n2 = preferences.getInt(IMIConstants.PREF_REQUEST_TIMEOUT);
        int n3 = preferences.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
        return this.createMISession(process, pTY, n2, n, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createCSession(String string, File file, File file2, String string2) throws IOException, MIException {
        InputStream inputStream;
        ICDISession iCDISession;
        PTY pTY = null;
        boolean bl = false;
        try {
            pTY = new PTY();
        }
        catch (IOException iOException) {}
        try {
            try {
                iCDISession = this.createCSession(string, file, file2, string2, pTY);
                Object var8_8 = null;
                if (!bl) return iCDISession;
                if (pTY == null) return iCDISession;
            }
            catch (IOException iOException) {
                bl = true;
                throw iOException;
            }
            catch (MIException mIException) {
                bl = true;
                throw mIException;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!bl) throw throwable;
            if (pTY == null) throw throwable;
            try {
                InputStream inputStream2;
                OutputStream outputStream = pTY.getOutputStream();
                if (outputStream != null) {
                    outputStream.close();
                }
                if ((inputStream2 = pTY.getInputStream()) == null) throw throwable;
                inputStream2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        OutputStream outputStream = pTY.getOutputStream();
        if (outputStream != null) {
            outputStream.close();
        }
        if ((inputStream = pTY.getInputStream()) == null) return iCDISession;
        inputStream.close();
        return iCDISession;
    }

    public ICDISession createCSession(String string, File file, File file2, String string2, PTY pTY) throws IOException, MIException {
        MISession mISession;
        if (string == null || string.length() == 0) {
            string = GDB;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = GDBINIT;
        }
        String[] stringArray = pTY != null ? (file == null ? new String[]{string, "--cd=" + file2.getAbsolutePath(), "--command=" + string2, "-q", "-nw", "-tty", pTY.getSlaveName(), "-i", "mi1"} : new String[]{string, "--cd=" + file2.getAbsolutePath(), "--command=" + string2, "-q", "-nw", "-tty", pTY.getSlaveName(), "-i", "mi1", file.getAbsolutePath()}) : (file == null ? new String[]{string, "--cd=" + file2.getAbsolutePath(), "--command=" + string2, "-q", "-nw", "-i", "mi1"} : new String[]{string, "--cd=" + file2.getAbsolutePath(), "--command=" + string2, "-q", "-nw", "-i", "mi1", file.getAbsolutePath()});
        Process process = this.getGDBProcess(stringArray);
        try {
            mISession = this.createMISession(process, pTY, 0);
        }
        catch (MIException mIException) {
            process.destroy();
            throw mIException;
        }
        try {
            CLICommand cLICommand = new CLICommand("info remote-process");
            mISession.postCommand(cLICommand);
            MIInfo mIInfo = cLICommand.getMIInfo();
            if (mIInfo == null) {
                process.destroy();
                throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
            }
            mISession.getMIInferior().setSuspended();
            mISession.getMIInferior().update();
        }
        catch (MIException mIException) {}
        return new Session(mISession, false);
    }

    public ICDISession createCSession(String string, File file, File file2, File file3, String string2) throws IOException, MIException {
        MISession mISession;
        if (string == null || string.length() == 0) {
            string = GDB;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = GDBINIT;
        }
        String[] stringArray = file == null ? new String[]{string, "--cd=" + file3.getAbsolutePath(), "--command=" + string2, "--quiet", "-nw", "-i", "mi1", "-c", file2.getAbsolutePath()} : new String[]{string, "--cd=" + file3.getAbsolutePath(), "--command=" + string2, "--quiet", "-nw", "-i", "mi1", "-c", file2.getAbsolutePath(), file.getAbsolutePath()};
        Process process = this.getGDBProcess(stringArray);
        try {
            mISession = this.createMISession(process, null, 2);
        }
        catch (MIException mIException) {
            process.destroy();
            throw mIException;
        }
        return new Session(mISession);
    }

    public ICDISession createCSession(String string, File file, int n, String[] stringArray, File file2, String string2) throws IOException, MIException {
        MISession mISession;
        if (string == null || string.length() == 0) {
            string = GDB;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = GDBINIT;
        }
        String[] stringArray2 = file == null ? new String[]{string, "--cd=" + file2.getAbsolutePath(), "--command=" + string2, "--quiet", "-nw", "-i", "mi1"} : new String[]{string, "--cd=" + file2.getAbsolutePath(), "--command=" + string2, "--quiet", "-nw", "-i", "mi1", file.getAbsolutePath()};
        Process process = this.getGDBProcess(stringArray2);
        try {
            mISession = this.createMISession(process, null, 1);
        }
        catch (MIException mIException) {
            process.destroy();
            throw mIException;
        }
        CommandFactory commandFactory = mISession.getCommandFactory();
        try {
            MIInfo mIInfo;
            Command command;
            if (stringArray != null && stringArray.length > 0) {
                command = commandFactory.createMITargetSelect(stringArray);
                mISession.postCommand(command);
                mIInfo = command.getMIInfo();
                if (mIInfo == null) {
                    throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                }
            }
            if (n > 0) {
                command = commandFactory.createMITargetAttach(n);
                mISession.postCommand(command);
                mIInfo = command.getMIInfo();
                if (mIInfo == null) {
                    throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                }
                mISession.getMIInferior().setInferiorPID(n);
            }
        }
        catch (MIException mIException) {
            process.destroy();
            throw mIException;
        }
        mISession.getMIInferior().setSuspended();
        mISession.getMIInferior().update();
        return new Session(mISession, true);
    }

    public static String getUniqueIdentifier() {
        if (MIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return MIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public void debugLog(String string) {
        if (MIPlugin.getDefault().isDebugging()) {
            string = MessageFormat.format("[{0}] {1}", new Long(System.currentTimeMillis()), string);
            while (string.length() > 100) {
                String string2 = string.substring(0, 100);
                string = string.substring(100);
                System.err.println(String.valueOf(string2) + "\\");
            }
            if (string.endsWith("\n")) {
                System.err.print(string);
            } else {
                System.err.println(string);
            }
        }
    }

    public static String getResourceString(String string) {
        try {
            return fgResourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + string + '!';
        }
        catch (NullPointerException nullPointerException) {
            return String.valueOf('#') + string + '#';
        }
    }

    protected Process getGDBProcess(String[] stringArray) throws IOException {
        Object object;
        if (MIPlugin.getDefault().isDebugging()) {
            object = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                ((StringBuffer)object).append(stringArray[n]);
                ((StringBuffer)object).append(' ');
                ++n;
            }
            MIPlugin.getDefault().debugLog(((StringBuffer)object).toString());
        }
        object = ProcessFactory.getFactory().exec(stringArray);
        Thread thread = new Thread("GDB Start", (Process)object){
            private final /* synthetic */ Process val$pgdb;
            {
                this.val$pgdb = process;
            }

            public void run() {
                Object object;
                try {
                    InputStream inputStream = this.val$pgdb.getInputStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    while ((object = bufferedReader.readLine()) != null) {
                        if (!((String)(object = ((String)object).trim())).endsWith("(gdb)")) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {}
                object = this.val$pgdb;
                synchronized (object) {
                    this.val$pgdb.notifyAll();
                }
            }
        };
        thread.start();
        Object object2 = object;
        synchronized (object2) {
            MIPlugin mIPlugin = MIPlugin.getDefault();
            Preferences preferences = mIPlugin.getPluginPreferences();
            int n = preferences.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
            while (thread.isAlive()) {
                try {
                    object.wait(n);
                    break;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            thread.interrupt();
            thread.join(1000L);
        }
        catch (InterruptedException interruptedException) {}
        return object;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
    }

    protected void initializeDefaultPluginPreferences() {
        this.getPluginPreferences().setDefault(IMIConstants.PREF_REQUEST_TIMEOUT, 10000);
        this.getPluginPreferences().setDefault(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT, 30000);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.savePluginPreferences();
        super.stop(bundleContext);
    }
}

