/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Observable;
import org.eclipse.cdt.debug.mi.core.CommandQueue;
import org.eclipse.cdt.debug.mi.core.EventThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.Queue;
import org.eclipse.cdt.debug.mi.core.RxThread;
import org.eclipse.cdt.debug.mi.core.SessionProcess;
import org.eclipse.cdt.debug.mi.core.TxThread;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecInterrupt;
import org.eclipse.cdt.debug.mi.core.command.MIGDBExit;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIGDBExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIParser;
import org.eclipse.cdt.utils.pty.PTY;

public class MISession
extends Observable {
    public static final int PROGRAM = 0;
    public static final int ATTACH = 1;
    public static final int CORE = 2;
    boolean terminated;
    int sessionType;
    Process sessionProcess;
    Process gdbProcess;
    InputStream inChannel;
    OutputStream outChannel;
    TxThread txThread;
    RxThread rxThread;
    EventThread eventThread;
    CommandQueue txQueue;
    CommandQueue rxQueue;
    Queue eventQueue;
    PipedInputStream miInConsolePipe;
    PipedOutputStream miOutConsolePipe;
    PipedInputStream miInLogPipe;
    PipedOutputStream miOutLogPipe;
    CommandFactory factory;
    MIParser parser;
    long cmdTimeout;
    MIInferior inferior;

    public MISession(Process process, PTY pTY, int n, int n2, int n3) throws MIException {
        this.gdbProcess = process;
        this.inChannel = process.getInputStream();
        this.outChannel = process.getOutputStream();
        this.cmdTimeout = n;
        this.sessionType = n2;
        this.factory = new CommandFactory();
        this.parser = new MIParser();
        this.inferior = new MIInferior(this, pTY);
        this.txQueue = new CommandQueue();
        this.rxQueue = new CommandQueue();
        this.eventQueue = new Queue();
        try {
            process.exitValue();
            InputStream inputStream = process.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            try {
                string = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (Exception exception) {}
            if (string == null) {
                string = MIPlugin.getResourceString("src.MISession.Process_Terminated");
            }
            throw new MIException(string);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.txThread = new TxThread(this);
            this.rxThread = new RxThread(this);
            this.eventThread = new EventThread(this);
            this.txThread.start();
            this.rxThread.start();
            this.eventThread.start();
            try {
                MIGDBSet mIGDBSet = new MIGDBSet(new String[]{"confirm", "off"});
                this.postCommand(mIGDBSet, n3);
                mIGDBSet.getMIInfo();
                MIGDBSet mIGDBSet2 = new MIGDBSet(new String[]{"width", "0"});
                this.postCommand(mIGDBSet2, n3);
                mIGDBSet.getMIInfo();
                MIGDBSet mIGDBSet3 = new MIGDBSet(new String[]{"height", "0"});
                this.postCommand(mIGDBSet3, n3);
                mIGDBSet.getMIInfo();
            }
            catch (MIException mIException) {
                if (this.txThread.isAlive()) {
                    this.txThread.interrupt();
                }
                if (this.rxThread.isAlive()) {
                    this.rxThread.interrupt();
                }
                if (this.eventThread.isAlive()) {
                    this.eventThread.interrupt();
                }
                throw mIException;
            }
            return;
        }
    }

    public InputStream getMIConsoleStream() {
        if (this.miInConsolePipe == null) {
            try {
                this.miOutConsolePipe = new PipedOutputStream();
                this.miInConsolePipe = new PipedInputStream(this.miOutConsolePipe);
            }
            catch (IOException iOException) {}
        }
        return this.miInConsolePipe;
    }

    public InputStream getMILogStream() {
        if (this.miInLogPipe == null) {
            try {
                this.miOutLogPipe = new PipedOutputStream();
                this.miInLogPipe = new PipedInputStream(this.miOutLogPipe);
            }
            catch (IOException iOException) {}
        }
        return this.miInLogPipe;
    }

    public CommandFactory getCommandFactory() {
        return this.factory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.factory = commandFactory;
    }

    public MIParser getMIParser() {
        return this.parser;
    }

    public void setMIParser(MIParser mIParser) {
        this.parser = mIParser;
    }

    public int getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(int n) {
        this.sessionType = n;
    }

    public boolean isProgramSession() {
        return this.sessionType == 0;
    }

    public boolean isAttachSession() {
        return this.sessionType == 1;
    }

    public boolean isCoreSession() {
        return this.sessionType == 2;
    }

    public void setCommandTimeout(long l) {
        this.cmdTimeout = l;
    }

    public long getCommandTimeout() {
        return this.cmdTimeout;
    }

    public void postCommand(Command command) throws MIException {
        this.postCommand(command, this.cmdTimeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void postCommand(Command command, long l) throws MIException {
        if (!this.txThread.isAlive()) throw new MIException(MIPlugin.getResourceString("src.MISession.Thread_Terminated"));
        if (!this.rxThread.isAlive()) {
            throw new MIException(MIPlugin.getResourceString("src.MISession.Thread_Terminated"));
        }
        if (this.inferior.isRunning() && !(command instanceof MIExecInterrupt)) {
            throw new MIException(MIPlugin.getResourceString("src.MISession.Target_not_suspended"));
        }
        if (this.isTerminated()) {
            throw new MIException(MIPlugin.getResourceString("src.MISession.Session_terminated"));
        }
        MIPlugin.getDefault().debugLog(command.toString());
        this.txQueue.addCommand(command);
        Command command2 = command;
        synchronized (command2) {
            while (true) {
                if (command.getMIOutput() != null) {
                    return;
                }
                try {
                    command.wait(l);
                    if (command.getMIOutput() != null) continue;
                    throw new MIException(MIPlugin.getResourceString("src.MISession.Target_not_responding"));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public MIInferior getMIInferior() {
        return this.inferior;
    }

    public Process getGDBProcess() {
        return this.gdbProcess;
    }

    public Process getSessionProcess() {
        if (this.sessionProcess == null) {
            this.sessionProcess = new SessionProcess(this);
        }
        return this.sessionProcess;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() {
        if (this.isTerminated()) {
            return;
        }
        this.terminated = true;
        this.inferior.destroy();
        InputStream inputStream = this.inChannel;
        this.inChannel = null;
        OutputStream outputStream = this.outChannel;
        this.outChannel = null;
        MIGDBExit mIGDBExit = this.factory.createMIGDBExit();
        this.txQueue.addCommand(mIGDBExit);
        Object object = mIGDBExit;
        synchronized (object) {
            try {
                mIGDBExit.wait(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.gdbProcess != null) {
            this.gdbProcess.destroy();
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            this.miInConsolePipe = null;
            if (this.miOutConsolePipe != null) {
                this.miOutConsolePipe.close();
            }
        }
        catch (IOException iOException) {}
        try {
            this.miInLogPipe = null;
            if (this.miOutLogPipe != null) {
                this.miOutLogPipe.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.txThread.isAlive()) {
                this.txThread.interrupt();
                this.txThread.join(this.cmdTimeout);
            }
        }
        catch (InterruptedException interruptedException) {}
        try {
            if (this.rxThread.isAlive()) {
                this.rxThread.interrupt();
                this.rxThread.join(this.cmdTimeout);
            }
        }
        catch (InterruptedException interruptedException) {}
        object = this.getEventQueue();
        int n = 0;
        while (!((Queue)object).isEmpty() && n < 5) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            ++n;
        }
        try {
            if (this.eventThread.isAlive()) {
                this.eventThread.interrupt();
                this.eventThread.join(this.cmdTimeout);
            }
        }
        catch (InterruptedException interruptedException) {}
        this.notifyObservers(new MIGDBExitEvent(0));
    }

    public void notifyObservers(Object object) {
        this.setChanged();
        super.notifyObservers(object);
    }

    OutputStream getConsolePipe() {
        return this.miOutConsolePipe;
    }

    OutputStream getLogPipe() {
        return this.miOutLogPipe;
    }

    CommandQueue getTxQueue() {
        return this.txQueue;
    }

    CommandQueue getRxQueue() {
        return this.rxQueue;
    }

    Queue getEventQueue() {
        return this.eventQueue;
    }

    RxThread getRxThread() {
        return this.rxThread;
    }

    InputStream getChannelInputStream() {
        return this.inChannel;
    }

    OutputStream getChannelOutputStream() {
        return this.outChannel;
    }

    MIOutput parse(String string) {
        return this.parser.parse(string);
    }

    public void fireEvents(MIEvent[] mIEventArray) {
        if (mIEventArray != null && mIEventArray.length > 0) {
            int n = 0;
            while (n < mIEventArray.length) {
                this.fireEvent(mIEventArray[n]);
                ++n;
            }
        }
    }

    public void fireEvent(MIEvent mIEvent) {
        if (mIEvent != null) {
            this.getEventQueue().addItem(mIEvent);
        }
    }
}

