/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.event.DestroyedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.model.Expression;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class ExpressionManager
extends Manager
implements ICDIExpressionManager {
    private List expList;
    MIVarChange[] noChanges = new MIVarChange[0];

    public ExpressionManager(Session session) {
        super(session, true);
        this.expList = Collections.synchronizedList(new ArrayList());
        session.getEventManager().addEventListener((ICDIEventListener)this);
    }

    public void handleDebugEvents(ICDIEvent[] iCDIEventArray) {
        int n = 0;
        while (n < iCDIEventArray.length) {
            ICDIObject iCDIObject;
            ICDIEvent iCDIEvent = iCDIEventArray[n];
            if (iCDIEvent instanceof DestroyedEvent && (iCDIObject = iCDIEvent.getSource()) instanceof ICDISharedLibrary) {
                try {
                    ICDITarget iCDITarget = iCDIObject.getTarget();
                    ICDIExpression[] iCDIExpressionArray = this.getExpressions();
                    int n2 = 0;
                    while (n2 < iCDIExpressionArray.length) {
                        Expression expression = (Expression)iCDIExpressionArray[n2];
                        if (expression.getTarget() == iCDITarget) {
                            this.expList.remove(expression);
                            this.removeMIVar(expression.getMIVar());
                        }
                        ++n2;
                    }
                }
                catch (CDIException cDIException) {}
            }
            ++n;
        }
    }

    void removeMIVar(MIVar mIVar) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIVarDelete mIVarDelete = commandFactory.createMIVarDelete(mIVar.getVarName());
        try {
            mISession.postCommand(mIVarDelete);
            mIVarDelete.getMIInfo();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void removeExpression(String string) throws CDIException {
        Expression[] expressionArray = this.expList.toArray(new Expression[0]);
        int n = 0;
        while (n < expressionArray.length) {
            if (expressionArray[n].getMIVar().getVarName().equals(string)) {
                this.expList.remove(expressionArray[n]);
                this.removeMIVar(expressionArray[n].getMIVar());
            }
            ++n;
        }
    }

    public ICDIExpression createExpression(String string) throws CDIException {
        Expression expression = null;
        try {
            Session session = (Session)this.getSession();
            ICDITarget iCDITarget = session.getCurrentTarget();
            MISession mISession = session.getMISession();
            CommandFactory commandFactory = mISession.getCommandFactory();
            MIVarCreate mIVarCreate = commandFactory.createMIVarCreate(string);
            mISession.postCommand(mIVarCreate);
            MIVarCreateInfo mIVarCreateInfo = mIVarCreate.getMIVarCreateInfo();
            if (mIVarCreateInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            VariableObject variableObject = new VariableObject(iCDITarget, string, null, 0, 0);
            expression = new Expression(variableObject, mIVarCreateInfo.getMIVar());
            this.expList.add(expression);
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        return expression;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIExpression createExpression(ICDIStackFrame iCDIStackFrame, String string) throws CDIException {
        Expression expression = null;
        Session session = (Session)this.getSession();
        ICDITarget iCDITarget = session.getCurrentTarget();
        ICDIThread iCDIThread = iCDITarget.getCurrentThread();
        ICDIStackFrame iCDIStackFrame2 = iCDIThread.getCurrentStackFrame();
        iCDIStackFrame.getThread().setCurrentStackFrame(iCDIStackFrame, false);
        try {
            try {
                MISession mISession = session.getMISession();
                CommandFactory commandFactory = mISession.getCommandFactory();
                MIVarCreate mIVarCreate = commandFactory.createMIVarCreate(string);
                mISession.postCommand(mIVarCreate);
                MIVarCreateInfo mIVarCreateInfo = mIVarCreate.getMIVarCreateInfo();
                if (mIVarCreateInfo == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                ICDITarget iCDITarget2 = iCDIStackFrame.getThread().getTarget();
                VariableObject variableObject = new VariableObject(iCDITarget2, string, iCDIStackFrame, 0, 0);
                expression = new Expression(variableObject, mIVarCreateInfo.getMIVar());
                this.expList.add(expression);
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            iCDIThread.setCurrentStackFrame(iCDIStackFrame2, false);
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        iCDIThread.setCurrentStackFrame(iCDIStackFrame2, false);
        return expression;
    }

    public ICDIExpression[] getExpressions() throws CDIException {
        return this.expList.toArray(new ICDIExpression[0]);
    }

    public void destroyExpression(ICDIExpression iCDIExpression) throws CDIException {
        if (iCDIExpression instanceof Expression) {
            Expression expression = (Expression)iCDIExpression;
            MIVarDeletedEvent mIVarDeletedEvent = new MIVarDeletedEvent(expression.getMIVar().getVarName());
            Session session = (Session)this.getSession();
            MISession mISession = session.getMISession();
            mISession.fireEvent(mIVarDeletedEvent);
        }
    }

    public Variable getExpression(String string) {
        Expression[] expressionArray = this.expList.toArray(new Expression[0]);
        int n = 0;
        while (n < expressionArray.length) {
            if (expressionArray[n].getMIVar().getVarName().equals(string)) {
                return expressionArray[n];
            }
            Variable variable = expressionArray[n].getChild(string);
            if (variable != null) {
                return variable;
            }
            ++n;
        }
        return null;
    }

    public void update() throws CDIException {
        ArrayList<MIEvent> arrayList = new ArrayList<MIEvent>();
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        Expression[] expressionArray = this.expList.toArray(new Expression[0]);
        int n = 0;
        while (n < expressionArray.length) {
            String string = expressionArray[n].getMIVar().getVarName();
            MIVarChange[] mIVarChangeArray = this.noChanges;
            MIVarUpdate mIVarUpdate = commandFactory.createMIVarUpdate(string);
            try {
                mISession.postCommand(mIVarUpdate);
                MIVarUpdateInfo mIVarUpdateInfo = mIVarUpdate.getMIVarUpdateInfo();
                if (mIVarUpdateInfo == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                mIVarChangeArray = mIVarUpdateInfo.getMIVarChanges();
            }
            catch (MIException mIException) {
                arrayList.add(new MIVarDeletedEvent(string));
            }
            int n2 = 0;
            while (n2 < mIVarChangeArray.length) {
                String string2 = mIVarChangeArray[n2].getVarName();
                if (mIVarChangeArray[n2].isInScope()) {
                    arrayList.add(new MIVarChangedEvent(string2));
                }
                ++n2;
            }
            ++n;
        }
        MIEvent[] mIEventArray = arrayList.toArray(new MIEvent[0]);
        mISession.fireEvents(mIEventArray);
    }
}

