/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIMemoryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataReadMemory;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;

public class MemoryManager
extends Manager
implements ICDIMemoryManager {
    List blockList = new ArrayList();

    public MemoryManager(Session session) {
        super(session, true);
    }

    public void update() {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        MemoryBlock[] memoryBlockArray = this.listMemoryBlocks();
        ArrayList arrayList = new ArrayList(memoryBlockArray.length);
        int n = 0;
        while (n < memoryBlockArray.length) {
            if (!memoryBlockArray[n].isFrozen()) {
                try {
                    this.update(memoryBlockArray[n], arrayList);
                }
                catch (CDIException cDIException) {}
            }
            ++n;
        }
        MIEvent[] mIEventArray = arrayList.toArray(new MIEvent[0]);
        mISession.fireEvents(mIEventArray);
    }

    public Long[] update(MemoryBlock memoryBlock, List list) throws CDIException {
        MemoryBlock memoryBlock2 = this.cloneBlock(memoryBlock);
        boolean bl = memoryBlock2.getStartAddress() != memoryBlock.getStartAddress();
        Long[] longArray = this.compareBlocks(memoryBlock, memoryBlock2);
        memoryBlock.setMIDataReadMemoryInfo(memoryBlock2.getMIDataReadMemoryInfo());
        if (longArray.length > 0 || bl) {
            if (list != null) {
                list.add(new MIMemoryChangedEvent(longArray));
            } else {
                Session session = (Session)this.getSession();
                MISession mISession = session.getMISession();
                mISession.fireEvent(new MIMemoryChangedEvent(longArray));
            }
        }
        return longArray;
    }

    public MemoryBlock[] listMemoryBlocks() {
        return this.blockList.toArray(new MemoryBlock[0]);
    }

    Long[] compareBlocks(MemoryBlock memoryBlock, MemoryBlock memoryBlock2) throws CDIException {
        byte[] byArray = memoryBlock.getBytes();
        byte[] byArray2 = memoryBlock2.getBytes();
        ArrayList<Long> arrayList = new ArrayList<Long>(byArray2.length);
        long l = memoryBlock2.getStartAddress() - memoryBlock.getStartAddress();
        if (Math.abs(l) < (long)byArray2.length) {
            int n = 0;
            while (n < byArray2.length) {
                if (n + (int)l < byArray.length && n + (int)l >= 0 && byArray[n + (int)l] != byArray2[n]) {
                    arrayList.add(new Long(memoryBlock2.getStartAddress() + (long)n));
                }
                ++n;
            }
        }
        return arrayList.toArray(new Long[0]);
    }

    MemoryBlock cloneBlock(MemoryBlock memoryBlock) throws CDIException {
        Session session = (Session)this.getSession();
        String string = memoryBlock.getExpression();
        MIDataReadMemoryInfo mIDataReadMemoryInfo = this.createMIDataReadMemoryInfo(string, (int)memoryBlock.getLength());
        return new MemoryBlock(session.getCurrentTarget(), string, mIDataReadMemoryInfo);
    }

    MIDataReadMemoryInfo createMIDataReadMemoryInfo(String string, int n) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIDataReadMemory mIDataReadMemory = commandFactory.createMIDataReadMemory(0L, string, 0, 1, 1, n, null);
        try {
            mISession.postCommand(mIDataReadMemory);
            MIDataReadMemoryInfo mIDataReadMemoryInfo = mIDataReadMemory.getMIDataReadMemoryInfo();
            if (mIDataReadMemoryInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            return mIDataReadMemoryInfo;
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public ICDIMemoryBlock createMemoryBlock(long l, int n) throws CDIException {
        String string = "0x" + Long.toHexString(l);
        return this.createMemoryBlock(string, n);
    }

    public ICDIMemoryBlock createMemoryBlock(String string, int n) throws CDIException {
        Session session = (Session)this.getSession();
        MIDataReadMemoryInfo mIDataReadMemoryInfo = this.createMIDataReadMemoryInfo(string, n);
        MemoryBlock memoryBlock = new MemoryBlock(session.getCurrentTarget(), string, mIDataReadMemoryInfo);
        this.blockList.add(memoryBlock);
        MISession mISession = session.getMISession();
        mISession.fireEvent(new MIMemoryCreatedEvent(memoryBlock.getStartAddress(), memoryBlock.getLength()));
        return memoryBlock;
    }

    public ICDIMemoryBlock[] getMemoryBlocks() throws CDIException {
        return this.listMemoryBlocks();
    }

    public void removeAllBlocks() throws CDIException {
        this.blockList.clear();
    }

    public void removeBlock(ICDIMemoryBlock iCDIMemoryBlock) throws CDIException {
        this.blockList.remove(iCDIMemoryBlock);
    }

    public void removeBlocks(ICDIMemoryBlock[] iCDIMemoryBlockArray) throws CDIException {
        int n = 0;
        while (n < iCDIMemoryBlockArray.length) {
            this.removeBlock(iCDIMemoryBlockArray[n]);
            ++n;
        }
    }
}

