/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarCreatedEvent;

public class CreatedEvent
implements ICDICreatedEvent {
    Session session;
    ICDIObject source;

    public CreatedEvent(Session session, MIBreakpointCreatedEvent mIBreakpointCreatedEvent) {
        this.session = session;
        BreakpointManager breakpointManager = (BreakpointManager)this.session.getBreakpointManager();
        int n = mIBreakpointCreatedEvent.getNumber();
        this.source = breakpointManager.getBreakpoint(n);
        if (this.source == null) {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public CreatedEvent(Session session, MIVarCreatedEvent mIVarCreatedEvent) {
        this.session = session;
        VariableManager variableManager = (VariableManager)this.session.getVariableManager();
        String string = mIVarCreatedEvent.getVarName();
        this.source = variableManager.getVariable(string);
        if (this.source == null) {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public CreatedEvent(Session session, MIRegisterCreatedEvent mIRegisterCreatedEvent) {
        this.session = session;
        RegisterManager registerManager = (RegisterManager)this.session.getRegisterManager();
        int n = mIRegisterCreatedEvent.getNumber();
        this.source = registerManager.getRegister(n);
        if (this.source == null) {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public CreatedEvent(Session session, MIThreadCreatedEvent mIThreadCreatedEvent) {
        this.session = session;
        Target target = (Target)this.session.getCurrentTarget();
        this.source = target.getThread(mIThreadCreatedEvent.getId());
        if (this.source == null) {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public CreatedEvent(Session session, MIMemoryCreatedEvent mIMemoryCreatedEvent) {
        this.session = session;
        MemoryManager memoryManager = (MemoryManager)this.session.getMemoryManager();
        MemoryBlock[] memoryBlockArray = memoryManager.listMemoryBlocks();
        int n = 0;
        while (n < memoryBlockArray.length) {
            if (memoryBlockArray[n].getStartAddress() == mIMemoryCreatedEvent.getAddress() && memoryBlockArray[n].getLength() == mIMemoryCreatedEvent.getLength()) {
                this.source = memoryBlockArray[n];
                break;
            }
            ++n;
        }
        if (this.source == null) {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public CreatedEvent(Session session, MISharedLibCreatedEvent mISharedLibCreatedEvent) {
        this.session = session;
        SharedLibraryManager sharedLibraryManager = (SharedLibraryManager)this.session.getSharedLibraryManager();
        String string = mISharedLibCreatedEvent.getName();
        this.source = sharedLibraryManager.getSharedLibrary(string);
        if (this.source == null) {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public CreatedEvent(Session session, ICDIObject iCDIObject) {
        this.session = session;
        this.source = iCDIObject;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

