/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataWriteMemory;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIMemory;

public class MemoryBlock
extends CObject
implements ICDIMemoryBlock {
    MIDataReadMemoryInfo mem;
    String expression;
    boolean frozen;
    boolean dirty;

    public MemoryBlock(ICDITarget iCDITarget, String string, MIDataReadMemoryInfo mIDataReadMemoryInfo) {
        super(iCDITarget);
        this.expression = string;
        this.mem = mIDataReadMemoryInfo;
        this.frozen = true;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setMIDataReadMemoryInfo(MIDataReadMemoryInfo mIDataReadMemoryInfo) {
        this.mem = mIDataReadMemoryInfo;
    }

    public MIDataReadMemoryInfo getMIDataReadMemoryInfo() {
        return this.mem;
    }

    public boolean contains(Long[] longArray) {
        int n = 0;
        while (n < longArray.length) {
            if (this.contains(longArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean contains(Long l) {
        long l2 = this.getStartAddress();
        long l3 = this.getLength();
        return l2 <= l && l <= l2 + l3;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public byte[] getBytes() throws CDIException {
        MIMemory[] mIMemoryArray = this.mem.getMemories();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = 0;
        while (n < mIMemoryArray.length) {
            long[] lArray = mIMemoryArray[n].getData();
            int n2 = 0;
            while (n2 < lArray.length) {
                arrayList.add(new Long(lArray[n2]));
                ++n2;
            }
            ++n;
        }
        byte[] byArray = new byte[arrayList.size()];
        int n3 = 0;
        while (n3 < arrayList.size()) {
            Long l = (Long)arrayList.get(n3);
            byArray[n3] = l.byteValue();
            ++n3;
        }
        return byArray;
    }

    public void refresh() throws CDIException {
        MemoryManager memoryManager = (MemoryManager)this.getTarget().getSession().getMemoryManager();
        this.setDirty(true);
        Long[] longArray = memoryManager.update(this, null);
        if (longArray.length > 0) {
            MemoryBlock[] memoryBlockArray = memoryManager.listMemoryBlocks();
            int n = 0;
            while (n < memoryBlockArray.length) {
                if (!memoryBlockArray[n].equals(this) && memoryBlockArray[n].contains(longArray)) {
                    memoryBlockArray[n].setDirty(true);
                    memoryManager.update(memoryBlockArray[n], null);
                }
                ++n;
            }
        }
    }

    public long getLength() {
        return this.mem.getTotalBytes();
    }

    public long getStartAddress() {
        return this.mem.getAddress();
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean bl) {
        this.frozen = bl;
    }

    public void setValue(long l, byte[] byArray) throws CDIException {
        if (l >= this.getLength() || l + (long)byArray.length > this.getLength()) {
            throw new CDIException(CdiResources.getString("cdi.model.MemoryBlock.Bad_Offset"));
        }
        Session session = (Session)this.getTarget().getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        int n = 0;
        while (n < byArray.length) {
            long l2 = new Byte(byArray[n]).longValue() & 0xFFL;
            String string = "0x" + Long.toHexString(l2);
            MIDataWriteMemory mIDataWriteMemory = commandFactory.createMIDataWriteMemory(l + (long)n, this.expression, 0, 1, string);
            try {
                mISession.postCommand(mIDataWriteMemory);
                MIInfo mIInfo = mIDataWriteMemory.getMIInfo();
                if (mIInfo == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
            ++n;
        }
        this.refresh();
    }
}

