/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarListChildren;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarListChildrenInfo;

public class Register
extends Variable
implements ICDIRegister {
    public Register(RegisterObject registerObject, MIVar mIVar) {
        super(registerObject, mIVar);
    }

    public String getFullName() {
        String string;
        if (this.fullName == null && !(string = this.getName()).startsWith("$")) {
            this.fullName = "$" + string;
        }
        return this.fullName;
    }

    public ICDIVariable[] getChildren() throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        MISession mISession = session.getMISession();
        RegisterManager registerManager = (RegisterManager)session.getRegisterManager();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIVarListChildren mIVarListChildren = commandFactory.createMIVarListChildren(this.getMIVar().getVarName());
        try {
            mISession.postCommand(mIVarListChildren);
            MIVarListChildrenInfo mIVarListChildrenInfo = mIVarListChildren.getMIVarListChildrenInfo();
            if (mIVarListChildrenInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            MIVar[] mIVarArray = mIVarListChildrenInfo.getMIVars();
            this.children = new Register[mIVarArray.length];
            int n = 0;
            while (n < mIVarArray.length) {
                String string = mIVarArray[n].getExp();
                String string2 = this.isCPPLanguage() ? (string.equals("private") || string.equals("public") || string.equals("protected") ? this.getFullName() : String.valueOf(this.getFullName()) + "." + string) : String.valueOf(this.getFullName()) + "." + string;
                RegisterObject registerObject = new RegisterObject(this.getTarget(), string, string2, this.getPosition());
                this.children[n] = registerManager.createRegister(registerObject, mIVarArray[n]);
                ++n;
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        return this.children;
    }
}

