/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIExecNext;
import org.eclipse.cdt.debug.mi.core.command.MIExecNextInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecReturn;
import org.eclipse.cdt.debug.mi.core.command.MIExecRun;
import org.eclipse.cdt.debug.mi.core.command.MIExecStep;
import org.eclipse.cdt.debug.mi.core.command.MIExecStepInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecUntil;
import org.eclipse.cdt.debug.mi.core.command.MIInfoThreads;
import org.eclipse.cdt.debug.mi.core.command.MIJump;
import org.eclipse.cdt.debug.mi.core.command.MISignal;
import org.eclipse.cdt.debug.mi.core.command.MITargetDetach;
import org.eclipse.cdt.debug.mi.core.command.MIThreadSelect;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoThreadsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIThreadSelectInfo;

public class Target
implements ICDITarget {
    Session session;
    Thread[] noThreads = new Thread[0];
    Thread[] currentThreads;
    int currentThreadId;
    Command lastExecutionCommand;

    public Target(Session session) {
        this.session = session;
        this.currentThreads = this.noThreads;
    }

    public Session getCSession() {
        return this.session;
    }

    public Command getLastExecutionCommand() {
        return this.lastExecutionCommand;
    }

    public ICDISession getSession() {
        return this.session;
    }

    public ICDITarget getTarget() {
        return this;
    }

    public void setCurrentThread(ICDIThread iCDIThread) throws CDIException {
        if (!(iCDIThread instanceof Thread)) {
            throw new CDIException(CdiResources.getString("cdi.model.Target.Unknown_thread"));
        }
        this.setCurrentThread(iCDIThread, true);
    }

    public void setCurrentThread(ICDIThread iCDIThread, boolean bl) throws CDIException {
        if (!(iCDIThread instanceof Thread)) {
            throw new CDIException(CdiResources.getString("cdi.model.Target.Unknown_thread"));
        }
        this.setCurrentThread((Thread)iCDIThread, bl);
    }

    public void setCurrentThread(Thread thread, boolean bl) throws CDIException {
        MISession mISession;
        this.session.setCurrentTarget(this);
        int n = thread.getId();
        if (n == 0) {
            return;
        }
        if (this.currentThreadId != n) {
            Object object;
            Object object2;
            mISession = this.session.getMISession();
            CommandFactory commandFactory = mISession.getCommandFactory();
            MIThreadSelect mIThreadSelect = commandFactory.createMIThreadSelect(n);
            try {
                mISession.postCommand(mIThreadSelect);
                object2 = mIThreadSelect.getMIThreadSelectInfo();
                if (object2 == null) {
                    throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
                }
                this.currentThreadId = ((MIThreadSelectInfo)object2).getNewThreadId();
                object = ((MIThreadSelectInfo)object2).getFrame();
                if (object != null) {
                    int n2 = thread.getStackFrameCount();
                    thread.currentFrame = new StackFrame(thread, (MIFrame)object, n2 - ((MIFrame)object).getLevel());
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
            if (bl) {
                object2 = (RegisterManager)this.session.getRegisterManager();
                if (((Manager)object2).isAutoUpdate()) {
                    ((RegisterManager)object2).update();
                }
                if (((Manager)(object = (VariableManager)this.session.getVariableManager())).isAutoUpdate()) {
                    ((VariableManager)object).update();
                }
            }
        }
        if (this.currentThreadId != n) {
            mISession = this.session.getMISession();
            mISession.fireEvent(new MIThreadExitEvent(n));
            throw new CDIException(String.valueOf(CdiResources.getString("cdi.model.Target.Cannot_switch_to_thread")) + n);
        }
    }

    public void updateState(int n) {
        int n2;
        int n3;
        int n4;
        Thread[] threadArray = this.currentThreads;
        this.currentThreadId = n;
        try {
            this.currentThreads = this.getCThreads();
        }
        catch (CDIException cDIException) {
            this.currentThreads = this.noThreads;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.currentThreads.length);
        int n5 = 0;
        while (n5 < this.currentThreads.length) {
            n4 = 0;
            n3 = 0;
            while (n3 < threadArray.length) {
                if (this.currentThreads[n5].getId() == threadArray[n3].getId()) {
                    threadArray[n3].clearState();
                    this.currentThreads[n5] = threadArray[n3];
                    n4 = 1;
                    break;
                }
                ++n3;
            }
            if (n4 == 0) {
                arrayList.add(new Integer(this.currentThreads[n5].getId()));
            }
            ++n5;
        }
        if (!arrayList.isEmpty()) {
            MIEvent[] mIEventArray = new MIThreadCreatedEvent[arrayList.size()];
            n4 = 0;
            while (n4 < mIEventArray.length) {
                n3 = (Integer)arrayList.get(n4);
                mIEventArray[n4] = new MIThreadCreatedEvent(n3);
                ++n4;
            }
            MISession mISession = this.session.getMISession();
            mISession.fireEvents(mIEventArray);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(threadArray.length);
        int n6 = 0;
        while (n6 < threadArray.length) {
            n3 = 0;
            n2 = 0;
            while (n2 < this.currentThreads.length) {
                if (this.currentThreads[n2].getId() == threadArray[n6].getId()) {
                    n3 = 1;
                    break;
                }
                ++n2;
            }
            if (n3 == 0) {
                arrayList2.add(new Integer(threadArray[n6].getId()));
            }
            ++n6;
        }
        if (!arrayList2.isEmpty()) {
            MIEvent[] mIEventArray = new MIThreadExitEvent[arrayList2.size()];
            n3 = 0;
            while (n3 < mIEventArray.length) {
                n2 = (Integer)arrayList2.get(n3);
                mIEventArray[n3] = new MIThreadExitEvent(n2);
                ++n3;
            }
            MISession mISession = this.session.getMISession();
            mISession.fireEvents(mIEventArray);
        }
    }

    public Thread[] getCThreads() throws CDIException {
        Thread[] threadArray = this.noThreads;
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIInfoThreads mIInfoThreads = commandFactory.createMIInfoThreads();
        try {
            String[] stringArray;
            int[] nArray;
            mISession.postCommand(mIInfoThreads);
            MIInfoThreadsInfo mIInfoThreadsInfo = mIInfoThreads.getMIInfoThreadsInfo();
            if (mIInfoThreadsInfo == null) {
                nArray = new int[]{};
                stringArray = new String[]{};
            } else {
                nArray = mIInfoThreadsInfo.getThreadIds();
                stringArray = mIInfoThreadsInfo.getThreadNames();
            }
            if (nArray != null && nArray.length > 0) {
                threadArray = new Thread[nArray.length];
                if (stringArray != null && stringArray.length == nArray.length) {
                    int n = 0;
                    while (n < nArray.length) {
                        threadArray[n] = new Thread(this, nArray[n], stringArray[n]);
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < nArray.length) {
                        threadArray[n] = new Thread(this, nArray[n]);
                        ++n;
                    }
                }
            } else {
                threadArray = new Thread[]{new Thread(this, 0)};
            }
            this.currentThreadId = mIInfoThreadsInfo.getCurrentThread();
            if (this.currentThreadId == 0 && threadArray.length > 0) {
                this.currentThreadId = threadArray[0].getId();
            }
        }
        catch (MIException mIException) {
            throw new CDIException(mIException.getMessage());
        }
        return threadArray;
    }

    public ICDIThread getCurrentThread() throws CDIException {
        ICDIThread[] iCDIThreadArray = this.getThreads();
        int n = 0;
        while (n < iCDIThreadArray.length) {
            Thread thread = (Thread)iCDIThreadArray[n];
            if (thread.getId() == this.currentThreadId) {
                return thread;
            }
            ++n;
        }
        return null;
    }

    public ICDIThread[] getThreads() throws CDIException {
        if (this.currentThreads.length == 0) {
            this.currentThreads = this.getCThreads();
        }
        return this.currentThreads;
    }

    public ICDIThread getThread(int n) {
        Thread thread = null;
        if (this.currentThreads != null) {
            int n2 = 0;
            while (n2 < this.currentThreads.length) {
                Thread thread2 = this.currentThreads[n2];
                if (thread2.getId() == n) {
                    thread = thread2;
                    break;
                }
                ++n2;
            }
        }
        return thread;
    }

    public void restart() throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIExecRun mIExecRun = commandFactory.createMIExecRun(new String[0]);
        this.lastExecutionCommand = mIExecRun;
        try {
            mISession.postCommand(mIExecRun);
            MIInfo mIInfo = mIExecRun.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void resume() throws CDIException {
        block7: {
            MISession mISession = this.session.getMISession();
            if (mISession.getMIInferior().isRunning()) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Inferior_already_running"));
            }
            if (mISession.getMIInferior().isSuspended()) {
                CommandFactory commandFactory = mISession.getCommandFactory();
                MIExecContinue mIExecContinue = commandFactory.createMIExecContinue();
                this.lastExecutionCommand = mIExecContinue;
                try {
                    mISession.postCommand(mIExecContinue);
                    MIInfo mIInfo = mIExecContinue.getMIInfo();
                    if (mIInfo == null) {
                        throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
                    }
                    break block7;
                }
                catch (MIException mIException) {
                    throw new MI2CDIException(mIException);
                }
            }
            if (mISession.getMIInferior().isTerminated()) {
                this.restart();
            } else {
                this.restart();
            }
        }
    }

    public void stepInto() throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIExecStep mIExecStep = commandFactory.createMIExecStep();
        this.lastExecutionCommand = mIExecStep;
        try {
            mISession.postCommand(mIExecStep);
            MIInfo mIInfo = mIExecStep.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void stepIntoInstruction() throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIExecStepInstruction mIExecStepInstruction = commandFactory.createMIExecStepInstruction();
        this.lastExecutionCommand = mIExecStepInstruction;
        try {
            mISession.postCommand(mIExecStepInstruction);
            MIInfo mIInfo = mIExecStepInstruction.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void stepOver() throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIExecNext mIExecNext = commandFactory.createMIExecNext();
        this.lastExecutionCommand = mIExecNext;
        try {
            mISession.postCommand(mIExecNext);
            MIInfo mIInfo = mIExecNext.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void stepOverInstruction() throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIExecNextInstruction mIExecNextInstruction = commandFactory.createMIExecNextInstruction();
        this.lastExecutionCommand = mIExecNextInstruction;
        try {
            mISession.postCommand(mIExecNextInstruction);
            MIInfo mIInfo = mIExecNextInstruction.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void stepReturn() throws CDIException {
        this.stepReturn(true);
    }

    public void stepReturn(boolean bl) throws CDIException {
        if (bl) {
            this.finish();
        } else {
            this.execReturn();
        }
    }

    protected void finish() throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIExecFinish mIExecFinish = commandFactory.createMIExecFinish();
        this.lastExecutionCommand = mIExecFinish;
        try {
            mISession.postCommand(mIExecFinish);
            MIInfo mIInfo = mIExecFinish.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    protected void execReturn() throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIExecReturn mIExecReturn = commandFactory.createMIExecReturn();
        this.lastExecutionCommand = mIExecReturn;
        try {
            mISession.postCommand(mIExecReturn);
            MIInfo mIInfo = mIExecReturn.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void suspend() throws CDIException {
        MISession mISession = this.session.getMISession();
        try {
            mISession.getMIInferior().interrupt();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void disconnect() throws CDIException {
        Object object;
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MITargetDetach mITargetDetach = commandFactory.createMITargetDetach();
        try {
            mISession.postCommand(mITargetDetach);
            object = mITargetDetach.getMIInfo();
            if (object == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        object = this.session.getMISession();
        ((MISession)object).fireEvent(new MIDetachedEvent(mITargetDetach.getToken()));
        this.session.getMISession().getMIInferior().setDisconnected();
    }

    public void runUntil(ICDILocation iCDILocation) throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        String string = "";
        if (iCDILocation.getFile() != null && iCDILocation.getFile().length() > 0) {
            string = String.valueOf(iCDILocation.getFile()) + ":" + iCDILocation.getLineNumber();
        } else if (iCDILocation.getFunction() != null && iCDILocation.getFunction().length() > 0) {
            string = iCDILocation.getFunction();
        } else if (iCDILocation.getAddress() != 0L) {
            string = "*" + iCDILocation.getAddress();
        }
        MIExecUntil mIExecUntil = commandFactory.createMIExecUntil(string);
        this.lastExecutionCommand = mIExecUntil;
        try {
            mISession.postCommand(mIExecUntil);
            MIInfo mIInfo = mIExecUntil.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void jump(ICDILocation iCDILocation) throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        String string = "";
        if (iCDILocation.getFile() != null && iCDILocation.getFile().length() > 0) {
            string = String.valueOf(iCDILocation.getFile()) + ":" + iCDILocation.getLineNumber();
        } else if (iCDILocation.getFunction() != null && iCDILocation.getFunction().length() > 0) {
            string = iCDILocation.getFunction();
        } else if (iCDILocation.getAddress() != 0L) {
            string = "*" + iCDILocation.getAddress();
        }
        MIJump mIJump = commandFactory.createMIJump(string);
        this.lastExecutionCommand = mIJump;
        try {
            mISession.postCommand(mIJump);
            MIInfo mIInfo = mIJump.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public String evaluateExpressionToString(String string) throws CDIException {
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIDataEvaluateExpression mIDataEvaluateExpression = commandFactory.createMIDataEvaluateExpression(string);
        try {
            mISession.postCommand(mIDataEvaluateExpression);
            MIDataEvaluateExpressionInfo mIDataEvaluateExpressionInfo = mIDataEvaluateExpression.getMIDataEvaluateExpressionInfo();
            if (mIDataEvaluateExpressionInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
            return mIDataEvaluateExpressionInfo.getExpression();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void terminate() throws CDIException {
        try {
            this.session.getMISession().getMIInferior().terminate();
        }
        catch (MIException mIException) {
            this.session.terminate();
        }
    }

    public boolean isTerminated() {
        return this.session.getMISession().getMIInferior().isTerminated();
    }

    public boolean isDisconnected() {
        return !this.session.getMISession().getMIInferior().isConnected();
    }

    public boolean isSuspended() {
        return this.session.getMISession().getMIInferior().isSuspended();
    }

    public boolean isRunning() {
        return this.session.getMISession().getMIInferior().isRunning();
    }

    public Process getProcess() {
        return this.session.getMISession().getMIInferior();
    }

    public void signal() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MISignal mISignal = commandFactory.createMISignal("0");
        try {
            mISession.postCommand(mISignal);
            MIInfo mIInfo = mISignal.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void signal(ICDISignal iCDISignal) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MISignal mISignal = commandFactory.createMISignal(iCDISignal.getName());
        try {
            mISession.postCommand(mISignal);
            MIInfo mIInfo = mISignal.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }
}

