/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.output.MIVarEvaluateExpressionInfo;

public class Value
extends CObject
implements ICDIValue {
    protected Variable variable;

    public Value(Variable variable) {
        super(variable.getTarget());
        this.variable = variable;
    }

    public String getTypeName() throws CDIException {
        return this.variable.getTypeName();
    }

    public String getValueString() throws CDIException {
        String string = "";
        MISession mISession = ((Session)this.getTarget().getSession()).getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIVarEvaluateExpression mIVarEvaluateExpression = commandFactory.createMIVarEvaluateExpression(this.variable.getMIVar().getVarName());
        try {
            mISession.postCommand(mIVarEvaluateExpression);
            MIVarEvaluateExpressionInfo mIVarEvaluateExpressionInfo = mIVarEvaluateExpression.getMIVarEvaluateExpressionInfo();
            if (mIVarEvaluateExpressionInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            string = mIVarEvaluateExpressionInfo.getValue();
        }
        catch (MIException mIException) {
            throw new CDIException(mIException.getMessage());
        }
        return string;
    }

    public int getChildrenNumber() throws CDIException {
        return this.variable.getMIVar().getNumChild();
    }

    public boolean hasChildren() throws CDIException {
        return this.getChildrenNumber() > 0;
    }

    public ICDIVariable[] getVariables() throws CDIException {
        return this.variable.getChildren();
    }
}

