/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterManager;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIBoolType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDICharType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDoubleType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIEnumType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFunctionType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongLongType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIShortType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIStructType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIWCharType;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Format;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Expression;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.Value;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ArrayValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.BoolValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.CharValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.DoubleValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.EnumValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FloatValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FunctionValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IntValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongLongValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.PointerValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ReferenceValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ShortValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.StructValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.WCharValue;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarAssign;
import org.eclipse.cdt.debug.mi.core.command.MIVarInfoExpression;
import org.eclipse.cdt.debug.mi.core.command.MIVarListChildren;
import org.eclipse.cdt.debug.mi.core.command.MIVarSetFormat;
import org.eclipse.cdt.debug.mi.core.command.MIVarShowAttributes;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarInfoExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarListChildrenInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarShowAttributesInfo;

public class Variable
extends VariableObject
implements ICDIVariable {
    MIVar miVar;
    Value value;
    ICDIVariable[] children = new ICDIVariable[0];
    String editable = null;
    String language;
    boolean isFake = false;

    public Variable(VariableObject variableObject, MIVar mIVar) {
        super(variableObject);
        this.miVar = mIVar;
    }

    public Variable(ICDITarget iCDITarget, String string, String string2, ICDIStackFrame iCDIStackFrame, int n, int n2, MIVar mIVar) {
        super(iCDITarget, string, string2, iCDIStackFrame, n, n2);
        this.miVar = mIVar;
    }

    public MIVar getMIVar() {
        return this.miVar;
    }

    public Variable getChild(String string) {
        int n = 0;
        while (n < this.children.length) {
            Variable variable = (Variable)this.children[n];
            if (string.equals(variable.getMIVar().getVarName())) {
                return variable;
            }
            Variable variable2 = variable.getChild(string);
            if (variable2 != null) {
                return variable2;
            }
            ++n;
        }
        return null;
    }

    String getLanguage() throws CDIException {
        if (this.language == null) {
            Session session = (Session)this.getTarget().getSession();
            MISession mISession = session.getMISession();
            CommandFactory commandFactory = mISession.getCommandFactory();
            MIVarInfoExpression mIVarInfoExpression = commandFactory.createMIVarInfoExpression(this.getMIVar().getVarName());
            try {
                mISession.postCommand(mIVarInfoExpression);
                MIVarInfoExpressionInfo mIVarInfoExpressionInfo = mIVarInfoExpression.getMIVarInfoExpressionInfo();
                if (mIVarInfoExpressionInfo == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                this.language = mIVarInfoExpressionInfo.getLanguage();
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        return this.language == null ? "" : this.language;
    }

    boolean isCPPLanguage() throws CDIException {
        return this.getLanguage().equalsIgnoreCase("C++");
    }

    void setIsFake(boolean bl) {
        this.isFake = bl;
    }

    boolean isFake() {
        return this.isFake;
    }

    public ICDIVariable[] getChildren() throws CDIException {
        return this.getChildren(-1);
    }

    public ICDIVariable[] getChildren(int n) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIVarListChildren mIVarListChildren = commandFactory.createMIVarListChildren(this.getMIVar().getVarName());
        try {
            if (n >= 0) {
                mISession.postCommand(mIVarListChildren, n);
            } else {
                mISession.postCommand(mIVarListChildren);
            }
            MIVarListChildrenInfo mIVarListChildrenInfo = mIVarListChildren.getMIVarListChildrenInfo();
            if (mIVarListChildrenInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            MIVar[] mIVarArray = mIVarListChildrenInfo.getMIVars();
            this.children = new Variable[mIVarArray.length];
            int n2 = 0;
            while (n2 < mIVarArray.length) {
                Object object;
                String string = this.getFullName();
                String string2 = mIVarArray[n2].getExp();
                ICDIType iCDIType = null;
                boolean bl = false;
                ICDIType iCDIType2 = this.getType();
                if (iCDIType2 instanceof ICDIArrayType) {
                    string = "(" + string + ")[" + n2 + "]";
                    int n3 = this.castingIndex + n2;
                    string2 = String.valueOf(this.getName()) + "[" + n3 + "]";
                } else if (iCDIType2 instanceof ICDIPointerType) {
                    object = ((ICDIPointerType)iCDIType2).getComponentType();
                    if (object instanceof ICDIStructType) {
                        if (this.isCPPLanguage()) {
                            if (!this.isFake() || this.isFake() && !this.name.equals("private") && !this.name.equals("public") && !this.name.equals("protected")) {
                                bl = true;
                                iCDIType = iCDIType2;
                            } else {
                                string = "(" + string + ")->" + mIVarArray[n2].getExp();
                            }
                        } else {
                            string = "(" + string + ")->" + mIVarArray[n2].getExp();
                        }
                    } else {
                        string = "*(" + string + ")";
                    }
                } else if (iCDIType2 instanceof ICDIStructType) {
                    if (this.isCPPLanguage()) {
                        if (!this.isFake() || this.isFake() && !this.name.equals("private") && !this.name.equals("public") && !this.name.equals("protected")) {
                            bl = true;
                            iCDIType = iCDIType2;
                        } else {
                            string = "(" + string + ")." + mIVarArray[n2].getExp();
                        }
                    } else {
                        string = "(" + string + ")." + mIVarArray[n2].getExp();
                    }
                }
                object = new Variable(this.getTarget(), string2, string, this.getStackFrame(), this.getPosition(), this.getStackDepth(), mIVarArray[n2]);
                if (iCDIType != null) {
                    ((Variable)object).type = iCDIType;
                }
                ((Variable)object).setIsFake(bl);
                this.children[n2] = object;
                ++n2;
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        return this.children;
    }

    public int getChildrenNumber() throws CDIException {
        return this.miVar.getNumChild();
    }

    public ICDIValue getValue() throws CDIException {
        if (this.value == null) {
            ICDIType iCDIType = this.getType();
            this.value = iCDIType instanceof ICDIBoolType ? new BoolValue(this) : (iCDIType instanceof ICDICharType ? new CharValue(this) : (iCDIType instanceof ICDIWCharType ? new WCharValue(this) : (iCDIType instanceof ICDIShortType ? new ShortValue(this) : (iCDIType instanceof ICDIIntType ? new IntValue(this) : (iCDIType instanceof ICDILongType ? new LongValue(this) : (iCDIType instanceof ICDILongLongType ? new LongLongValue(this) : (iCDIType instanceof ICDIEnumType ? new EnumValue(this) : (iCDIType instanceof ICDIFloatType ? new FloatValue(this) : (iCDIType instanceof ICDIDoubleType ? new DoubleValue(this) : (iCDIType instanceof ICDIFunctionType ? new FunctionValue(this) : (iCDIType instanceof ICDIPointerType ? new PointerValue(this) : (iCDIType instanceof ICDIReferenceType ? new ReferenceValue(this) : (iCDIType instanceof ICDIArrayType ? new ArrayValue(this) : (iCDIType instanceof ICDIStructType ? new StructValue(this) : new Value(this)))))))))))))));
        }
        return this.value;
    }

    public void setValue(ICDIValue iCDIValue) throws CDIException {
        this.setValue(iCDIValue.getValueString());
    }

    public void setValue(String string) throws CDIException {
        Object object;
        Session session = (Session)this.getTarget().getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIVarAssign mIVarAssign = commandFactory.createMIVarAssign(this.miVar.getVarName(), string);
        try {
            mISession.postCommand(mIVarAssign);
            object = mIVarAssign.getMIInfo();
            if (object == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        object = new MIVarChangedEvent(mIVarAssign.getToken(), this.miVar.getVarName());
        mISession.fireEvent((MIEvent)object);
        if (this instanceof Register) {
            ICDIRegisterManager iCDIRegisterManager = session.getRegisterManager();
            if (iCDIRegisterManager.isAutoUpdate()) {
                iCDIRegisterManager.update();
            }
        } else if (this instanceof Expression) {
            ICDIExpressionManager iCDIExpressionManager = session.getExpressionManager();
            if (iCDIExpressionManager.isAutoUpdate()) {
                iCDIExpressionManager.update();
            }
        } else {
            ICDIVariableManager iCDIVariableManager = session.getVariableManager();
            if (iCDIVariableManager.isAutoUpdate()) {
                iCDIVariableManager.update();
            }
        }
    }

    public boolean isEditable() throws CDIException {
        if (this.editable == null) {
            MISession mISession = ((Session)this.getTarget().getSession()).getMISession();
            CommandFactory commandFactory = mISession.getCommandFactory();
            MIVarShowAttributes mIVarShowAttributes = commandFactory.createMIVarShowAttributes(this.miVar.getVarName());
            try {
                mISession.postCommand(mIVarShowAttributes);
                MIVarShowAttributesInfo mIVarShowAttributesInfo = mIVarShowAttributes.getMIVarShowAttributesInfo();
                if (mIVarShowAttributesInfo == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                this.editable = String.valueOf(mIVarShowAttributesInfo.isEditable());
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        return this.editable == null ? false : this.editable.equalsIgnoreCase("true");
    }

    public void setFormat(int n) throws CDIException {
        int n2 = Format.toMIFormat(n);
        MISession mISession = ((Session)this.getTarget().getSession()).getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIVarSetFormat mIVarSetFormat = commandFactory.createMIVarSetFormat(this.miVar.getVarName(), n2);
        try {
            mISession.postCommand(mIVarSetFormat);
            MIInfo mIInfo = mIVarSetFormat.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public boolean equals(ICDIVariableObject iCDIVariableObject) {
        if (iCDIVariableObject instanceof Variable) {
            Variable variable = (Variable)iCDIVariableObject;
            return this.miVar.getVarName().equals(variable.getMIVar().getVarName());
        }
        return super.equals(iCDIVariableObject);
    }
}

