/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFunctionType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIStructType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIVoidType;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IncompleteType;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;

public class VariableObject
extends CObject
implements ICDIVariableObject {
    String castingType;
    int castingIndex;
    int castingLength;
    String name;
    int position;
    ICDIStackFrame frame;
    int stackdepth;
    String qualifiedName = null;
    String fullName = null;
    ICDIType type = null;
    String typename = null;
    String sizeof = null;

    public VariableObject(VariableObject variableObject) {
        super(variableObject.getTarget());
        this.name = variableObject.getName();
        this.fullName = variableObject.fullName;
        this.sizeof = variableObject.sizeof;
        this.type = variableObject.type;
        try {
            this.frame = variableObject.getStackFrame();
        }
        catch (CDIException cDIException) {}
        this.position = variableObject.getPosition();
        this.stackdepth = variableObject.getStackDepth();
        this.castingIndex = variableObject.getCastingArrayStart();
        this.castingLength = variableObject.getCastingArrayEnd();
        this.castingType = variableObject.getCastingType();
    }

    public VariableObject(ICDITarget iCDITarget, String string, ICDIStackFrame iCDIStackFrame, int n, int n2) {
        this(iCDITarget, string, null, iCDIStackFrame, n, n2);
    }

    public VariableObject(ICDITarget iCDITarget, String string, String string2, ICDIStackFrame iCDIStackFrame, int n, int n2) {
        super(iCDITarget);
        this.name = string;
        this.fullName = string2;
        this.frame = iCDIStackFrame;
        this.position = n;
        this.stackdepth = n2;
    }

    public int getPosition() {
        return this.position;
    }

    public int getStackDepth() {
        return this.stackdepth;
    }

    public void setCastingArrayStart(int n) {
        this.castingIndex = n;
    }

    public int getCastingArrayStart() {
        return this.castingIndex;
    }

    public void setCastingArrayEnd(int n) {
        this.castingLength = n;
    }

    public int getCastingArrayEnd() {
        return this.castingLength;
    }

    public void setCastingType(String string) {
        this.castingType = string;
    }

    public String getCastingType() {
        return this.castingType;
    }

    public String encodeVariable() {
        String string = this.getFullName();
        if (this.castingLength > 0 || this.castingIndex > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("*(");
            stringBuffer.append('(').append(string).append(')');
            if (this.castingIndex != 0) {
                stringBuffer.append('+').append(this.castingIndex);
            }
            stringBuffer.append(')');
            stringBuffer.append('@').append(this.castingLength);
            string = stringBuffer.toString();
        } else if (this.castingType != null && this.castingType.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("((").append(this.castingType).append(')');
            stringBuffer.append(string).append(')');
            string = stringBuffer.toString();
        }
        return string;
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.getName();
        }
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public ICDIType getType() throws CDIException {
        if (this.type == null) {
            ICDITarget iCDITarget = this.getTarget();
            Session session = (Session)iCDITarget.getSession();
            SourceManager sourceManager = (SourceManager)session.getSourceManager();
            String string = sourceManager.getTypeName(this.getQualifiedName());
            try {
                this.type = sourceManager.getType(iCDITarget, string);
            }
            catch (CDIException cDIException) {
                try {
                    String string2 = sourceManager.getDetailTypeName(string);
                    this.type = sourceManager.getType(iCDITarget, string2);
                }
                catch (CDIException cDIException2) {
                    try {
                        String string3 = sourceManager.getDetailTypeName(this.getQualifiedName());
                        this.type = sourceManager.getType(iCDITarget, string3);
                    }
                    catch (CDIException cDIException3) {}
                }
            }
            if (this.type == null) {
                this.type = new IncompleteType(iCDITarget, string);
            }
        }
        return this.type;
    }

    public int sizeof() throws CDIException {
        if (this.sizeof == null) {
            ICDITarget iCDITarget = this.getTarget();
            Session session = (Session)iCDITarget.getSession();
            MISession mISession = session.getMISession();
            CommandFactory commandFactory = mISession.getCommandFactory();
            String string = "sizeof(" + this.getTypeName() + ")";
            MIDataEvaluateExpression mIDataEvaluateExpression = commandFactory.createMIDataEvaluateExpression(string);
            try {
                mISession.postCommand(mIDataEvaluateExpression);
                MIDataEvaluateExpressionInfo mIDataEvaluateExpressionInfo = mIDataEvaluateExpression.getMIDataEvaluateExpressionInfo();
                if (mIDataEvaluateExpressionInfo == null) {
                    throw new CDIException(CdiResources.getString("cdi.model.VariableObject.Target_not_responding"));
                }
                this.sizeof = mIDataEvaluateExpressionInfo.getExpression();
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        if (this.sizeof != null) {
            try {
                return Integer.parseInt(this.sizeof);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CDIException(numberFormatException.getMessage());
            }
        }
        return 0;
    }

    public boolean isEditable() throws CDIException {
        ICDIType iCDIType = this.getType();
        return !(iCDIType instanceof ICDIArrayType) && !(iCDIType instanceof ICDIStructType) && !(iCDIType instanceof ICDIVoidType) && !(iCDIType instanceof ICDIFunctionType);
    }

    public ICDIStackFrame getStackFrame() throws CDIException {
        return this.frame;
    }

    public String getTypeName() throws CDIException {
        if (this.typename == null) {
            ICDIType iCDIType = this.getType();
            this.typename = iCDIType.getTypeName();
        }
        return this.typename;
    }

    public boolean hasChildren() throws CDIException {
        ICDIType iCDIType = this.getType();
        if (iCDIType instanceof ICDIReferenceType) {
            iCDIType = ((ICDIReferenceType)iCDIType).getComponentType();
        }
        if (iCDIType instanceof ICDIArrayType || iCDIType instanceof ICDIStructType) {
            return true;
        }
        if (iCDIType instanceof ICDIPointerType) {
            ICDIType iCDIType2 = ((ICDIPointerType)iCDIType).getComponentType();
            return !(iCDIType2 instanceof ICDIVoidType);
        }
        return false;
    }

    public String getQualifiedName() throws CDIException {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.encodeVariable();
        }
        return this.qualifiedName;
    }

    public boolean equals(ICDIVariableObject iCDIVariableObject) {
        VariableObject variableObject;
        if (iCDIVariableObject instanceof VariableObject && (variableObject = (VariableObject)iCDIVariableObject).getName().equals(this.getName()) && variableObject.getCastingArrayStart() == this.getCastingArrayStart() && variableObject.getCastingArrayEnd() == this.getCastingArrayEnd() && (variableObject.getCastingType() == null && this.getCastingType() == null || variableObject.getCastingType() != null && this.getCastingType() != null && variableObject.getCastingType().equals(this.getCastingType()))) {
            ICDIStackFrame iCDIStackFrame = null;
            ICDIStackFrame iCDIStackFrame2 = null;
            try {
                iCDIStackFrame = variableObject.getStackFrame();
                iCDIStackFrame2 = this.getStackFrame();
            }
            catch (CDIException cDIException) {}
            if (iCDIStackFrame2 == null && iCDIStackFrame == null) {
                return true;
            }
            if (iCDIStackFrame != null && iCDIStackFrame2 != null && iCDIStackFrame.equals(iCDIStackFrame2) && variableObject.getStackDepth() == this.getStackDepth() && variableObject.getPosition() == this.getPosition()) {
                return true;
            }
        }
        return super.equals(iCDIVariableObject);
    }
}

