/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;

public class Watchpoint
extends Breakpoint
implements ICDIWatchpoint {
    int watchType;
    String what;

    public Watchpoint(BreakpointManager breakpointManager, String string, int n, int n2, ICDICondition iCDICondition) {
        super(breakpointManager, n, null, iCDICondition, "");
        this.watchType = n2;
        this.what = string;
    }

    public Watchpoint(BreakpointManager breakpointManager, MIBreakpoint mIBreakpoint) {
        super(breakpointManager, mIBreakpoint);
    }

    public String getWatchExpression() throws CDIException {
        MIBreakpoint mIBreakpoint = this.getMIBreakpoint();
        if (mIBreakpoint != null) {
            return this.getMIBreakpoint().getWhat();
        }
        return this.what;
    }

    public boolean isReadType() {
        MIBreakpoint mIBreakpoint = this.getMIBreakpoint();
        if (mIBreakpoint != null) {
            return this.getMIBreakpoint().isReadWatchpoint() || this.getMIBreakpoint().isAccessWatchpoint();
        }
        return (this.watchType & 2) == 2;
    }

    public boolean isWriteType() {
        MIBreakpoint mIBreakpoint = this.getMIBreakpoint();
        if (mIBreakpoint != null) {
            return this.getMIBreakpoint().isAccessWatchpoint() || this.getMIBreakpoint().isWriteWatchpoint();
        }
        return (this.watchType & 1) == 1;
    }
}

