/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model.type;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatingPointValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.Value;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;

public abstract class FloatingPointValue
extends Value
implements ICDIFloatingPointValue {
    public FloatingPointValue(Variable variable) {
        super(variable);
    }

    public double doubleValue() throws CDIException {
        double d = 0.0;
        String string = this.getValueString();
        if (this.isNaN(string)) {
            d = Double.NaN;
        } else if (this.isNegativeInfinity(string)) {
            d = Double.NEGATIVE_INFINITY;
        } else if (this.isPositiveInfinity(string)) {
            d = Double.POSITIVE_INFINITY;
        } else {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d;
    }

    public float floatValue() throws CDIException {
        float f = 0.0f;
        String string = this.getValueString();
        if (this.isNaN(string)) {
            f = Float.NaN;
        } else if (this.isNegativeInfinity(string)) {
            f = Float.NEGATIVE_INFINITY;
        } else if (this.isPositiveInfinity(string)) {
            f = Float.POSITIVE_INFINITY;
        } else {
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f;
    }

    private boolean isPositiveInfinity(String string) {
        return string != null ? string.indexOf("inf") != -1 : false;
    }

    private boolean isNegativeInfinity(String string) {
        return string != null ? string.indexOf("-inf") != -1 : false;
    }

    private boolean isNaN(String string) {
        return string != null ? string.indexOf("nan") != -1 : false;
    }
}

